Liferay.Loader.define("layout-content-page-editor-web@2.0.74/page_editor/app/components/GlobalContext", ['module', 'exports', 'require', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dom', '../../common/components/RawDOM', '../config/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = GlobalContextProvider;
    exports.useGlobalContext = useGlobalContext;

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactDom = require("frontend-js-react-web$react-dom");

    var _RawDOM = _interopRequireDefault(require("../../common/components/RawDOM"));

    var _index = require("../config/index");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var GlobalContext = _react["default"].createContext({
      document: document,
      window: window
    });

    function GlobalContextProvider(_ref) {
      var children = _ref.children,
          useIframe = _ref.useIframe;

      var _useState = (0, _react.useState)(null),
          _useState2 = _slicedToArray(_useState, 2),
          baseElement = _useState2[0],
          setBaseElement = _useState2[1];

      var localContext = (0, _react.useMemo)(function () {
        return {
          document: document,
          window: window
        };
      }, []);

      var _useState3 = (0, _react.useState)(null),
          _useState4 = _slicedToArray(_useState3, 2),
          iframeContext = _useState4[0],
          setIFrameContext = _useState4[1];

      var _useState5 = (0, _react.useState)(null),
          _useState6 = _slicedToArray(_useState5, 2),
          iframeElement = _useState6[0],
          setIframeElement = _useState6[1];

      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();
      (0, _react.useEffect)(function () {
        var timeoutId = null;

        var handleIframeLoaded = function handleIframeLoaded() {
          if (!isMounted() || !iframeElement) {
            return;
          }

          var pageEditorStylesLinkId = "".concat(_index.config.portletNamespace, "pageEditorStylesLink");

          if (!iframeElement.contentDocument.getElementById(pageEditorStylesLinkId)) {
            var pageEditorStylesLink = iframeElement.contentDocument.createElement('link');
            pageEditorStylesLink.id = pageEditorStylesLinkId;
            pageEditorStylesLink.rel = 'stylesheet';
            pageEditorStylesLink.href = _index.config.getIframeContentCssURL;
            iframeElement.contentDocument.head.appendChild(pageEditorStylesLink);
          }

          var element = iframeElement.contentDocument && iframeElement.contentDocument.getElementById('content');

          if (element) {
            element.innerHTML = '';
            iframeElement.contentWindow.requestAnimationFrame(function () {
              setBaseElement(element);
              setIFrameContext({
                document: iframeElement.contentDocument,
                iframe: iframeElement,
                window: iframeElement.contentWindow
              });
            });
          } else {
            timeoutId = setTimeout(handleIframeLoaded, 100);
          }
        };

        if (iframeElement) {
          iframeElement.addEventListener('load', handleIframeLoaded);
          iframeElement.src = _index.config.getIframeContentURL;
          iframeElement.classList.add('page-editor__global-context-iframe');
        }

        return function () {
          clearTimeout(timeoutId);

          if (iframeElement) {
            iframeElement.removeEventListener('load', handleIframeLoaded);
          }

          if (isMounted()) {
            setBaseElement(null);
            setIFrameContext(null);
          }
        };
      }, [iframeElement, isMounted]);
      var context;
      var content;

      if (useIframe && baseElement && iframeContext) {
        content = (0, _reactDom.createPortal)(_react["default"].createElement(_react["default"].Fragment, null, children), baseElement);
        context = iframeContext;
        iframeElement.classList.remove('page-editor__global-context-iframe--hidden', 'page-editor__global-context-iframe--loading');
      } else if (!useIframe) {
        content = _react["default"].createElement(_react["default"].Fragment, null, children);
        context = localContext;

        if (iframeElement) {
          iframeElement.classList.add('page-editor__global-context-iframe--hidden');
        }
      } else {
        iframeElement.classList.add('page-editor__global-context-iframe--loading');
      }

      return _react["default"].createElement(GlobalContext.Provider, {
        value: context
      }, content, _react["default"].createElement(_RawDOM["default"], {
        elementRef: setIframeElement,
        TagName: "iframe"
      }));
    }

    function useGlobalContext() {
      return (0, _react.useContext)(GlobalContext);
    }
    //# sourceMappingURL=GlobalContext.js.map
  }
});
//# sourceMappingURL=GlobalContext.js.map