Liferay.Loader.define('layout-content-page-editor-web$lodash-es@4.17.15/snakeCase', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import createCompounder from './_createCompounder.js';

    /**
     * Converts `string` to
     * [snake case](https://en.wikipedia.org/wiki/Snake_case).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the snake cased string.
     * @example
     *
     * _.snakeCase('Foo Bar');
     * // => 'foo_bar'
     *
     * _.snakeCase('fooBar');
     * // => 'foo_bar'
     *
     * _.snakeCase('--FOO-BAR--');
     * // => 'foo_bar'
     */
    var snakeCase = createCompounder(function (result, word, index) {
      return result + (index ? '_' : '') + word.toLowerCase();
    });

    export default snakeCase;
  }
});
//# sourceMappingURL=snakeCase.js.map