Liferay.Loader.define('layout-content-page-editor-web$lodash-es@4.17.15/_cloneMap', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import addMapEntry from './_addMapEntry.js';
    import arrayReduce from './_arrayReduce.js';
    import mapToArray from './_mapToArray.js';

    /** Used to compose bitmasks for cloning. */
    var CLONE_DEEP_FLAG = 1;

    /**
     * Creates a clone of `map`.
     *
     * @private
     * @param {Object} map The map to clone.
     * @param {Function} cloneFunc The function to clone values.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @returns {Object} Returns the cloned map.
     */
    function cloneMap(map, isDeep, cloneFunc) {
      var array = isDeep ? cloneFunc(mapToArray(map), CLONE_DEEP_FLAG) : mapToArray(map);
      return arrayReduce(array, addMapEntry, new map.constructor());
    }

    export default cloneMap;
  }
});
//# sourceMappingURL=_cloneMap.js.map