Liferay.Loader.define('layout-content-page-editor-web$lodash-es@4.17.11/forInRight', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseForRight from './_baseForRight.js';
  import castFunction from './_castFunction.js';
  import keysIn from './keysIn.js';

  /**
   * This method is like `_.forIn` except that it iterates over properties of
   * `object` in the opposite order.
   *
   * @static
   * @memberOf _
   * @since 2.0.0
   * @category Object
   * @param {Object} object The object to iterate over.
   * @param {Function} [iteratee=_.identity] The function invoked per iteration.
   * @returns {Object} Returns `object`.
   * @see _.forIn
   * @example
   *
   * function Foo() {
   *   this.a = 1;
   *   this.b = 2;
   * }
   *
   * Foo.prototype.c = 3;
   *
   * _.forInRight(new Foo, function(value, key) {
   *   console.log(key);
   * });
   * // => Logs 'c', 'b', then 'a' assuming `_.forIn` logs 'a', 'b', then 'c'.
   */
  function forInRight(object, iteratee) {
    return object == null ? object : baseForRight(object, castFunction(iteratee), keysIn);
  }

  export default forInRight;
});
//# sourceMappingURL=forInRight.js.map