Liferay.Loader.define('layout-content-page-editor-web$dnd-core@7.7.0/lib/esm/actions/dragDrop/beginDrag', ['module', 'exports', 'require', 'layout-content-page-editor-web$invariant'], function (module, exports, require) {
    var define = undefined;
    import { setClientOffset } from './local/setClientOffset';
    import { isObject } from '../../utils/discount_lodash';
    const invariant = require('layout-content-page-editor-web$invariant');
    import { BEGIN_DRAG, INIT_COORDS } from './types';
    const ResetCoordinatesAction = {
        type: INIT_COORDS,
        payload: {
            clientOffset: null,
            sourceClientOffset: null
        }
    };
    export default function createBeginDrag(manager) {
        return function beginDrag(sourceIds = [], options = {
            publishSource: true
        }) {
            const { publishSource = true, clientOffset, getSourceClientOffset } = options;
            const monitor = manager.getMonitor();
            const registry = manager.getRegistry();
            // Initialize the coordinates using the client offset
            manager.dispatch(setClientOffset(clientOffset));
            verifyInvariants(sourceIds, monitor, registry);
            // Get the draggable source
            const sourceId = getDraggableSource(sourceIds, monitor);
            if (sourceId === null) {
                manager.dispatch(ResetCoordinatesAction);
                return;
            }
            // Get the source client offset
            let sourceClientOffset = null;
            if (clientOffset) {
                verifyGetSourceClientOffsetIsFunction(getSourceClientOffset);
                sourceClientOffset = getSourceClientOffset(sourceId);
            }
            // Initialize the full coordinates
            manager.dispatch(setClientOffset(clientOffset, sourceClientOffset));
            const source = registry.getSource(sourceId);
            const item = source.beginDrag(monitor, sourceId);
            verifyItemIsObject(item);
            registry.pinSource(sourceId);
            const itemType = registry.getSourceType(sourceId);
            return {
                type: BEGIN_DRAG,
                payload: {
                    itemType,
                    item,
                    sourceId,
                    clientOffset: clientOffset || null,
                    sourceClientOffset: sourceClientOffset || null,
                    isSourcePublic: !!publishSource
                }
            };
        };
    }
    function verifyInvariants(sourceIds, monitor, registry) {
        invariant(!monitor.isDragging(), 'Cannot call beginDrag while dragging.');
        for (const s of sourceIds) {
            invariant(registry.getSource(s), 'Expected sourceIds to be registered.');
        }
    }
    function verifyGetSourceClientOffsetIsFunction(getSourceClientOffset) {
        invariant(typeof getSourceClientOffset === 'function', 'When clientOffset is provided, getSourceClientOffset must be a function.');
    }
    function verifyItemIsObject(item) {
        invariant(isObject(item), 'Item must be an object.');
    }
    function getDraggableSource(sourceIds, monitor) {
        let sourceId = null;
        for (let i = sourceIds.length - 1; i >= 0; i--) {
            if (monitor.canDragSource(sourceIds[i])) {
                sourceId = sourceIds[i];
                break;
            }
        }
        return sourceId;
    }
});
//# sourceMappingURL=beginDrag.js.map