"use strict";

Liferay.Loader.define("layout-content-page-editor-web$dnd-core@7.7.0/lib/cjs/reducers/dirtyHandlerIds", ['module', 'exports', 'require', '../actions/dragDrop', '../actions/registry', '../utils/equality', '../utils/dirtiness', '../utils/discount_lodash'], function (module, exports, require) {
    var define = undefined;
    Object.defineProperty(exports, "__esModule", { value: true });
    var dragDrop_1 = require("../actions/dragDrop");
    var registry_1 = require("../actions/registry");
    var equality_1 = require("../utils/equality");
    var dirtiness_1 = require("../utils/dirtiness");
    var discount_lodash_1 = require("../utils/discount_lodash");
    function dirtyHandlerIds(state, action) {
        if (state === void 0) {
            state = dirtiness_1.NONE;
        }
        switch (action.type) {
            case dragDrop_1.HOVER:
                break;
            case registry_1.ADD_SOURCE:
            case registry_1.ADD_TARGET:
            case registry_1.REMOVE_TARGET:
            case registry_1.REMOVE_SOURCE:
                return dirtiness_1.NONE;
            case dragDrop_1.BEGIN_DRAG:
            case dragDrop_1.PUBLISH_DRAG_SOURCE:
            case dragDrop_1.END_DRAG:
            case dragDrop_1.DROP:
            default:
                return dirtiness_1.ALL;
        }
        var _a = action.payload,
            _b = _a.targetIds,
            targetIds = _b === void 0 ? [] : _b,
            _c = _a.prevTargetIds,
            prevTargetIds = _c === void 0 ? [] : _c;
        var result = discount_lodash_1.xor(targetIds, prevTargetIds);
        var didChange = result.length > 0 || !equality_1.areArraysEqual(targetIds, prevTargetIds);
        if (!didChange) {
            return dirtiness_1.NONE;
        }
        // Check the target ids at the innermost position. If they are valid, add them
        // to the result
        var prevInnermostTargetId = prevTargetIds[prevTargetIds.length - 1];
        var innermostTargetId = targetIds[targetIds.length - 1];
        if (prevInnermostTargetId !== innermostTargetId) {
            if (prevInnermostTargetId) {
                result.push(prevInnermostTargetId);
            }
            if (innermostTargetId) {
                result.push(innermostTargetId);
            }
        }
        return result;
    }
    exports.default = dirtyHandlerIds;
});
//# sourceMappingURL=dirtyHandlerIds.js.map