"use strict";

Liferay.Loader.define("layout-content-page-editor-web$dnd-core@7.7.0/lib/cjs/contracts", ['module', 'exports', 'require', 'layout-content-page-editor-web$invariant'], function (module, exports, require) {
    var define = undefined;
    Object.defineProperty(exports, "__esModule", { value: true });
    var invariant = require("layout-content-page-editor-web$invariant");
    function validateSourceContract(source) {
        invariant(typeof source.canDrag === 'function', 'Expected canDrag to be a function.');
        invariant(typeof source.beginDrag === 'function', 'Expected beginDrag to be a function.');
        invariant(typeof source.endDrag === 'function', 'Expected endDrag to be a function.');
    }
    exports.validateSourceContract = validateSourceContract;
    function validateTargetContract(target) {
        invariant(typeof target.canDrop === 'function', 'Expected canDrop to be a function.');
        invariant(typeof target.hover === 'function', 'Expected hover to be a function.');
        invariant(typeof target.drop === 'function', 'Expected beginDrag to be a function.');
    }
    exports.validateTargetContract = validateTargetContract;
    function validateType(type, allowArray) {
        if (allowArray && Array.isArray(type)) {
            type.forEach(function (t) {
                return validateType(t, false);
            });
            return;
        }
        invariant(typeof type === 'string' || typeof type === 'symbol', allowArray ? 'Type can only be a string, a symbol, or an array of either.' : 'Type can only be a string or a symbol.');
    }
    exports.validateType = validateType;
});
//# sourceMappingURL=contracts.js.map