"use strict";

Liferay.Loader.define("layout-content-page-editor-web$dnd-core@7.7.0/lib/cjs/actions/dragDrop/endDrag", ['module', 'exports', 'require', './types', 'layout-content-page-editor-web$invariant'], function (module, exports, require) {
    var define = undefined;
    Object.defineProperty(exports, "__esModule", { value: true });
    var types_1 = require("./types");
    var invariant = require("layout-content-page-editor-web$invariant");
    function createEndDrag(manager) {
        return function endDrag() {
            var monitor = manager.getMonitor();
            var registry = manager.getRegistry();
            verifyIsDragging(monitor);
            var sourceId = monitor.getSourceId();
            var source = registry.getSource(sourceId, true);
            source.endDrag(monitor, sourceId);
            registry.unpinSource();
            return { type: types_1.END_DRAG };
        };
    }
    exports.default = createEndDrag;
    function verifyIsDragging(monitor) {
        invariant(monitor.isDragging(), 'Cannot call endDrag while not dragging.');
    }
});
//# sourceMappingURL=endDrag.js.map