Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/utils/fragmentMigrator.es", ['module', 'exports', 'require', './constants'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _constants = require("./constants");

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * @param {object} object
   * @param {string} defaultSegmentsExperienceKey
   */
  function _editableFragmentMigrator(object, defaultSegmentsExperienceKey) {
    var alternativeObject = null;
    var defaultSegment = {};
    Object.keys(object).forEach(function (oKey) {
      if (oKey !== 'defaultValue' && typeof object[oKey] === 'string') {
        defaultSegment[oKey] = object[oKey];
      }
    });

    if (Object.keys(defaultSegment).length > 0) {
      var _alternativeObject;

      alternativeObject = (_alternativeObject = {}, _defineProperty(_alternativeObject, defaultSegmentsExperienceKey, defaultSegment), _defineProperty(_alternativeObject, "defaultValue", object.defaultValue), _alternativeObject);
    }

    return alternativeObject || object;
  }
  /**
   * @param {object} editableValue
   * @param {string} defaultSegmentsExperienceKey
   */

  function editableValuesMigrator(editableValue, defaultSegmentsExperienceKey) {
    var jsonEditableValues = JSON.parse(editableValue);
    var result;

    if (!defaultSegmentsExperienceKey) {
      result = jsonEditableValues;
    } else {
      result = _defineProperty({}, _constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR, {});
      Object.keys(jsonEditableValues[_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR]).forEach(function (editableFragmentKey) {
        result[_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editableFragmentKey] = _editableFragmentMigrator(jsonEditableValues[_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR][editableFragmentKey], defaultSegmentsExperienceKey);
      });
    }

    return result;
  }

  var _default = editableValuesMigrator;
  exports["default"] = _default;
  //# sourceMappingURL=fragmentMigrator.es.js.map
});
//# sourceMappingURL=fragmentMigrator.es.js.map