Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/utils/FragmentsEditorIdUtils.es", ['module', 'exports', 'require', './FragmentsEditorUpdateUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.encodeAssetId = encodeAssetId;
  exports.decodeId = void 0;

  var _FragmentsEditorUpdateUtils = require("./FragmentsEditorUpdateUtils.es");

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  /**
   * Adds encoded id to an object and creating a copy of the original one
   * @param {!object} obj Original object
   * @param {!Array} ids Array with id fields to be encoded
   * @private
   */
  function _addEncodedId(obj, ids) {
    var idObj = {};
    ids.forEach(function (id) {
      idObj[id] = obj[id];
    });
    return (0, _FragmentsEditorUpdateUtils.setIn)(obj, ['encodedId'], _encodeId(idObj));
  }
  /**
   * Encode an id object and returns encoded id
   * @param {!obj} obj
   */

  var _encodeId = function _encodeId(obj) {
    return btoa(JSON.stringify(obj));
  };
  /**
   * Decode an id and returns original object
   * @param {!string} str
   */

  var decodeId = function decodeId(str) {
    return JSON.parse(atob(str));
  };
  /**
   * @param {!object} asset Asset object
   * @return {object} Asset object with encoded id added
   */

  exports.decodeId = decodeId;

  function encodeAssetId(asset) {
    if (!(asset && _typeof(asset) === 'object')) {
      throw new TypeError('Expect input to be an object');
    } else if (!(asset.classNameId && asset.classPK)) {
      throw new Error('Expect input to be an asset');
    }

    return _addEncodedId(asset, ['classNameId', 'classPK']);
  }
  //# sourceMappingURL=FragmentsEditorIdUtils.es.js.map
});
//# sourceMappingURL=FragmentsEditorIdUtils.es.js.map