Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/utils/FragmentsEditorGetUtils.es", ['module', 'exports', 'require', '../utils/constants'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.deepClone = deepClone;
  exports.editableIsMapped = editableIsMapped;
  exports.editableIsMappedToAssetEntry = editableIsMappedToAssetEntry;
  exports.editableShouldBeHighlighted = editableShouldBeHighlighted;
  exports.getColumn = getColumn;
  exports.getDropRowPosition = getDropRowPosition;
  exports.getElements = getElements;
  exports.getItemPath = getItemPath;
  exports.getFragmentColumn = getFragmentColumn;
  exports.getFragmentRowIndex = getFragmentRowIndex;
  exports.getItemMoveDirection = getItemMoveDirection;
  exports.getMappingSourceTypes = getMappingSourceTypes;
  exports.getRowFragmentEntryLinkIds = getRowFragmentEntryLinkIds;
  exports.getRowIndex = getRowIndex;
  exports.getTargetBorder = getTargetBorder;
  exports.getWidget = getWidget;
  exports.getWidgetPath = getWidgetPath;
  exports.itemIsInPath = itemIsInPath;

  var _constants = require("../utils/constants");

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  var ARROW_DOWN_KEYCODE = 40;
  var ARROW_UP_KEYCODE = 38;
  var MOVE_ITEM_DIRECTIONS = {
    DOWN: 1,
    UP: -1
  };
  /**
   * @param {object} objectToClone
   * @returns {object}
   */

  function deepClone(objectToClone) {
    var cloned = objectToClone;

    if (_typeof(cloned) == 'object' && cloned !== null) {
      if (Array.isArray(cloned)) {
        cloned = objectToClone.map(function (arrayItem) {
          return deepClone(arrayItem);
        });
      } else {
        cloned = _objectSpread({}, cloned);
        Object.keys(cloned).forEach(function (clonedKey) {
          cloned[clonedKey] = deepClone(cloned[clonedKey]);
        });
      }
    }

    return cloned;
  }
  /**
   * Checks if the given editable is mapped
   * @param {object} editableValues
   * @private
   * @return {boolean}
   * @review
   */

  function editableIsMapped(editableValues) {
    return Boolean(editableValues.mappedField || editableIsMappedToAssetEntry(editableValues));
  }
  /**
   * Checks if the given editable is mapped to an asset entry
   * @param {object} editableValues
   * @private
   * @return {boolean}
   * @review
   */

  function editableIsMappedToAssetEntry(editableValues) {
    return Boolean(editableValues.classNameId && editableValues.classPK && editableValues.fieldId);
  }
  /**
   * Checks if the given editable should be highlighted
   * @param {string} activeItemId
   * @param {string} activeItemType
   * @param {string} fragmentEntryLinkId
   * @param {object} structure
   * @private
   * @return {boolean}
   * @review
   */

  function editableShouldBeHighlighted(activeItemId, activeItemType, fragmentEntryLinkId, structure) {
    var parentFragmentIsInActiveItemPath = itemIsInPath(getItemPath(activeItemId, activeItemType, structure), fragmentEntryLinkId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment);
    return parentFragmentIsInActiveItemPath;
  }
  /**
   * Returns the column with the given columnId
   * @param {Object} structure
   * @param {string} columnId
   * @return {Object}
   */

  function getColumn(structure, columnId) {
    return structure.map(function (row) {
      return row.columns.find(function (_column) {
        return _column.columnId === columnId;
      });
    }).filter(function (column) {
      return column;
    }).find(function (column) {
      return column;
    });
  }
  /**
   * Returns the position in the structure of the given row
   * @param {object} structure
   * @param {number} targetRowId
   * @param {string} targetBorder
   * @return {number}
   */

  function getDropRowPosition(structure, targetRowId, targetBorder) {
    var position = structure.length;
    var targetPosition = structure.findIndex(function (row) {
      return row.rowId === targetRowId;
    });

    if (targetPosition > -1 && targetBorder) {
      if (targetBorder === _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.top) {
        position = targetPosition;
      } else {
        position = targetPosition + 1;
      }
    }

    return position;
  }
  /**
   * Get HTML elements from itemId and itemType in page editor
   * @param {string} itemId
   * @param {string} itemType
   */

  function getElements(itemId, itemType) {
    return document.querySelectorAll("[data-fragments-editor-item-id=\"".concat(itemId, "\"][data-fragments-editor-item-type=\"").concat(itemType, "\"]"));
  }
  /**
   * Returns the column that contains the fragment
   * with the given fragmentEntryLinkId.
   *
   * @param {Array} structure
   * @param {string} fragmentEntryLinkId
   * @return {Object}
   */

  function getFragmentColumn(structure, fragmentEntryLinkId) {
    return structure.map(function (row) {
      return row.columns.find(function (_column) {
        return _column.fragmentEntryLinkIds.find(function (fragmentId) {
          return fragmentId === fragmentEntryLinkId;
        });
      });
    }).filter(function (column) {
      return column;
    }).find(function (column) {
      return column;
    });
  }
  /**
   * Returns the row index of a given fragmentEntryLinkId.
   * -1 if it is not present.
   *
   * @param {Array} structure
   * @param {string} fragmentEntryLinkId
   * @return {number}
   */

  function getFragmentRowIndex(structure, fragmentEntryLinkId) {
    return structure.findIndex(function (row) {
      return row.columns.find(function (column) {
        return column.fragmentEntryLinkIds.find(function (_fragmentEntryLinkId) {
          return _fragmentEntryLinkId === fragmentEntryLinkId;
        });
      });
    });
  }
  /**
   * @param {number} keycode
   * @return {number|null}
   * @review
   */

  function getItemMoveDirection(keycode) {
    var direction = null;

    if (keycode === ARROW_UP_KEYCODE) {
      direction = MOVE_ITEM_DIRECTIONS.UP;
    } else if (keycode === ARROW_DOWN_KEYCODE) {
      direction = MOVE_ITEM_DIRECTIONS.DOWN;
    }

    return direction;
  }
  /**
   * For a given itemId and itemType, returns an array
   * with the whole path of active elements.
   * @param {string|null} itemId
   * @param {string|null} itemType
   * @param {object[]} structure
   * @return {Array<{itemId: string, itemType}>}
   */

  function getItemPath(itemId, itemType, structure) {
    var itemPath = [];

    if (itemId && itemType && structure.length) {
      itemPath = [{
        itemId: itemId,
        itemType: itemType
      }];

      if (itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable || itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.backgroundImageEditable) {
        var _itemId$split = itemId.split('-'),
            _itemId$split2 = _slicedToArray(_itemId$split, 1),
            fragmentEntryLinkId = _itemId$split2[0];

        if (fragmentEntryLinkId) {
          itemPath = [].concat(_toConsumableArray(itemPath), _toConsumableArray(getItemPath(fragmentEntryLinkId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment, structure)));
        }
      } else if (itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment) {
        var _ref;

        var column = (_ref = []).concat.apply(_ref, _toConsumableArray(structure.map(function (row) {
          return row.columns;
        }))).find(function (_column) {
          return _column.fragmentEntryLinkIds.indexOf(itemId) !== -1;
        });

        if (column) {
          itemPath = [].concat(_toConsumableArray(itemPath), _toConsumableArray(getItemPath(column.columnId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.column, structure)));
        }
      } else if (itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.column) {
        var row = structure.find(function (row) {
          return row.columns.find(function (column) {
            return column.columnId === itemId;
          });
        });

        if (row) {
          itemPath = [].concat(_toConsumableArray(itemPath), _toConsumableArray(getItemPath(row.rowId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row, structure)));
        }
      }
    }

    return itemPath;
  }
  /**
   * @param {string} subtypeLabel
   * @return {Array<{id: string, label: string}>} Source types
   * @private
   * @review
   */

  function getMappingSourceTypes(subtypeLabel) {
    return [{
      id: _constants.MAPPING_SOURCE_TYPE_IDS.structure,
      label: Liferay.Util.sub(Liferay.Language.get('x-default'), subtypeLabel)
    }, {
      id: _constants.MAPPING_SOURCE_TYPE_IDS.content,
      label: Liferay.Language.get('specific-content')
    }];
  }
  /**
   * Get the fragmentEntryLinkIds of the fragments inside the given row
   * @param {{columns: Array<{fragmentEntryLinkIds: Array<string>}>}} row
   * @return {string[]}
   * @review
   */

  function getRowFragmentEntryLinkIds(row) {
    var fragmentEntryLinkIds = [];
    row.columns.forEach(function (column) {
      fragmentEntryLinkIds = fragmentEntryLinkIds.concat(column.fragmentEntryLinkIds);
    });
    return fragmentEntryLinkIds;
  }
  /**
   * Returns the index of the row with the given rowId
   * @param {Array} structure
   * @param {string} rowId
   * @return {number}
   */

  function getRowIndex(structure, rowId) {
    return structure.findIndex(function (row) {
      return row.rowId === rowId;
    });
  }
  /**
   * Get target item border from the direction the item is moving in
   * @param {number} direction
   * @return {string}
   * @review
   */

  function getTargetBorder(direction) {
    var targetBorder = null;

    if (direction === MOVE_ITEM_DIRECTIONS.UP) {
      targetBorder = _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.top;
    } else if (direction === MOVE_ITEM_DIRECTIONS.DOWN) {
      targetBorder = _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.bottom;
    }

    return targetBorder;
  }
  /**
   * Get widget from the widgets tree by portletId
   * @param {!Array} widgets
   * @param {!string} portletId
   * @return {object}
   * @review
   */

  function getWidget(widgets, portletId) {
    var widget = null;
    var widgetsLength = widgets.length;

    for (var i = 0; i < widgetsLength; i++) {
      var _widgets$i = widgets[i],
          _widgets$i$categories = _widgets$i.categories,
          categories = _widgets$i$categories === void 0 ? [] : _widgets$i$categories,
          _widgets$i$portlets = _widgets$i.portlets,
          portlets = _widgets$i$portlets === void 0 ? [] : _widgets$i$portlets;
      var categoryPortlet = portlets.find(function (_portlet) {
        return _portlet.portletId === portletId;
      });
      var subCategoryPortlet = getWidget(categories, portletId);

      if (categoryPortlet) {
        widget = categoryPortlet;
      }

      if (subCategoryPortlet) {
        widget = subCategoryPortlet;
      }
    }

    return widget;
  }
  /**
   * Get widget path from the widgets tree by portletId
   * @param {Array<{categories: Array, portlets: Array}>} widgets
   * @param {string} portletId
   * @param {string[]} [_path=['widgets']]
   * @return {object}
   * @review
   */

  function getWidgetPath(widgets, portletId) {
    var _path = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ['widgets'];

    var widgetPath = null;

    for (var categoryIndex = 0; categoryIndex < widgets.length; categoryIndex += 1) {
      var _widgets$categoryInde = widgets[categoryIndex],
          _widgets$categoryInde2 = _widgets$categoryInde.categories,
          categories = _widgets$categoryInde2 === void 0 ? [] : _widgets$categoryInde2,
          _widgets$categoryInde3 = _widgets$categoryInde.portlets,
          portlets = _widgets$categoryInde3 === void 0 ? [] : _widgets$categoryInde3;
      var categoryPortletIndex = portlets.findIndex(function (_portlet) {
        return _portlet.portletId === portletId;
      });
      var subCategoryPortletPath = getWidgetPath(categories, portletId, [].concat(_toConsumableArray(_path), [categoryIndex.toString(), 'categories']));

      if (categoryPortletIndex !== -1) {
        widgetPath = [].concat(_toConsumableArray(_path), [categoryIndex, 'portlets', categoryPortletIndex]);
      }

      if (subCategoryPortletPath) {
        widgetPath = subCategoryPortletPath;
      }
    }

    return widgetPath;
  }
  /**
   * @param {object} path
   * @param {string} itemId
   * @param {string} itemType
   * @return {boolean} Item is in path
   * @review
   */

  function itemIsInPath(path, itemId, itemType) {
    return path.some(function (pathItem) {
      return pathItem.itemId === itemId && pathItem.itemType === itemType;
    });
  }
  //# sourceMappingURL=FragmentsEditorGetUtils.es.js.map
});
//# sourceMappingURL=FragmentsEditorGetUtils.es.js.map