Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/utils/FragmentsEditorFetchUtils.es", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.addFragmentEntryLinkComment = addFragmentEntryLinkComment;
  exports.addFragmentEntryLinkCommentReply = addFragmentEntryLinkCommentReply;
  exports.addSegmentsExperience = addSegmentsExperience;
  exports.addStructuredContent = addStructuredContent;
  exports.deleteFragmentEntryLinkComment = deleteFragmentEntryLinkComment;
  exports.duplicateFragmentEntryLink = duplicateFragmentEntryLink;
  exports.editFragmentEntryLinkComment = editFragmentEntryLinkComment;
  exports.getAssetFieldValue = getAssetFieldValue;
  exports.getAssetMappingFields = getAssetMappingFields;
  exports.getContentStructureMappingFields = getContentStructureMappingFields;
  exports.getExperienceUsedPortletIds = getExperienceUsedPortletIds;
  exports.getPageContents = getPageContents;
  exports.getStructureMappingFields = getStructureMappingFields;
  exports.removeExperience = removeExperience;
  exports.removeFragmentEntryLinks = removeFragmentEntryLinks;
  exports.setStore = setStore;
  exports.updateEditableValues = updateEditableValues;
  exports.updatePageEditorLayoutData = updatePageEditorLayoutData;

  var _frontendJsWeb = require("frontend-js-web");

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  /**
   * @type {object}
   */
  var _store;
  /**
   * @param {object} body
   * @param {string} portletNamespace
   * @param {FormData} [_formData=new FormData()]
   * @return {FormData}
   * @review
   */

  function _getFormData(body, portletNamespace) {
    var _formData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new FormData();

    Object.entries(body).forEach(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          key = _ref2[0],
          value = _ref2[1];

      _formData.append("".concat(portletNamespace).concat(key), value);
    });
    return _formData;
  }
  /**
   * @param {string} url
   * @param {object} [body={}]
   * @private
   * @return {Promise<object>}
   * @review
   */

  function _fetch(url) {
    var body = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    return (0, _frontendJsWeb.fetch)(url, {
      body: _getFormData(body, _store.getState().portletNamespace),
      method: 'POST'
    }).then(function (response) {
      return new Promise(function (resolve, reject) {
        response.clone().json().then(function (body) {
          return resolve([response, body]);
        })["catch"](function () {
          return response.clone().text();
        }).then(function (body) {
          return resolve([response, body]);
        })["catch"](reject);
      });
    }).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
          response = _ref4[0],
          body = _ref4[1];

      if (_typeof(body) === 'object') {
        if ('exception' in body) {
          throw new Error(body.exception);
        } else if ('error' in body) {
          throw new Error(body.error);
        }
      }

      if (response.status >= 400) {
        throw new Error("".concat(response.status, " ").concat(body));
      }

      return body;
    });
  }
  /**
   * @param {string} fragmentEntryLinkId
   * @param {string} body
   */

  function addFragmentEntryLinkComment(fragmentEntryLinkId, body) {
    var state = _store.getState();

    return _fetch(state.addFragmentEntryLinkCommentURL, {
      body: body,
      fragmentEntryLinkId: fragmentEntryLinkId
    });
  }
  /**
   * @param {string} fragmentEntryLinkId
   * @param {string} parentCommentId
   * @param {string} body
   */

  function addFragmentEntryLinkCommentReply(fragmentEntryLinkId, parentCommentId, body) {
    var state = _store.getState();

    return _fetch(state.addFragmentEntryLinkCommentURL, {
      body: body,
      fragmentEntryLinkId: fragmentEntryLinkId,
      parentCommentId: parentCommentId
    });
  }
  /**
   * @param {string} ddmFormValues
   * @param {string} ddmStructureId
   */

  function addStructuredContent(ddmFormValues, ddmStructureId, title) {
    return _fetch(_store.getState().addStructuredContentURL, {
      ddmFormValues: ddmFormValues,
      ddmStructureId: ddmStructureId,
      title: title
    }).then(function (response) {
      if (response.errorMessage) {
        throw new Error(response.errorMessage);
      } else if (!response.classNameId || !response.classPK || !response.title) {
        throw new Error(Liferay.Language.get('an-unexpected-error-occurred'));
      }

      return response;
    });
  }
  /**
   * @param {string} fragmentEntryLinkId
   * @return {Promise<Response>}
   */

  function duplicateFragmentEntryLink(fragmentEntryLinkId) {
    var state = _store.getState();

    return _fetch(state.duplicateFragmentEntryLinkURL, {
      fragmentEntryLinkId: fragmentEntryLinkId
    });
  }
  /**
   * @param {string} commentId
   */

  function deleteFragmentEntryLinkComment(commentId) {
    var state = _store.getState();

    return _fetch(state.deleteFragmentEntryLinkCommentURL, {
      commentId: commentId
    });
  }
  /**
   * @param {string} commentId
   * @param {string} body
   */

  function editFragmentEntryLinkComment(commentId, body, resolved) {
    var state = _store.getState();

    return _fetch(state.editFragmentEntryLinkCommentURL, {
      body: body,
      commentId: commentId,
      resolved: resolved
    });
  }
  /**
   * @param {string} classNameId
   * @param {string} classPK
   * @param {string} fieldId
   */

  function getAssetFieldValue(classNameId, classPK, fieldId) {
    return _fetch(_store.getState().getAssetFieldValueURL, {
      classNameId: classNameId,
      classPK: classPK,
      fieldId: fieldId
    });
  }

  function getAssetMappingFields(classNameId, classPK) {
    return _fetch(_store.getState().getAssetMappingFieldsURL, {
      classNameId: classNameId,
      classPK: classPK
    });
  }
  /**
   * @param {string} ddmStructureId
   */

  function getContentStructureMappingFields(ddmStructureId) {
    return _fetch(_store.getState().getContentStructureMappingFieldsURL, {
      ddmStructureId: ddmStructureId
    });
  }

  function getExperienceUsedPortletIds(segmentsExperienceId) {
    return _fetch(_store.getState().getExperienceUsedPortletsURL, {
      segmentsExperienceId: segmentsExperienceId
    });
  }

  function getPageContents() {
    var state = _store.getState();

    var getPageContentsURL = state.getPageContentsURL;
    var url = new URL(window.location.href);
    url.searchParams["delete"]('activeItemType');
    url.searchParams["delete"]('activeItemId');
    url.searchParams.set('sidebarPanelId', 'contents');
    var backURL = "".concat(url.pathname).concat(url.search);
    return _fetch(getPageContentsURL, {
      backURL: backURL
    });
  }

  function getStructureMappingFields(classNameId, classTypeId) {
    return _fetch(_store.getState().mappingFieldsURL, {
      classNameId: classNameId,
      classTypeId: classTypeId
    });
  }
  /**
   * @param {string} segmentsExperienceId
   * @param {Array<string>} [fragmentEntryLinkIds=[]]
   * @return {Promise<Response>}
   */

  function removeExperience(segmentsExperienceId) {
    var fragmentEntryLinkIds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    var deleteSegmentsExperience = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

    var state = _store.getState();

    var body = {
      deleteSegmentsExperience: deleteSegmentsExperience,
      segmentsExperienceId: segmentsExperienceId
    };

    if (fragmentEntryLinkIds && fragmentEntryLinkIds.length) {
      body.fragmentEntryLinkIds = JSON.stringify(fragmentEntryLinkIds);
    }

    return _fetch(state.deleteSegmentsExperienceURL, body);
  }
  /**
   * @param {string} segmentsExperienceId
   * @param {Array<string>} [fragmentEntryLinkIds=[]]
   * @return {Promise<Response>}
   */

  function addSegmentsExperience(_ref5) {
    var name = _ref5.name,
        segmentsEntryId = _ref5.segmentsEntryId;

    var state = _store.getState();

    var addSegmentsExperienceURL = state.addSegmentsExperienceURL,
        classNameId = state.classNameId,
        classPK = state.classPK;

    return _fetch(addSegmentsExperienceURL, {
      active: true,
      classNameId: classNameId,
      classPK: classPK,
      name: name,
      segmentsEntryId: segmentsEntryId
    });
  }
  /**
   * @param {string[]} fragmentEntryLinkIds
   * @return {Promise<Response[]>}
   */

  function removeFragmentEntryLinks(fragmentEntryLinkIds) {
    var state = _store.getState();

    return Promise.all(fragmentEntryLinkIds.map(function (fragmentEntryLinkId) {
      return _fetch(state.deleteFragmentEntryLinkURL, {
        fragmentEntryLinkId: fragmentEntryLinkId
      });
    }));
  }
  /**
   * Sets the store
   * @param {object} store
   */

  function setStore(store) {
    _store = store;
  }
  /**
   * @param {string} fragmentEntryLinkId
   * @param {object} editableValues
   * @param {boolean} updateClassedModel Update classed model(Layout) associated
   * with the fragment entry link
   * @return {Promise<Response>}
   */

  function updateEditableValues(fragmentEntryLinkId, editableValues) {
    var updateClassedModel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

    var state = _store.getState();

    return _fetch(state.editFragmentEntryLinkURL, {
      editableValues: JSON.stringify(editableValues),
      fragmentEntryLinkId: fragmentEntryLinkId,
      updateClassedModel: updateClassedModel
    });
  }
  /**
   * @param {Object} layoutData
   * @param {string} segmentsExperienceId
   * @return {Promise<Response>}
   */

  function updatePageEditorLayoutData(layoutData, segmentsExperienceId) {
    var state = _store.getState();

    return _fetch(state.updateLayoutPageTemplateDataURL, {
      classNameId: state.classNameId,
      classPK: state.classPK,
      data: JSON.stringify(layoutData),
      segmentsExperienceId: segmentsExperienceId
    });
  }
  //# sourceMappingURL=FragmentsEditorFetchUtils.es.js.map
});
//# sourceMappingURL=FragmentsEditorFetchUtils.es.js.map