Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/utils/FragmentsEditorDragDrop.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal-position', './constants'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.initializeDragDrop = initializeDragDrop;

  var _frontendJsWeb = require("frontend-js-web");

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  var _metalPosition = require("frontend-js-metal-web$metal-position");

  var _constants = require("./constants");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var _getRegionInterceptor = null;
  /**
   * Stops intercepting metal-position getRegion calls
   * @private
   * @review
   * @see {_interceptGetRegion}
   */

  function _stopInterceptGetRegion() {
    if (_getRegionInterceptor) {
      _getRegionInterceptor.detach();

      _getRegionInterceptor = null;
    }
  }
  /**
   * Uses metal-aop to intercept metal-position getRegion calls
   * and take into account bootstrap's negative margins.
   * @private
   * @review
   * @see {_stopInterceptGetRegion}
   */

  function _interceptGetRegion() {
    _getRegionInterceptor = _getRegionInterceptor || _frontendJsWeb.AOP.after(function (target) {
      var newReturnVal;

      if (target instanceof HTMLElement && target.classList.contains('col') && target.parentElement && target.parentElement.classList.contains('row')) {
        var currentRetVal = _objectSpread({}, _frontendJsWeb.AOP.currentRetVal);

        var parentComputedStyle = window.getComputedStyle(target.parentElement);
        var negativeLeftMargin = Math.min(parseInt(parentComputedStyle.marginLeft, 10) || 0, 0);
        var negativeRightMargin = Math.min(parseInt(parentComputedStyle.marginRight, 10) || 0, 0);
        currentRetVal.width = currentRetVal.width + negativeLeftMargin + negativeRightMargin;
        currentRetVal.left -= negativeLeftMargin;
        currentRetVal.right += negativeRightMargin;
        newReturnVal = _frontendJsWeb.AOP.alterReturn(currentRetVal);
      }

      return newReturnVal;
    }, _metalPosition.Position, 'getRegion');
  }
  /**
   * @param {object} dragDropOptions
   * @review
   */

  function initializeDragDrop(dragDropOptions) {
    var dragDrop = new _metalDragDrop.DragDrop(_objectSpread({
      autoScroll: true,
      dragPlaceholder: _metalDragDrop.Drag.Placeholder.CLONE,
      draggingClass: _constants.FRAGMENTS_EDITOR_DRAGGING_CLASS,
      scrollContainers: '.fragment-entry-link-list-wrapper'
    }, dragDropOptions));
    dragDrop.on('dispose', _stopInterceptGetRegion);
    dragDrop.on(_metalDragDrop.Drag.Events.START, _interceptGetRegion);
    dragDrop.on(_metalDragDrop.DragDrop.Events.END, _stopInterceptGetRegion);
    return dragDrop;
  }
  //# sourceMappingURL=FragmentsEditorDragDrop.es.js.map
});
//# sourceMappingURL=FragmentsEditorDragDrop.es.js.map