Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/reducers/segmentsExperiences.es", ['module', 'exports', 'require', '../utils/FragmentsEditorFetchUtils.es', '../utils/FragmentsEditorGetUtils.es', '../utils/FragmentsEditorUpdateUtils.es', '../utils/LayoutDataList.es', './fragments.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.createSegmentsExperienceReducer = createSegmentsExperienceReducer;
  exports.deleteSegmentsExperienceReducer = deleteSegmentsExperienceReducer;
  exports.editSegmentsExperienceReducer = editSegmentsExperienceReducer;
  exports.updateSegmentsExperiencePriorityReducer = updateSegmentsExperiencePriorityReducer;
  exports.selectSegmentsExperienceReducer = selectSegmentsExperienceReducer;

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  var _FragmentsEditorGetUtils = require("../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  var _LayoutDataList = require("../utils/LayoutDataList.es");

  var _fragments = require("./fragments.es");

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var EDIT_SEGMENTS_EXPERIENCE_URL = '/segments.segmentsexperience/update-segments-experience';
  var UPDATE_SEGMENTS_EXPERIENCE_PRIORITY_URL = '/segments.segmentsexperience/update-segments-experience-priority';
  /**
   * Stores a the layout data of a new experience in layoutDataList
   * @param {object} state
   * @param {Array<{segmentsExperienceId: string}>} state.layoutDataList
   * @param {object} state.layoutData
   * @param {string} state.defaultSegmentsExperienceId
   * @param {string} segmentsExperienceId The segmentsExperience id that owns this LayoutData
   * @param {string} layoutData The new LayoutData to store
   * @returns {object}
   */

  function _storeNewLayoutData(state, segmentsExperienceId, layoutData) {
    var nextState = state;
    nextState.layoutDataList.push({
      layoutData: layoutData,
      segmentsExperienceId: segmentsExperienceId
    });
    return nextState;
  }
  /**
   *
   * @param {object} state
   * @param {object} state.layoutData
   * @param {Array<{segmentsExperienceId: string ,layoutData: object}>} state.layoutDataList
   * @param {string} segmentsExperienceId
   * @returns {Promise}
   */

  function _switchLayoutDataList(state, segmentsExperienceId) {
    var nextState = state;
    return new Promise(function (resolve, reject) {
      try {
        (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(state.layoutData, state.segmentsExperienceId || state.defaultSegmentsExperienceId).then(function () {
          var prevLayout = nextState.layoutData;
          var prevSegmentsExperienceId = state.segmentsExperienceId || nextState.defaultSegmentsExperienceId;
          var layoutData = {};

          if (segmentsExperienceId === prevSegmentsExperienceId) {
            layoutData = nextState.layoutData;
          } else {
            var layoutDataItem = nextState.layoutDataList.find(function (segmentedLayout) {
              return segmentedLayout.segmentsExperienceId === segmentsExperienceId;
            });
            layoutData = layoutDataItem ? layoutDataItem.layoutData : (0, _LayoutDataList.getEmptyLayoutData)();
          }

          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], layoutData);
          var newlayoutDataList = nextState.layoutDataList.map(function (segmentedLayout) {
            return segmentedLayout.segmentsExperienceId === prevSegmentsExperienceId ? _objectSpread({}, segmentedLayout, {
              layoutData: prevLayout
            }) : segmentedLayout;
          });
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutDataList'], newlayoutDataList);
          resolve(nextState);
        })["catch"](function (error) {
          reject(error);
        });
      } catch (e) {
        reject(e);
      }
    });
  }
  /**
   *
   * @param {object} state
   * @param {Array<{segmentsExperienceId: string}>} state.layoutDataList
   * @param {string} state.defaultSegmentsExperienceId
   * @returns {object}
   */

  function _switchLayoutDataToDefault(state) {
    var nextState = state;
    var baseLayoutData = nextState.layoutDataList.find(function (layoutDataItem) {
      return layoutDataItem.segmentsExperienceId === nextState.defaultSegmentsExperienceId;
    });
    nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], baseLayoutData.layoutData);
    return nextState;
  }
  /**
   *
   * @param {object} state
   * @param {Array<{segmentsExperienceId: string}>} state.layoutDataList
   * @param {string} segmentsExperienceId
   * @returns {object}
   */

  function _removeLayoutDataItem(state, segmentsExperienceId) {
    var nextState = state;
    nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutDataList'], nextState.layoutDataList.filter(function (layoutDataItem) {
      return layoutDataItem.segmentsExperienceId !== segmentsExperienceId;
    }));
    return nextState;
  }
  /**
   *
   * @param {object} state
   * @param {string} segmentsExperienceId
   * @returns {object}
   */

  function _setUsedWidgets(state, segmentsExperienceId) {
    return (0, _FragmentsEditorFetchUtils.getExperienceUsedPortletIds)(segmentsExperienceId).then(function (portletIds) {
      var widgets = (0, _FragmentsEditorUpdateUtils.updateUsedWidgets)(state.widgets, portletIds);
      state = (0, _FragmentsEditorUpdateUtils.setIn)(state, ['widgets'], widgets);
      return state;
    });
  }
  /**
   *
   * @param {object} state
   * @param {string} segmentsExperienceId
   * @returns {object}
   */

  function _updateFragmentEntryLinks(state, segmentsExperienceId) {
    var fragmentEntryLinkIds = (0, _LayoutDataList.getLayoutDataFragmentEntryLinkIds)(state.layoutData);
    var promises = fragmentEntryLinkIds.map(function (fragmentEntryLinkId) {
      var fragmentEntryLink = state.fragmentEntryLinks[fragmentEntryLinkId];
      return (0, _fragments.getFragmentEntryLinkContent)(state.renderFragmentEntryURL, fragmentEntryLink, state.portletNamespace, segmentsExperienceId).then(function (response) {
        fragmentEntryLink = response;
        state = (0, _FragmentsEditorUpdateUtils.setIn)(state, ['fragmentEntryLinks', fragmentEntryLinkId], fragmentEntryLink);
      });
    });
    return Promise.all(promises).then(function () {
      return state;
    });
  }
  /**
   * @param {object} state
   * @param {string} state.classNameId
   * @param {string} state.classPK
   * @param {string} state.defaultLanguageId
   * @param {string} state.defaultSegmentsExperienceId
   * @param {Array} state.layoutData
   * @param {Array<{segmentsExperienceId: string}>} state.layoutDataList
   * @param {object} action
   * @param {string} action.segmentsEntryId
   * @param {string} action.name
   * @param {string} action.type
   * @return {Promise}
   * @review
   */

  function createSegmentsExperienceReducer(state, action) {
    return new Promise(function (resolve, reject) {
      var name = action.name,
          segmentsEntryId = action.segmentsEntryId;
      var nextState = state;
      (0, _FragmentsEditorFetchUtils.addSegmentsExperience)({
        name: name,
        segmentsEntryId: segmentsEntryId
      }).then(function (objectResponse) {
        if (objectResponse.error) throw objectResponse.error;
        return objectResponse;
      }).then(function _success(_ref) {
        var fragmentEntryLinks = _ref.fragmentEntryLinks,
            layoutData = _ref.layoutData,
            segmentsExperience = _ref.segmentsExperience;
        var active = segmentsExperience.active,
            name = segmentsExperience.name,
            priority = segmentsExperience.priority,
            segmentsEntryId = segmentsExperience.segmentsEntryId,
            segmentsExperienceId = segmentsExperience.segmentsExperienceId;
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['availableSegmentsExperiences', segmentsExperienceId], {
          active: active,
          name: name,
          priority: priority,
          segmentsEntryId: segmentsEntryId,
          segmentsExperienceId: segmentsExperienceId
        });
        nextState = _storeNewLayoutData(nextState, segmentsExperienceId, layoutData);
        nextState = _updateFragmentEntryLinksEditableValues(nextState, fragmentEntryLinks);

        _switchLayoutDataList(nextState, segmentsExperienceId).then(function (newState) {
          return (0, _FragmentsEditorUpdateUtils.setIn)(newState, ['segmentsExperienceId'], segmentsExperienceId);
        }).then(function (nextNewState) {
          return _updateFragmentEntryLinks(nextNewState, segmentsExperienceId);
        }).then(function (nextNewState) {
          return _setUsedWidgets(nextNewState, action.segmentsExperienceId);
        }).then(function (nextNewState) {
          resolve(nextNewState);
        })["catch"](function (e) {
          reject(e);
        });
      })["catch"](function _fail(error) {
        reject(error);
      });
    });
  }
  /**
   * Updates the fragmentEntryLinks editableValues in State
   *
   * @param {object} state
   * @param {string} state.defaultSegmentsExperienceId
   * @param {object} state.fragmentEntryLinks
   * @param {string} fragmentEntryLinks
   * @returns {object}
   */

  function _updateFragmentEntryLinksEditableValues(state) {
    var fragmentEntryLinks = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var updatedFragmentEntryLinks = state.fragmentEntryLinks;
    Object.entries(fragmentEntryLinks).forEach(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
          id = _ref3[0],
          editableValues = _ref3[1];

      updatedFragmentEntryLinks[id].editableValues = editableValues;
    });
    return _objectSpread({}, state, {
      fragmentEntryLinks: updatedFragmentEntryLinks
    });
  }
  /**
   * @param {object} state
   * @param {Array} state.availableSegmentsExperiences
   * @param {string} state.defaultSegmentsExperienceId
   * @param {{structure: Array}} state.layoutData
   * @param {array} state.layoutDataList
   * @param {string} state.segmentsExperienceId
   * @param {object} action
   * @param {string} action.segmentsExperienceId
   * @param {string} action.type
   * @returns {Promise}
   */

  function deleteSegmentsExperienceReducer(state, action) {
    return new Promise(function (resolve, reject) {
      try {
        var nextState = state;
        var segmentsExperienceId = action.segmentsExperienceId;
        var fragmentEntryLinkIds = nextState.layoutData.structure.reduce(function (allFragmentEntryLinkIds, row) {
          return [].concat(_toConsumableArray(allFragmentEntryLinkIds), _toConsumableArray((0, _FragmentsEditorGetUtils.getRowFragmentEntryLinkIds)(row)));
        }, []).filter(function (fragmentEntryLinkId) {
          return !(0, _LayoutDataList.containsFragmentEntryLinkId)(nextState.layoutDataList, fragmentEntryLinkId, segmentsExperienceId);
        });
        (0, _FragmentsEditorFetchUtils.removeExperience)(segmentsExperienceId, fragmentEntryLinkIds).then(function () {
          var priority = nextState.availableSegmentsExperiences[segmentsExperienceId].priority;

          var availableSegmentsExperiences = _objectSpread({}, nextState.availableSegmentsExperiences);

          delete availableSegmentsExperiences[segmentsExperienceId];
          var experienceIdToSelect = segmentsExperienceId === nextState.segmentsExperienceId ? nextState.defaultSegmentsExperienceId : nextState.segmentsExperienceId;
          Object.values(availableSegmentsExperiences).forEach(function (experience) {
            var segmentExperiencePriority = experience.priority;

            if (segmentExperiencePriority > priority) {
              experience.priority = segmentExperiencePriority - 1;
            }
          });
          nextState = _removeLayoutDataItem(nextState, segmentsExperienceId);
          nextState = _switchLayoutDataToDefault(nextState);
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['availableSegmentsExperiences'], availableSegmentsExperiences);
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['segmentsExperienceId'], experienceIdToSelect);
          return _setUsedWidgets(nextState, experienceIdToSelect);
        }).then(function (nextNewState) {
          return resolve(nextNewState);
        })["catch"](function (error) {
          reject(error);
        });
      } catch (e) {
        reject(e);
      }
    });
  }
  /**
   *
   *
   * @export
   * @param {object} state
   * @param {object} state.layoutData
   * @param {object} state.layoutDataList
   * @param {string} state.segmentsExperienceId
   * @param {object} action
   * @param {string} action.segmentsExperienceId
   * @param {string} action.type
   * @returns {Promise}
   */

  function selectSegmentsExperienceReducer(state, action) {
    return new Promise(function (resolve, reject) {

      _switchLayoutDataList(state, action.segmentsExperienceId).then(function (newState) {
        var nextNewState = (0, _FragmentsEditorUpdateUtils.setIn)(newState, ['segmentsExperienceId'], action.segmentsExperienceId);
        return nextNewState;
      }).then(function (nextNewState) {
        return _updateFragmentEntryLinks(nextNewState, action.segmentsExperienceId);
      }).then(function (nextNewState) {
        return _setUsedWidgets(nextNewState, action.segmentsExperienceId);
      }).then(function (nextNewState) {
        return resolve(nextNewState);
      })["catch"](function (e) {
        reject(e);
      });
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.segmentsEntryId
   * @param {string} action.name
   * @param {string} action.segmentsExperienceId
   * @param {string} action.type
   * @return {Promise}
   * @review
   */

  function editSegmentsExperienceReducer(state, action) {
    return new Promise(function (resolve, reject) {
      var name = action.name,
          segmentsEntryId = action.segmentsEntryId,
          segmentsExperienceId = action.segmentsExperienceId;
      var nextState = state;
      var nameMap = JSON.stringify(_defineProperty({}, state.defaultLanguageId, name));
      Liferay.Service(EDIT_SEGMENTS_EXPERIENCE_URL, {
        active: true,
        nameMap: nameMap,
        segmentsEntryId: segmentsEntryId,
        segmentsExperienceId: segmentsExperienceId
      }, function (obj) {
        var active = obj.active,
            nameCurrentValue = obj.nameCurrentValue,
            priority = obj.priority,
            segmentsEntryId = obj.segmentsEntryId,
            segmentsExperienceId = obj.segmentsExperienceId;
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['availableSegmentsExperiences', segmentsExperienceId], {
          active: active,
          name: nameCurrentValue,
          priority: priority,
          segmentsEntryId: segmentsEntryId,
          segmentsExperienceId: segmentsExperienceId
        });
        resolve(nextState);
      }, function (error) {
        reject(error);
      });
    });
  }
  /**
   *
   *
   * @param {object} state
   * @param {Array} state.availableSegmentsExperiences
   * @param {object} action
   * @param {('up' | 'down')} action.direction
   * @param {string} action.segmentsExperienceId
   * @param {number|string} action.priority
   * @param {string} action.type
   * @return {Promise}
   */

  function updateSegmentsExperiencePriorityReducer(state, action) {
    return new Promise(function (resolve, reject) {
      var direction = action.direction,
          oldPriority = action.priority,
          segmentsExperienceId = action.segmentsExperienceId;
      var nextState = state;
      var priority = typeof oldPriority === 'number' ? oldPriority : parseInt(oldPriority, 10);
      var newPriority = direction === 'up' ? priority + 1 : priority - 1;
      Liferay.Service(UPDATE_SEGMENTS_EXPERIENCE_PRIORITY_URL, {
        newPriority: newPriority,
        segmentsExperienceId: segmentsExperienceId
      }).then(function () {
        var availableSegmentsExperiencesArray = Object.values(nextState.availableSegmentsExperiences);
        var subTargetExperience = availableSegmentsExperiencesArray.find(function (experience) {
          return experience.priority === newPriority;
        });
        var targetExperience = availableSegmentsExperiencesArray.find(function (experience) {
          return experience.priority === priority;
        });
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['availableSegmentsExperiences', targetExperience.segmentsExperienceId, 'priority'], newPriority);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['availableSegmentsExperiences', subTargetExperience.segmentsExperienceId, 'priority'], priority);
        resolve(nextState);
      })["catch"](function (error) {
        reject(error);
      });
    });
  }
  //# sourceMappingURL=segmentsExperiences.es.js.map
});
//# sourceMappingURL=segmentsExperiences.es.js.map