Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/reducers/portlets.es", ['module', 'exports', 'require', 'frontend-js-web', '../utils/FragmentsEditorFetchUtils.es', '../utils/FragmentsEditorGetUtils.es', '../utils/FragmentsEditorUpdateUtils.es', '../utils/fragmentMigrator.es', '../utils/prefixSegmentsExperienceId.es', './fragments.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.addPortletReducer = addPortletReducer;

  var _frontendJsWeb = require("frontend-js-web");

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  var _FragmentsEditorGetUtils = require("../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  var _fragmentMigrator = _interopRequireDefault(require("../utils/fragmentMigrator.es"));

  var _prefixSegmentsExperienceId = require("../utils/prefixSegmentsExperienceId.es");

  var _fragments = require("./fragments.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  /**
   * @param {object} state
   * @param {object} action
   * @param {boolean} action.instanceable
   * @param {string} action.portletId
   * @param {string} action.type
   * @return {object}
   * @review
   */
  function addPortletReducer(state, action) {
    return new Promise(function (resolve) {
      var fragmentEntryLink = null;
      var nextData = null;
      var nextState = state;

      _addPortlet(nextState.addPortletURL, action.portletId, nextState.classNameId, nextState.classPK, nextState.portletNamespace, nextState.segmentsExperienceId || nextState.defaultSegmentsExperienceId).then(function (response) {
        fragmentEntryLink = response;
        nextData = (0, _fragments.addFragment)(fragmentEntryLink.fragmentEntryLinkId, nextState.dropTargetBorder, nextState.dropTargetItemId, nextState.dropTargetItemType, nextState.layoutData);
        return (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextData, nextState.segmentsExperienceId);
      }).then(function () {
        return (0, _fragments.getFragmentEntryLinkContent)(nextState.renderFragmentEntryURL, fragmentEntryLink, nextState.portletNamespace, nextState.segmentsExperienceId || nextState.defaultSegmentsExperienceId);
      }).then(function (response) {
        fragmentEntryLink = response;
        fragmentEntryLink.portletId = action.portletId;
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEntryLinks', fragmentEntryLink.fragmentEntryLinkId], fragmentEntryLink);

        if (!action.instanceable) {
          var widgetPath = (0, _FragmentsEditorGetUtils.getWidgetPath)(nextState.widgets, action.portletId);
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, [].concat(_toConsumableArray(widgetPath), ['used']), true);
        }

        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], nextData);
        resolve(nextState);
      })["catch"](function () {
        resolve(nextState);
      });
    });
  }
  /**
   * @param {string} addPortletURL
   * @param {string} portletId
   * @param {string} classNameId
   * @param {string} classPK
   * @param {string} portletNamespace
   * @param {string} segmentsExperienceId
   * @return {object}
   * @review
   */

  function _addPortlet(addPortletURL, portletId, classNameId, classPK, portletNamespace, segmentsExperienceId) {
    var formData = new FormData();
    formData.append("".concat(portletNamespace, "portletId"), portletId);
    formData.append("".concat(portletNamespace, "classNameId"), classNameId);
    formData.append("".concat(portletNamespace, "classPK"), classPK);
    formData.append("".concat(portletNamespace, "segmentsExperienceId"), segmentsExperienceId);
    return (0, _frontendJsWeb.fetch)(addPortletURL, {
      body: formData,
      method: 'POST'
    }).then(function (response) {
      return response.json();
    }).then(function (response) {
      if (!response.fragmentEntryLinkId) {
        throw new Error();
      }

      return {
        config: {},
        content: response.content,
        editableValues: (0, _fragmentMigrator["default"])(response.editableValues, (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(segmentsExperienceId)),
        fragmentEntryLinkId: response.fragmentEntryLinkId,
        name: response.name
      };
    });
  }
  //# sourceMappingURL=portlets.es.js.map
});
//# sourceMappingURL=portlets.es.js.map