Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/components/sidebar/widgets/SidebarWidgetsPanel.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../../../actions/actions.es', '../../../actions/saveChanges.es', '../../../store/ConnectedComponent.es', '../../../utils/FragmentsEditorComponentUtils.es', '../../../utils/FragmentsEditorDragDrop.es', '../../../utils/FragmentsEditorUpdateUtils.es', '../../../utils/constants', './SidebarWidgetsPanel.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.SidebarWidgetsPanel = exports.ConnectedSidebarWidgetsPanel = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  var _metalPosition = _interopRequireDefault(require("frontend-js-metal-web$metal-position"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _actions = require("../../../actions/actions.es");

  var _saveChanges = require("../../../actions/saveChanges.es");

  var _ConnectedComponent = require("../../../store/ConnectedComponent.es");

  var _FragmentsEditorComponentUtils = require("../../../utils/FragmentsEditorComponentUtils.es");

  var _FragmentsEditorDragDrop = require("../../../utils/FragmentsEditorDragDrop.es");

  var _FragmentsEditorUpdateUtils = require("../../../utils/FragmentsEditorUpdateUtils.es");

  var _constants = require("../../../utils/constants");

  var _SidebarWidgetsPanel = _interopRequireDefault(require("./SidebarWidgetsPanel.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * KeyBoardEvent enter key
   * @review
   * @type {!string}
   */
  var ENTER_KEY = 'Enter';
  /**
   * SidebarWidgetsPanel
   */

  var SidebarWidgetsPanel =
  /*#__PURE__*/
  function (_Component) {
    _inherits(SidebarWidgetsPanel, _Component);

    function SidebarWidgetsPanel() {
      _classCallCheck(this, SidebarWidgetsPanel);

      return _possibleConstructorReturn(this, _getPrototypeOf(SidebarWidgetsPanel).apply(this, arguments));
    }

    _createClass(SidebarWidgetsPanel, [{
      key: "attached",

      /**
       * @inheritdoc
       * @private
       * @review
       */
      value: function attached() {
        this._initializeDragAndDrop();
      }
      /**
       * @inheritdoc
       * @private
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._dragDrop.dispose();
      }
      /**
       * @inheritdoc
       * @param {Object} state
       * @return {Object}
       * @review
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        return (0, _FragmentsEditorUpdateUtils.setIn)(state, ['widgets'], SidebarWidgetsPanel._filterWidgets(state.widgets, state._keywords));
      }
      /**
       * @inheritdoc
       * @param {Object} changes
       * @return {boolean}
       * @review
       */

    }, {
      key: "shouldUpdate",
      value: function shouldUpdate(changes) {
        return (0, _FragmentsEditorComponentUtils.shouldUpdateOnChangeProperties)(changes, ['_keywords', 'spritemap', 'widgets']);
      }
      /**
       * Callback that is executed when an item is being dragged.
       * @param {Object} eventData
       * @param {MouseEvent} eventData.originalEvent
       * @private
       * @review
       */

    }, {
      key: "_handleDrag",
      value: function _handleDrag(eventData) {
        var targetItem = eventData.target;
        var data = targetItem ? targetItem.dataset : null;
        var targetIsColumn = targetItem && 'columnId' in data;
        var targetIsFragment = targetItem && 'fragmentEntryLinkId' in data;
        var targetIsRow = targetItem && 'layoutRowId' in data;
        (0, _FragmentsEditorUpdateUtils.setDraggingItemPosition)(eventData.originalEvent);

        if (targetIsColumn || targetIsFragment || targetIsRow) {
          var mouseY = eventData.originalEvent.clientY;

          var targetItemRegion = _metalPosition["default"].getRegion(targetItem);

          var nearestBorder = _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.bottom;

          if (Math.abs(mouseY - targetItemRegion.top) <= Math.abs(mouseY - targetItemRegion.bottom)) {
            nearestBorder = _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.top;
          }

          var dropTargetItemId = null;
          var dropTargetItemType = null;

          if (targetIsColumn) {
            dropTargetItemId = data.columnId;
            dropTargetItemType = _constants.FRAGMENTS_EDITOR_ITEM_TYPES.column;
          } else if (targetIsFragment) {
            dropTargetItemId = data.fragmentEntryLinkId;
            dropTargetItemType = _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment;
          } else if (targetIsRow) {
            dropTargetItemId = data.layoutRowId;
            dropTargetItemType = _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row;
          }

          this.store.dispatch({
            dropTargetBorder: nearestBorder,
            dropTargetItemId: dropTargetItemId,
            dropTargetItemType: dropTargetItemType,
            type: _actions.UPDATE_DROP_TARGET
          });
        }
      }
      /**
       * Callback that is executed when we leave a drag target.
       * @private
       * @review
       */

    }, {
      key: "_handleDragEnd",
      value: function _handleDragEnd() {
        this.store.dispatch({
          type: _actions.CLEAR_DROP_TARGET
        });
      }
      /**
       * When the search form is submitted, nothing should happen,
       * as filtering is performed on keypress.
       * @param {KeyboardEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleSearchInputKeyUp",
      value: function _handleSearchInputKeyUp(event) {
        if (event.key === ENTER_KEY) {
          event.preventDefault();
          event.stopImmediatePropagation();
        }

        this._keywords = event.delegateTarget.value;
      }
      /**
       * Callback that is executed when an item is dropped.
       * @param {!Object} data
       * @param {!MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDrop",
      value: function _handleDrop(data, event) {
        var _this = this;

        event.preventDefault();

        if (data.target) {
          var _data$source$dataset = data.source.dataset,
              instanceable = _data$source$dataset.instanceable,
              portletId = _data$source$dataset.portletId;
          requestAnimationFrame(function () {
            _this._initializeDragAndDrop();
          });
          this.store.dispatch((0, _saveChanges.enableSavingChangesStatusAction)()).dispatch({
            instanceable: instanceable,
            portletId: portletId,
            type: _actions.ADD_PORTLET
          }).dispatch((0, _saveChanges.updateLastSaveDateAction)()).dispatch((0, _saveChanges.disableSavingChangesStatusAction)()).dispatch({
            type: _actions.CLEAR_DROP_TARGET
          });
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_initializeDragAndDrop",
      value: function _initializeDragAndDrop() {
        if (this._dragDrop) {
          this._dragDrop.dispose();
        }

        this._dragDrop = (0, _FragmentsEditorDragDrop.initializeDragDrop)({
          handles: '.fragments-editor__drag-handler',
          sources: '.fragments-editor__drag-source--sidebar-widget',
          targets: '.fragments-editor__drop-target--sidebar-widget'
        });

        this._dragDrop.on(_metalDragDrop.DragDrop.Events.DRAG, this._handleDrag.bind(this));

        this._dragDrop.on(_metalDragDrop.DragDrop.Events.END, this._handleDrop.bind(this));

        this._dragDrop.on(_metalDragDrop.DragDrop.Events.TARGET_LEAVE, this._handleDragEnd.bind(this));
      }
    }], [{
      key: "_keywordsMatch",

      /**
       * Returns true if the given keywords matches the given text
       * @param {string} text
       * @param {string} keywords
       * @return {boolean}
       * @review
       */
      value: function _keywordsMatch(text, keywords) {
        return text.toLowerCase().indexOf(keywords.toLowerCase()) !== -1;
      }
      /**
       * Filters widgets tree based on the keywords provided
       * @param {Object[]} widgets
       * @param {string} [keywords='']
       * @private
       * @return {Object[]}
       * @review
       */

    }, {
      key: "_filterWidgets",
      value: function _filterWidgets(widgets) {
        var keywords = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
        var filteredWidgets = widgets;

        if (keywords) {
          filteredWidgets = SidebarWidgetsPanel._filterCategories(widgets, keywords);
        }

        return filteredWidgets;
      }
      /**
       * Returns a filtered list of categories
       * @param {Object[]} categories
       * @param {string} keywords
       * @private
       * @return {Object[]}
       * @review
       */

    }, {
      key: "_filterCategories",
      value: function _filterCategories(categories, keywords) {
        return categories.map(function (widgetCategory) {
          return SidebarWidgetsPanel._filterCategory(widgetCategory, keywords);
        }).filter(function (widgetCategory) {
          return widgetCategory;
        });
      }
      /**
       * Filters a widget category based on the keywords provided
       * @param {Object} category
       * @param {string} keywords
       * @private
       * @return {Object}
       * @review
       */

    }, {
      key: "_filterCategory",
      value: function _filterCategory(category, keywords) {
        var filteredCategory = (0, _FragmentsEditorUpdateUtils.setIn)(category, ['categories'], SidebarWidgetsPanel._filterCategories(category.categories || [], keywords));
        var filteredPortlets = (category.portlets || []).filter(function (portlet) {
          return SidebarWidgetsPanel._keywordsMatch(portlet.title, keywords);
        });

        if (!SidebarWidgetsPanel._keywordsMatch(category.title, keywords)) {
          filteredCategory = (0, _FragmentsEditorUpdateUtils.setIn)(filteredCategory, ['portlets'], filteredPortlets);
        }

        if (!filteredCategory.portlets.length && !filteredCategory.categories.length) {
          filteredCategory = null;
        }

        return filteredCategory;
      }
    }]);

    return SidebarWidgetsPanel;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.SidebarWidgetsPanel = SidebarWidgetsPanel;
  SidebarWidgetsPanel.STATE = {
    /**
     * @default ''
     * @instance
     * @memberOf SidebarWidgetsPanel
     * @private
     * @review
     * @type {string}
     */
    _keywords: _metalState.Config.string().internal().value('')
  };
  var ConnectedSidebarWidgetsPanel = (0, _ConnectedComponent.getConnectedComponent)(SidebarWidgetsPanel, ['spritemap', 'widgets']);
  exports.ConnectedSidebarWidgetsPanel = ConnectedSidebarWidgetsPanel;

  _metalSoy["default"].register(ConnectedSidebarWidgetsPanel, _SidebarWidgetsPanel["default"]);

  var _default = ConnectedSidebarWidgetsPanel;
  exports["default"] = _default;
  //# sourceMappingURL=SidebarWidgetsPanel.es.js.map
});
//# sourceMappingURL=SidebarWidgetsPanel.es.js.map