Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/components/sidebar/comments/ReplyCommentForm.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../actions/updateFragmentEntryLinkCommentReply.es', '../../../store/hooks/useDispatch.es', '../../../utils/FragmentsEditorFetchUtils.es', './CommentForm.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.ReplyCommentForm = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _frontendJsWeb = require("frontend-js-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _updateFragmentEntryLinkCommentReply = require("../../../actions/updateFragmentEntryLinkCommentReply.es");

  var _useDispatch = _interopRequireDefault(require("../../../store/hooks/useDispatch.es"));

  var _FragmentsEditorFetchUtils = require("../../../utils/FragmentsEditorFetchUtils.es");

  var _CommentForm = _interopRequireDefault(require("./CommentForm.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var ReplyCommentForm = function ReplyCommentForm(props) {
    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        addingComment = _useState2[0],
        setAddingComment = _useState2[1];

    var _useState3 = (0, _react.useState)(false),
        _useState4 = _slicedToArray(_useState3, 2),
        showForm = _useState4[0],
        setShowForm = _useState4[1];

    var _useState5 = (0, _react.useState)(''),
        _useState6 = _slicedToArray(_useState5, 2),
        textareaContent = _useState6[0],
        setTextareaContent = _useState6[1];

    var dispatch = (0, _useDispatch["default"])();

    return _react["default"].createElement("div", {
      className: "mr-3 pb-2"
    }, showForm ? _react["default"].createElement(_CommentForm["default"], {
      autoFocus: true,
      id: "pageEditorCommentReplyEditor_".concat(props.parentCommentId),
      loading: addingComment,
      onCancelButtonClick: function onCancelButtonClick() {
        setShowForm(false);
        setTextareaContent('');
      },
      onSubmitButtonClick: function handleReplyButtonClick() {
        setAddingComment(true);
        (0, _FragmentsEditorFetchUtils.addFragmentEntryLinkCommentReply)(props.fragmentEntryLinkId, props.parentCommentId, textareaContent).then(function (comment) {
          dispatch((0, _updateFragmentEntryLinkCommentReply.updateFragmentEntryLinkCommentReplyAction)(props.fragmentEntryLinkId, props.parentCommentId, comment));
          setAddingComment(false);
          setShowForm(false);
          setTextareaContent('');
        })["catch"](function () {
          (0, _frontendJsWeb.openToast)({
            message: Liferay.Language.get('the-reply-could-not-be-saved'),
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
          setAddingComment(false);
        });
      },
      onTextareaChange: function onTextareaChange(content) {
        return content && setTextareaContent(content);
      },
      showButtons: true,
      submitButtonLabel: Liferay.Language.get('reply'),
      textareaContent: textareaContent
    }) : _react["default"].createElement(_button["default"], {
      borderless: true,
      disabled: props.disabled,
      displayType: "secondary",
      onClick: function onClick() {
        return setShowForm(true);
      },
      small: true
    }, Liferay.Language.get('reply')));
  };

  exports.ReplyCommentForm = ReplyCommentForm;
  ReplyCommentForm.propTypes = {
    disabled: _propTypes["default"].bool,
    fragmentEntryLinkId: _propTypes["default"].string.isRequired,
    parentCommentId: _propTypes["default"].string.isRequired
  };
  var _default = ReplyCommentForm;
  exports["default"] = _default;
  //# sourceMappingURL=ReplyCommentForm.es.js.map
});
//# sourceMappingURL=ReplyCommentForm.es.js.map