Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/components/sidebar/comments/FragmentComment.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../store/hooks/useSelector.es', '../../../utils/FragmentsEditorFetchUtils.es', '../../common/InlineConfirm.es', '../../common/UserIcon.es', '../../edit_mode/EditModeWrapper.es', './EditCommentForm.es', './ReplyCommentForm.es', './ResolveButton.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentComment = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _frontendJsWeb = require("frontend-js-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _useSelector = _interopRequireDefault(require("../../../store/hooks/useSelector.es"));

  var _FragmentsEditorFetchUtils = require("../../../utils/FragmentsEditorFetchUtils.es");

  var _InlineConfirm = _interopRequireDefault(require("../../common/InlineConfirm.es"));

  var _UserIcon = _interopRequireDefault(require("../../common/UserIcon.es"));

  var _EditModeWrapper = require("../../edit_mode/EditModeWrapper.es");

  var _EditCommentForm = _interopRequireDefault(require("./EditCommentForm.es"));

  var _ReplyCommentForm = _interopRequireDefault(require("./ReplyCommentForm.es"));

  var _ResolveButton = _interopRequireDefault(require("./ResolveButton.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var FragmentComment = function FragmentComment(props) {
    var isReply = props.parentCommentId;
    var resolved = props.comment.resolved;

    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        changingResolved = _useState2[0],
        setChangingResolved = _useState2[1];

    var _useState3 = (0, _react.useState)(false),
        _useState4 = _slicedToArray(_useState3, 2),
        dropDownActive = _useState4[0],
        setDropDownActive = _useState4[1];

    var _useState5 = (0, _react.useState)(false),
        _useState6 = _slicedToArray(_useState5, 2),
        editing = _useState6[0],
        setEditing = _useState6[1];

    var _useState7 = (0, _react.useState)(false),
        _useState8 = _slicedToArray(_useState7, 2),
        hidden = _useState8[0],
        setHidden = _useState8[1];

    var _useState9 = (0, _react.useState)(false),
        _useState10 = _slicedToArray(_useState9, 2),
        highlighted = _useState10[0],
        setHighlighted = _useState10[1];

    var _useState11 = (0, _react.useState)(false),
        _useState12 = _slicedToArray(_useState11, 2),
        showDeleteMask = _useState12[0],
        setShowDeleteMask = _useState12[1];

    var _useState13 = (0, _react.useState)(false),
        _useState14 = _slicedToArray(_useState13, 2),
        showResolveMask = _useState14[0],
        setShowResolveMask = _useState14[1];

    var showResolvedComments = (0, _useSelector["default"])(function (state) {
      return state.showResolvedComments;
    });
    var showModifiedDateTooltip = props.comment.edited && props.comment.modifiedDateDescription;
    var commentClassname = (0, _classnames["default"])({
      'fragments-editor__fragment-comment': true,
      'fragments-editor__fragment-comment--hidden': hidden,
      'fragments-editor__fragment-comment--highlighted': highlighted,
      'fragments-editor__fragment-comment--reply': isReply,
      'fragments-editor__fragment-comment--resolved': resolved,
      'fragments-editor__fragment-comment--with-delete-mask': showDeleteMask,
      'fragments-editor__fragment-comment--with-resolve-mask': showResolveMask,
      small: true
    });

    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

    var hideComment = function hideComment(onHide) {
      setHidden(true);
      setTimeout(function () {
        if (isMounted()) {
          setShowDeleteMask(false);
          setShowResolveMask(false);
          onHide();
        }
      }, 1000);
    };

    (0, _react.useEffect)(function () {
      var highlightMessageId = window.sessionStorage.getItem(_EditModeWrapper.HIGHLIGHTED_COMMENT_ID_KEY);

      if (highlightMessageId === props.comment.commentId) {
        window.sessionStorage.removeItem(_EditModeWrapper.HIGHLIGHTED_COMMENT_ID_KEY);
        setHighlighted(true);
      }
    }, [props.comment.commentId]);
    return _react["default"].createElement("article", {
      className: commentClassname
    }, _react["default"].createElement("div", {
      className: "d-flex mb-2"
    }, _react["default"].createElement(_UserIcon["default"], props.comment.author), _react["default"].createElement("div", {
      className: "flex-grow-1 overflow-hidden pl-2"
    }, _react["default"].createElement("p", {
      className: "m-0 text-truncate"
    }, _react["default"].createElement("strong", {
      className: "lfr-portal-tooltip",
      "data-title": props.comment.author.fullName
    }, props.comment.author.fullName)), _react["default"].createElement("p", {
      className: (0, _classnames["default"])('m-0 text-secondary', {
        'lfr-portal-tooltip': showModifiedDateTooltip
      }),
      "data-title": showModifiedDateTooltip && Liferay.Util.sub(Liferay.Language.get('edited-x'), props.comment.modifiedDateDescription)
    }, props.comment.dateDescription)), !isReply && _react["default"].createElement(_ResolveButton["default"], {
      disabled: editing,
      loading: changingResolved,
      onClick: function handleResolveButtonClick() {
        setChangingResolved(true);
        (0, _FragmentsEditorFetchUtils.editFragmentEntryLinkComment)(props.comment.commentId, props.comment.body, !resolved).then(function (comment) {
          setChangingResolved(false);

          if (showResolvedComments) {
            props.onEdit(comment);
          } else if (!resolved) {
            setShowResolveMask(true);
            hideComment(function () {
              return props.onEdit(comment);
            });
          }
        })["catch"](function () {
          (0, _frontendJsWeb.openToast)({
            message: resolved ? Liferay.Language.get('the-comment-could-not-be-unresolved') : Liferay.Language.get('the-comment-could-not-be-resolved'),
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
          setChangingResolved(false);
        });
      },
      resolved: resolved
    }), Liferay.ThemeDisplay.getUserId() === props.comment.author.userId && _react["default"].createElement(_dropDown["default"], {
      active: dropDownActive,
      onActiveChange: setDropDownActive,
      trigger: _react["default"].createElement(_button["default"], {
        borderless: true,
        disabled: editing,
        displayType: "secondary",
        monospaced: true,
        outline: true,
        small: true
      }, _react["default"].createElement(_icon["default"], {
        symbol: "ellipsis-v"
      }))
    }, _react["default"].createElement(_dropDown["default"].ItemList, null, _react["default"].createElement(_dropDown["default"].Item, {
      disabled: resolved,
      onClick: function onClick() {
        setDropDownActive(false);
        setEditing(true);
      }
    }, Liferay.Language.get('edit')), _react["default"].createElement(_dropDown["default"].Item, {
      onClick: function onClick() {
        setDropDownActive(false);
        setShowDeleteMask(true);
      }
    }, Liferay.Language.get('delete'))))), editing ? _react["default"].createElement(_EditCommentForm["default"], {
      comment: props.comment,
      fragmentEntryLinkId: props.fragmentEntryLinkId,
      onCloseForm: function onCloseForm() {
        return setEditing(false);
      },
      onEdit: props.onEdit
    }) : _react["default"].createElement("div", {
      className: "content pb-2 text-secondary",
      dangerouslySetInnerHTML: {
        __html: props.comment.body
      }
    }), !isReply && props.comment.children && Boolean(props.comment.children.length) && _react["default"].createElement("footer", {
      className: "fragments-editor__fragment-comment-replies mb-2"
    }, props.comment.children && props.comment.children.map(function (childComment) {
      return _react["default"].createElement(FragmentComment, {
        comment: _objectSpread({}, childComment, {
          resolved: resolved
        }),
        fragmentEntryLinkId: props.fragmentEntryLinkId,
        key: childComment.commentId,
        onDelete: props.onDelete,
        onEdit: props.onEditReply(props.comment.commentId),
        onEditReply: props.onEditReply,
        parentCommentId: props.comment.commentId
      });
    })), !isReply && _react["default"].createElement(_ReplyCommentForm["default"], {
      disabled: editing || resolved,
      fragmentEntryLinkId: props.fragmentEntryLinkId,
      parentCommentId: props.comment.commentId
    }), showDeleteMask && _react["default"].createElement(_InlineConfirm["default"], {
      cancelButtonLabel: Liferay.Language.get('cancel'),
      confirmButtonLabel: Liferay.Language.get('delete'),
      message: Liferay.Language.get('are-you-sure-you-want-to-delete-this-comment'),
      onCancelButtonClick: function onCancelButtonClick() {
        return setShowDeleteMask(false);
      },
      onConfirmButtonClick: function onConfirmButtonClick() {
        return (0, _FragmentsEditorFetchUtils.deleteFragmentEntryLinkComment)(props.comment.commentId).then(function () {
          return hideComment(function () {
            return props.onDelete(props.comment);
          });
        })["catch"](function () {
          (0, _frontendJsWeb.openToast)({
            message: Liferay.Language.get('the-comment-could-not-be-deleted'),
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
        });
      }
    }), showResolveMask && _react["default"].createElement("div", {
      className: "resolve-mask"
    }, _react["default"].createElement(_icon["default"], {
      symbol: "check-circle"
    })));
  };

  exports.FragmentComment = FragmentComment;
  FragmentComment.propTypes = {
    comment: _propTypes["default"].shape({
      author: _propTypes["default"].shape({
        fullName: _propTypes["default"].string,
        portraitURL: _propTypes["default"].string
      }),
      body: _propTypes["default"].string,
      commentId: _propTypes["default"].string.isRequired,
      dateDescription: _propTypes["default"].string
    }),
    fragmentEntryLinkId: _propTypes["default"].string.isRequired,
    onDelete: _propTypes["default"].func,
    onEdit: _propTypes["default"].func,
    onEditReply: _propTypes["default"].func,
    parentCommentId: _propTypes["default"].string
  };
  var _default = FragmentComment;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentComment.es.js.map
});
//# sourceMappingURL=FragmentComment.es.js.map