Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/components/sidebar/comments/EditCommentForm.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../utils/FragmentsEditorFetchUtils.es', './CommentForm.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.EditCommentForm = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _FragmentsEditorFetchUtils = require("../../../utils/FragmentsEditorFetchUtils.es");

  var _CommentForm = _interopRequireDefault(require("./CommentForm.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var EditCommentForm = function EditCommentForm(props) {
    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        editingComment = _useState2[0],
        setEditingComment = _useState2[1];

    var _useState3 = (0, _react.useState)(props.comment.body),
        _useState4 = _slicedToArray(_useState3, 2),
        textareaContent = _useState4[0],
        setTextareaContent = _useState4[1];

    return _react["default"].createElement(_CommentForm["default"], {
      autoFocus: true,
      id: "pageEditorCommentEditor_".concat(props.comment.commentId),
      loading: editingComment,
      onCancelButtonClick: function onCancelButtonClick() {
        return props.onCloseForm();
      },
      onSubmitButtonClick: function _handleCommentButtonClick() {
        setEditingComment(true);
        (0, _FragmentsEditorFetchUtils.editFragmentEntryLinkComment)(props.comment.commentId, textareaContent).then(function (comment) {
          setEditingComment(false);
          props.onEdit(comment);
          props.onCloseForm();
        })["catch"](function () {
          (0, _frontendJsWeb.openToast)({
            message: Liferay.Language.get('the-comment-could-not-be-edited'),
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
          setEditingComment(false);
        });
      },
      onTextareaChange: function onTextareaChange(content) {
        return setTextareaContent(content);
      },
      showButtons: true,
      submitButtonLabel: Liferay.Language.get('update'),
      textareaContent: textareaContent
    });
  };

  exports.EditCommentForm = EditCommentForm;
  EditCommentForm.defaultProps = {
    onEdit: function onEdit() {}
  };
  EditCommentForm.propTypes = {
    comment: _propTypes["default"].shape({
      body: _propTypes["default"].string.isRequired,
      commentId: _propTypes["default"].string.isRequired
    }),
    onCloseForm: _propTypes["default"].func.isRequired,
    onEdit: _propTypes["default"].func
  };
  var _default = EditCommentForm;
  exports["default"] = _default;
  //# sourceMappingURL=EditCommentForm.es.js.map
});
//# sourceMappingURL=EditCommentForm.es.js.map