Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/components/fragment_processors/EditableHTMLFragmentProcessor.es", ['module', 'exports', 'require', './EditableRichTextFragmentProcessor.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _EditableRichTextFragmentProcessor = require("./EditableRichTextFragmentProcessor.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var _changedCallback = null;
  var _destroyedCallback = null;

  var _dialog;

  var _editableElement;

  var _editor;
  /**
   * Destroys, if any, an existing instance of LiferayFullScreenSourceEditor.
   */

  function destroy() {
    if (_dialog) {
      _editableElement.removeAttribute('style');

      _dialog.destroy();

      _editor.destroy();

      _dialog = null;
      _editableElement = null;
      _editor = null;

      _destroyedCallback();

      _destroyedCallback = null;
      _changedCallback = null;
    }
  }
  /**
   * Creates an instance of LiferayFullScreenSourceEditor and destroys the existing one if any.
   * @param {HTMLElement} editableElement
   * @param {string} fragmentEntryLinkId
   * @param {string} portletNamespace
   * @param {Object} options
   * @param {function} changedCallback
   * @param {function} destroyedCallback
   */

  function init(editableElement, fragmentEntryLinkId, portletNamespace, options, changedCallback, destroyedCallback) {
    var _destroy = destroy;
    _editableElement = editableElement;
    _changedCallback = changedCallback;
    _destroyedCallback = destroyedCallback;
    Liferay.Util.openWindow({
      dialog: {
        after: {
          destroy: function destroy() {
            _destroy();
          }
        },
        constrain: true,
        cssClass: 'lfr-fulscreen-source-editor-dialog modal-full-screen',
        destroyOnHide: true,
        modal: true,
        'toolbars.footer': [{
          label: Liferay.Language.get('cancel'),
          on: {
            click: function click() {
              _dialog.hide();
            }
          }
        }, {
          cssClass: 'btn-primary',
          label: Liferay.Language.get('save'),
          on: {
            click: function click() {
              _dialog.hide();

              _changedCallback(_editor.get('value'));
            }
          }
        }]
      },
      title: Liferay.Language.get('edit-content')
    }, function (dialog) {
      _dialog = dialog;
      Liferay.Util.getTop().AUI().use('liferay-fullscreen-source-editor', function (A) {
        _editor = new A.LiferayFullScreenSourceEditor({
          boundingBox: dialog.getStdModNode(A.WidgetStdMod.BODY).appendChild('<div></div>'),
          previewCssClass: 'alloy-editor alloy-editor-placeholder',
          value: editableElement.innerHTML
        }).render();
      });
    });
  }
  /**
   * @param {string} content editableField's original HTML
   * @param {string} value Translated/segmented value
   * @return {string} Transformed content
   */

  function render(content, value) {
    return value;
  }

  var _default = {
    destroy: destroy,
    getFloatingToolbarButtons: _EditableRichTextFragmentProcessor.getFloatingToolbarButtons,
    init: init,
    render: render
  };
  exports["default"] = _default;
  //# sourceMappingURL=EditableHTMLFragmentProcessor.es.js.map
});
//# sourceMappingURL=EditableHTMLFragmentProcessor.es.js.map