Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/components/fragment_entry_link/FragmentEntryLinkListRow.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../floating_toolbar/background_color/FloatingToolbarBackgroundColorPanel.es', '../floating_toolbar/layout_background_image/FloatingToolbarLayoutBackgroundImagePanel.es', '../floating_toolbar/spacing/FloatingToolbarSpacingPanel.es', './ColumnOverlayGrid.es', './FragmentEntryLink.es', '../../actions/removeRow.es', '../../actions/updateRowColumns.es', '../../store/ConnectedComponent.es', '../../utils/FragmentsEditorComponentUtils.es', '../../utils/FragmentsEditorFetchUtils.es', '../../utils/FragmentsEditorGetUtils.es', '../../utils/FragmentsEditorUpdateUtils.es', '../../utils/constants', '../floating_toolbar/FloatingToolbar.es', './FragmentEntryLinkListRow.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentEntryLinkListRow = exports.ConnectedFragmentEntryLinkListRow = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  require("../floating_toolbar/background_color/FloatingToolbarBackgroundColorPanel.es");

  require("../floating_toolbar/layout_background_image/FloatingToolbarLayoutBackgroundImagePanel.es");

  require("../floating_toolbar/spacing/FloatingToolbarSpacingPanel.es");

  require("./ColumnOverlayGrid.es");

  require("./FragmentEntryLink.es");

  var _removeRow = require("../../actions/removeRow.es");

  var _updateRowColumns2 = require("../../actions/updateRowColumns.es");

  var _ConnectedComponent = _interopRequireDefault(require("../../store/ConnectedComponent.es"));

  var _FragmentsEditorComponentUtils = require("../../utils/FragmentsEditorComponentUtils.es");

  var _FragmentsEditorFetchUtils = require("../../utils/FragmentsEditorFetchUtils.es");

  var _FragmentsEditorGetUtils = require("../../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorUpdateUtils = require("../../utils/FragmentsEditorUpdateUtils.es");

  var _constants = require("../../utils/constants");

  var _FloatingToolbar = _interopRequireDefault(require("../floating_toolbar/FloatingToolbar.es"));

  var _FragmentEntryLinkListRow = _interopRequireDefault(require("./FragmentEntryLinkListRow.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Creates a Fragment Entry Link List Row component.
   */
  var FragmentEntryLinkListRow =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FragmentEntryLinkListRow, _Component);

    function FragmentEntryLinkListRow() {
      _classCallCheck(this, FragmentEntryLinkListRow);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentEntryLinkListRow).apply(this, arguments));
    }

    _createClass(FragmentEntryLinkListRow, [{
      key: "created",

      /**
       * @inheritdoc
       */
      value: function created() {
        this._handleBodyMouseLeave = this._handleBodyMouseLeave.bind(this);
        this._handleBodyMouseMove = this._handleBodyMouseMove.bind(this);
        this._handleBodyMouseUp = this._handleBodyMouseUp.bind(this);
        document.body.addEventListener('mouseleave', this._handleBodyMouseLeave);
        document.body.addEventListener('mouseup', this._handleBodyMouseUp);
      }
      /**
       * @inheritdoc
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._disposeFloatingToolbar();

        document.body.removeEventListener('mouseleave', this._handleBodyMouseLeave);
        document.body.removeEventListener('mousemove', this._handleBodyMouseMove);
        document.body.removeEventListener('mouseup', this._handleBodyMouseUp);
      }
      /**
       * @inheritdoc
       * @param {object} state
       * @return {object}
       * @review
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        var columnResizerVisible;
        var nextState = state;

        if (this.rowId === this.activeItemId && this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row) {
          columnResizerVisible = true;
        }

        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_backgroundImageValue'], this._getBackgroundImageValue());
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_columnResizerVisible'], columnResizerVisible);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_fragmentsEditorRowTypes'], _constants.FRAGMENTS_EDITOR_ROW_TYPES);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_highlighted'], FragmentEntryLinkListRow._isHighlighted(state.dropTargetItemId, state.dropTargetItemType, state.rowId, state.layoutData.structure));

        if (nextState._resizing && nextState._resizeRowColumns) {
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['columns'], state._resizeRowColumns);
        }

        return nextState;
      }
      /**
       * @inheritdoc
       */

    }, {
      key: "rendered",
      value: function rendered() {
        if (this.rowId === this.activeItemId && this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row && !this._resizing && this.row.type !== _constants.FRAGMENTS_EDITOR_ROW_TYPES.sectionRow) {
          this._createFloatingToolbar();
        } else {
          this._disposeFloatingToolbar();
        }

        if (this._resizing) {
          this.element.focus();
        }
      }
      /**
       * @inheritdoc
       * @return {boolean}
       * @review
       */

    }, {
      key: "shouldUpdate",
      value: function shouldUpdate(changes) {
        return (0, _FragmentsEditorComponentUtils.shouldUpdatePureComponent)(changes);
      }
      /**
       * Handle getAssetFieldValueURL changed
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncGetAssetFieldValueURL",
      value: function syncGetAssetFieldValueURL() {
        this._updateMappedBackgroundFieldValue();
      }
      /**
       * Handle layoutData changed
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncLayoutData",
      value: function syncLayoutData() {
        this._updateMappedBackgroundFieldValue();
      }
      /**
       * Clears resizing properties.
       * @private
       */

    }, {
      key: "_clearResizing",
      value: function _clearResizing() {
        document.body.removeEventListener('mousemove', this._handleBodyMouseMove);
        this._resizeColumnIndex = 0;
        this._resizeHighlightedColumn = null;
        this._resizeInitialPosition = 0;
        this._resizeRowColumns = null;
        this._resizing = false;
      }
      /**
       * Creates a new instance of the floating toolbar.
       * @private
       */

    }, {
      key: "_createFloatingToolbar",
      value: function _createFloatingToolbar() {
        var config = {
          anchorElement: this.element,
          buttons: FragmentEntryLinkListRow._getFloatingToolbarButtons(this.row.config),
          item: this.row,
          itemId: this.rowId,
          itemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row,
          portalElement: document.body,
          store: this.store
        };

        if (this._floatingToolbar) {
          this._floatingToolbar.setState(config);
        } else {
          this._floatingToolbar = new _FloatingToolbar["default"](config);
        }
      }
      /**
       * Disposes of an existing floating toolbar instance.
       * @private
       */

    }, {
      key: "_disposeFloatingToolbar",
      value: function _disposeFloatingToolbar() {
        if (this._floatingToolbar) {
          this._floatingToolbar.dispose();

          this._floatingToolbar = null;
        }
      }
      /**
       * @private
       */

    }, {
      key: "_getBackgroundImageValue",
      value: function _getBackgroundImageValue() {
        if (this._mappedBackgroundFieldValue) {
          return this._mappedBackgroundFieldValue;
        }

        var config = this.row.config;

        if (!config) {
          return '';
        }

        if (typeof config.backgroundImage === 'string') {
          return config.backgroundImage;
        }

        if (_typeof(config.backgroundImage) === 'object') {
          return config.backgroundImage.url;
        }

        return '';
      }
      /**
       * Callback executed when a row loses focus.
       * @private
       * @review
       */

    }, {
      key: "_handleBodyMouseLeave",
      value: function _handleBodyMouseLeave() {
        if (this._resizing) {
          this._clearResizing();
        }
      }
      /**
       * Callback executed when a row is clicked.
       * @param {Event} event
       * @private
       */

    }, {
      key: "_handleBodyMouseMove",
      value: function _handleBodyMouseMove(event) {
        var columnElement = this.refs.resizeColumn;
        var columnIndex = this._resizeColumnIndex;
        var nextColumnElement = this.refs.resizeNextColumn;
        var nextColumnIndex = columnIndex + 1;
        var languageDirection = Liferay.Language.direction[Liferay.ThemeDisplay.getLanguageId()];

        if (languageDirection === 'rtl') {
          columnElement = this.refs.resizeNextColumn;
          columnIndex = nextColumnIndex;
          nextColumnElement = this.refs.resizeColumn;
          nextColumnIndex = this._resizeColumnIndex;
        }

        var nextColumnRect = nextColumnElement.getBoundingClientRect();
        var maxPosition = nextColumnRect.left + nextColumnRect.width;
        var minPosition = columnElement.getBoundingClientRect().left;
        var position = Math.max(Math.min(event.clientX, maxPosition), minPosition);
        var column = this._resizeRowColumns[columnIndex];
        var nextColumn = this._resizeRowColumns[nextColumnIndex];
        var maxColumns = (parseInt(column.size, 10) || 1) + (parseInt(nextColumn.size, 10) || 1) - 1;
        var columns = Math.max(Math.round((position - minPosition) / (maxPosition - minPosition) * maxColumns), 1);
        this._resizeRowColumns = (0, _FragmentsEditorUpdateUtils.setIn)(this._resizeRowColumns, [columnIndex, 'size'], columns.toString());
        this._resizeRowColumns = (0, _FragmentsEditorUpdateUtils.setIn)(this._resizeRowColumns, [nextColumnIndex, 'size'], (maxColumns - columns + 1).toString());

        if (languageDirection === 'rtl') {
          this._resizeHighlightedColumn = maxColumns - this._resizeRowColumns.slice(columnIndex).map(function (column) {
            return parseInt(column.size, 10) || 1;
          }).reduce(function (size, columnSize) {
            return size + columnSize;
          }, 0);
        } else {
          this._resizeHighlightedColumn = this._resizeRowColumns.slice(0, nextColumnIndex).map(function (column) {
            return parseInt(column.size, 10) || 1;
          }).reduce(function (size, columnSize) {
            return size + columnSize;
          }, 0) - 1;
        }
      }
      /**
       * Callback executed when the mouse hovers over a row.
       * @param {Event} event
       * @private
       */

    }, {
      key: "_handleBodyMouseUp",
      value: function _handleBodyMouseUp() {
        if (this._resizing) {
          this._updateRowColumns(this._resizeRowColumns);

          this._clearResizing();
        }
      }
      /**
       * @private
       */

    }, {
      key: "_handleResizerMouseDown",
      value: function _handleResizerMouseDown(event) {
        this._resizeColumnIndex = this.row.columns.findIndex(function (column) {
          return column.columnId === event.delegateTarget.dataset.columnId;
        });
        this._resizeInitialPosition = event.clientX;
        this._resizeRowColumns = this.row.columns;
        this._resizing = true;
        document.body.addEventListener('mousemove', this._handleBodyMouseMove);
      }
      /**
       * Callback executed when a key is pressed on the focused row.
       * @private
       * @param {KeyboardEvent} event
       */

    }, {
      key: "_handleRowKeyUp",
      value: function _handleRowKeyUp(event) {
        if (this.activeItemId === this.rowId && this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row) {
          var direction = (0, _FragmentsEditorGetUtils.getItemMoveDirection)(event.keyCode);

          if (direction) {
            (0, _FragmentsEditorUpdateUtils.moveRow)(direction, (0, _FragmentsEditorGetUtils.getRowIndex)(this.layoutData.structure, this.rowId), this.store, this.layoutData.structure);
          }
        }
      }
      /**
       * Callback executed when the remove row button is clicked.
       * @param {Event} event
       * @private
       */

    }, {
      key: "_handleRowRemoveButtonClick",
      value: function _handleRowRemoveButtonClick(event) {
        event.stopPropagation();
        (0, _FragmentsEditorUpdateUtils.removeItem)(this.store, (0, _removeRow.removeRowAction)(this.hoveredItemId));
      }
      /**
       * Updates mapped field value
       * @private
       * @review
       */

    }, {
      key: "_updateMappedBackgroundFieldValue",
      value: function _updateMappedBackgroundFieldValue() {
        var _this = this;

        if (this.getAssetFieldValueURL && this.row.config.backgroundImage && (0, _FragmentsEditorGetUtils.editableIsMappedToAssetEntry)(this.row.config.backgroundImage)) {
          (0, _FragmentsEditorFetchUtils.getAssetFieldValue)(this.row.config.backgroundImage.classNameId, this.row.config.backgroundImage.classPK, this.row.config.backgroundImage.fieldId).then(function (response) {
            var fieldValue = response.fieldValue;

            if (fieldValue && fieldValue.url !== _this._mappedBackgroundFieldValue) {
              _this._mappedBackgroundFieldValue = fieldValue.url;
            }
          });
        } else {
          this._mappedBackgroundFieldValue = null;
        }
      }
      /**
       * Updates row columns.
       * @param {Array} columns The row columns to update.
       * @private
       */

    }, {
      key: "_updateRowColumns",
      value: function _updateRowColumns(columns) {
        this.store.dispatch((0, _updateRowColumns2.updateRowColumnsAction)(columns, this.rowId));
      }
    }], [{
      key: "_getFloatingToolbarButtons",

      /**
       * @param {object} config
       * @return {object[]} Floating toolbar buttons
       */
      value: function _getFloatingToolbarButtons(config) {
        var buttons = [];
        buttons.push(_constants.FLOATING_TOOLBAR_BUTTONS.backgroundColor);

        var layoutBackgroundImageButton = _objectSpread({}, _constants.FLOATING_TOOLBAR_BUTTONS.layoutBackgroundImage);

        if (config.backgroundImage && (config.backgroundImage.mappedField || config.backgroundImage.fieldId)) {
          layoutBackgroundImageButton.cssClass = 'fragments-editor__floating-toolbar--mapped-field';
        }

        buttons.push(layoutBackgroundImageButton);
        buttons.push(_constants.FLOATING_TOOLBAR_BUTTONS.spacing);
        return buttons;
      }
      /**
       * Checks if the given row should be highlighted
       * @param {string} dropTargetItemId
       * @param {string} dropTargetItemType
       * @param {string} rowId
       * @param {object} structure
       * @private
       * @return {boolean}
       * @review
       */

    }, {
      key: "_isHighlighted",
      value: function _isHighlighted(dropTargetItemId, dropTargetItemType, rowId, structure) {
        var highlighted = false;

        if (dropTargetItemId) {
          var dropTargetPath = (0, _FragmentsEditorGetUtils.getItemPath)(dropTargetItemId, dropTargetItemType, structure);
          var rowInDropTargetPath = (0, _FragmentsEditorGetUtils.itemIsInPath)(dropTargetPath, rowId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row);
          var row = structure.find(function (row) {
            return row.rowId === rowId;
          });
          var rowIsDropTarget = dropTargetItemId === rowId && dropTargetItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row;
          highlighted = row.type !== _constants.FRAGMENTS_EDITOR_ROW_TYPES.sectionRow && rowInDropTargetPath && !rowIsDropTarget;
        }

        return highlighted;
      }
    }]);

    return FragmentEntryLinkListRow;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  exports.FragmentEntryLinkListRow = FragmentEntryLinkListRow;
  FragmentEntryLinkListRow.STATE = {
    /**
     * Floating toolbar instance for internal use.
     * @default null
     * @instance
     * @memberOf FragmentEntryLinkListRow
     * @type {object|null}
     */
    _floatingToolbar: _metalState.Config.internal().value(null),

    /**
     * Mapped background field value
     * @instance
     * @memberOf FragmentEntryLinkListRow
     * @private
     * @review
     * @type {string}
     */
    _mappedBackgroundFieldValue: _metalState.Config.internal().string(),

    /**
     * Index of the column being resized.
     * @default 0
     * @instance
     * @memberOf FragmentEntryLinkListRow
     * @private
     * @type {number}
     */
    _resizeColumnIndex: _metalState.Config.internal().number().value(0),

    /**
     * Index of the column that should be highlighted when resized.
     * @default null
     * @instance
     * @memberOf FragmentEntryLinkListRow
     * @private
     * @type {number}
     */
    _resizeHighlightedColumn: _metalState.Config.internal().number().value(null),

    /**
     * Mouse position when the resize is started.
     * @default 0
     * @instance
     * @memberOf FragmentEntryLinkListRow
     * @private
     * @type {number}
     */
    _resizeInitialPosition: _metalState.Config.internal().number().value(0),

    /**
     * Copy of row columns for resizing.
     * @default null
     * @instance
     * @memberOf FragmentEntryLinkListRow
     * @type {Array}
     */
    _resizeRowColumns: _metalState.Config.internal().array().value(null),

    /**
     * If <code>true</code>, the user is resizing a column.
     * @default false
     * @instance
     * @memberOf FragmentEntryLinkListRow
    	 * @type {boolean}
     */
    _resizing: _metalState.Config.internal().bool().value(false),

    /**
     * Row.
     * @default undefined
     * @instance
     * @memberof FragmentEntryLinkListRow
     * @type {object}
     */
    row: _metalState.Config.object().required(),

    /**
     * Row ID.
     * @default undefined
     * @instance
     * @memberof FragmentEntryLinkListRow
     * @type {string}
     */
    rowId: _metalState.Config.string().required()
  };
  var ConnectedFragmentEntryLinkListRow = (0, _ConnectedComponent["default"])(FragmentEntryLinkListRow, ['activeItemId', 'activeItemType', 'dropTargetBorder', 'dropTargetItemId', 'dropTargetItemType', 'getAssetFieldValueURL', 'hoveredItemId', 'hoveredItemType', 'layoutData', 'mappingFieldsURL', 'selectedMappingTypes', 'spritemap']);
  exports.ConnectedFragmentEntryLinkListRow = ConnectedFragmentEntryLinkListRow;

  _metalSoy["default"].register(ConnectedFragmentEntryLinkListRow, _FragmentEntryLinkListRow["default"]);

  var _default = FragmentEntryLinkListRow;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentEntryLinkListRow.es.js.map
});
//# sourceMappingURL=FragmentEntryLinkListRow.es.js.map