Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/components/fragment_entry_link/FragmentEditableBackgroundImage.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-state', '../../store/store.es', '../floating_toolbar/fragment_background_image/FloatingToolbarFragmentBackgroundImagePanel.es', '../../actions/updateEditableValue.es', '../../store/ConnectedComponent.es', '../../utils/FragmentsEditorDialogUtils', '../../utils/FragmentsEditorFetchUtils.es', '../../utils/FragmentsEditorGetUtils.es', '../../utils/constants', '../../utils/prefixSegmentsExperienceId.es', '../floating_toolbar/FloatingToolbar.es', '../fragment_processors/EditableBackgroundImageProcessor.es', '../fragment_processors/FragmentProcessors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentEditableBackgroundImage = exports.ConnectedFragmentEditableBackgroundImage = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _store = require("../../store/store.es");

  require("../floating_toolbar/fragment_background_image/FloatingToolbarFragmentBackgroundImagePanel.es");

  var _updateEditableValue = require("../../actions/updateEditableValue.es");

  var _ConnectedComponent = _interopRequireDefault(require("../../store/ConnectedComponent.es"));

  var _FragmentsEditorDialogUtils = require("../../utils/FragmentsEditorDialogUtils");

  var _FragmentsEditorFetchUtils = require("../../utils/FragmentsEditorFetchUtils.es");

  var _FragmentsEditorGetUtils = require("../../utils/FragmentsEditorGetUtils.es");

  var _constants = require("../../utils/constants");

  var _prefixSegmentsExperienceId = require("../../utils/prefixSegmentsExperienceId.es");

  var _FloatingToolbar = _interopRequireDefault(require("../floating_toolbar/FloatingToolbar.es"));

  var _EditableBackgroundImageProcessor = _interopRequireDefault(require("../fragment_processors/EditableBackgroundImageProcessor.es"));

  var _FragmentProcessors = _interopRequireDefault(require("../fragment_processors/FragmentProcessors.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * FragmentEditableBackgroundImage
   */
  var FragmentEditableBackgroundImage =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FragmentEditableBackgroundImage, _Component);

    function FragmentEditableBackgroundImage() {
      _classCallCheck(this, FragmentEditableBackgroundImage);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentEditableBackgroundImage).apply(this, arguments));
    }

    _createClass(FragmentEditableBackgroundImage, [{
      key: "created",

      /**
       * @inheritDoc
       * @review
       */
      value: function created() {
        this._handleFloatingToolbarButtonClicked = this._handleFloatingToolbarButtonClicked.bind(this);
        this._handleEditableBackgroundImageClick = this._handleEditableBackgroundImageClick.bind(this);
        this.element.classList.add('fragments-editor__background-image-editable');
        this.element.addEventListener('click', this._handleEditableBackgroundImageClick);

        this._setEditableAttributes();
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._disposeFloatingToolbar();

        if (this.element) {
          this.element.removeEventListener('click', this._handleEditableBackgroundImageClick);
        }
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncActiveItemId",
      value: function syncActiveItemId() {
        if (this.activeItemId === this._getItemId() && this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.backgroundImageEditable) {
          this._active = true;
          this.element.classList.add('fragments-editor__background-image-editable--active');

          this._createFloatingToolbar();
        } else {
          this._active = false;
          this.element.classList.remove('fragments-editor__background-image-editable--active');

          this._disposeFloatingToolbar();
        }

        this._setHighlightedState();
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncEditableValues",
      value: function syncEditableValues(editableValues) {
        if (this._floatingToolbar) {
          this._createFloatingToolbar();
        }

        if ((0, _FragmentsEditorGetUtils.editableIsMapped)(editableValues)) {
          this._updateMappedFieldValue();

          this.element.classList.add('fragments-editor__background-image-editable--mapped');
        } else {
          this._renderBackgroundImage();

          this.element.classList.remove('fragments-editor__background-image-editable--mapped');
        }
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncDefaultLanguageId",
      value: function syncDefaultLanguageId() {
        this._renderBackgroundImage();
      }
      /**
       * Handle getAssetFieldValueURL changed
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncGetAssetFieldValueURL",
      value: function syncGetAssetFieldValueURL() {
        this._updateMappedFieldValue();
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncHoveredItemId",
      value: function syncHoveredItemId() {
        if (this.hoveredItemId === this._getItemId() && this.hoveredItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.backgroundImageEditable) {
          this.element.classList.add('fragments-editor__background-image-editable--hovered');
        } else {
          this.element.classList.remove('fragments-editor__background-image-editable--hovered');
        }

        this._setHighlightedState();
      }
      /**
       * Creates tooltip instance
       * @private
       * @review
       */

    }, {
      key: "_createFloatingToolbar",
      value: function _createFloatingToolbar() {
        var processor = _FragmentProcessors["default"]['backgroundImage'];
        var config = {
          anchorElement: this.element,
          buttons: processor.getFloatingToolbarButtons(this.editableValues),
          events: {
            buttonClicked: this._handleFloatingToolbarButtonClicked
          },
          item: {
            backgroundImage: this._getBackgroundImageValue(),
            editableId: this.editableId,
            editableValues: this.editableValues,
            fragmentEntryLinkId: this.fragmentEntryLinkId,
            type: 'image'
          },
          itemId: this._getItemId(),
          itemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.backgroundImageEditable,
          portalElement: document.body,
          store: this.store
        };

        if (this._floatingToolbar) {
          this._floatingToolbar.setState(config);
        } else {
          this._floatingToolbar = new _FloatingToolbar["default"](config);
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_disposeFloatingToolbar",
      value: function _disposeFloatingToolbar() {
        if (this._floatingToolbar) {
          this._floatingToolbar.dispose();

          this._floatingToolbar = null;
        }
      }
      /**
       * Get background image translated value
       * @private
       * @review
       */

    }, {
      key: "_getBackgroundImageValue",
      value: function _getBackgroundImageValue() {
        var defaultSegmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.defaultSegmentsExperienceId);
        var segmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.segmentsExperienceId);
        var segmentedValue = this.editableValues[segmentsExperienceId] || this.editableValues[defaultSegmentsExperienceId] || this.editableValues;
        var translatedValue = segmentedValue[this.languageId] || segmentedValue[this.defaultLanguageId];
        return translatedValue;
      }
      /**
       * @private
       * @return {string} Valid FragmentsEditor itemId for its
       * 	fragmentEntryLinkId and editableId
       * @review
       */

    }, {
      key: "_getItemId",
      value: function _getItemId() {
        return "".concat(this.fragmentEntryLinkId, "-").concat(this.editableId);
      }
      /**
       * Callback executed when the background image editable is clicked
       * @param {Event} event
       * @private
       */

    }, {
      key: "_handleEditableBackgroundImageClick",
      value: function _handleEditableBackgroundImageClick(event) {
        var _this = this;

        var item = event.target.closest('[data-fragments-editor-item-id]');

        if (item === this.element && this._active) {
          (0, _FragmentsEditorDialogUtils.openImageSelector)({
            callback: function callback(image) {
              return _this._updateFragmentBackgroundImage(image);
            },
            imageSelectorURL: this.imageSelectorURL,
            portletNamespace: this.portletNamespace
          });
        }
      }
      /**
       * Callback executed when an floating toolbar button is clicked
       * @param {Event} event
       * @param {Object} data
       * @private
       */

    }, {
      key: "_handleFloatingToolbarButtonClicked",
      value: function _handleFloatingToolbarButtonClicked(event, data) {
        var _this2 = this;

        var panelId = data.panelId;

        if (!this._getBackgroundImageValue() && panelId === _constants.FLOATING_TOOLBAR_BUTTONS.fragmentBackgroundImage.panelId) {
          (0, _FragmentsEditorDialogUtils.openImageSelector)({
            callback: function callback(image) {
              return _this2._updateFragmentBackgroundImage(image);
            },
            imageSelectorURL: this.imageSelectorURL,
            portletNamespace: this.portletNamespace
          });
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_renderBackgroundImage",
      value: function _renderBackgroundImage() {
        var backgroundImageValue = (0, _FragmentsEditorGetUtils.editableIsMapped)(this.editableValues) ? this._mappedFieldValue : this._getBackgroundImageValue();

        _EditableBackgroundImageProcessor["default"].render(this.element, backgroundImageValue);
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_setEditableAttributes",
      value: function _setEditableAttributes() {
        this.element.setAttribute('data-fragments-editor-item-id', this._getItemId());
        this.element.setAttribute('data-fragments-editor-item-type', _constants.FRAGMENTS_EDITOR_ITEM_TYPES.backgroundImageEditable);
        this.element.setAttribute('data-fragment-entry-link-id', this.fragmentEntryLinkId);
      }
      /**
       * Add highlighted class to the editable if necessary
       * @private
       * @review
       */

    }, {
      key: "_setHighlightedState",
      value: function _setHighlightedState() {
        if ((0, _FragmentsEditorGetUtils.editableShouldBeHighlighted)(this.activeItemId, this.activeItemType, this.fragmentEntryLinkId, this.layoutData.structure)) {
          this.element.classList.add('fragments-editor__background-image-editable--highlighted');
        } else {
          this.element.classList.remove('fragments-editor__background-image-editable--highlighted');
        }
      }
      /**
       * Dispatches action to update editableValues with new background image url
       * @param {string} backgroundImageURL
       */

    }, {
      key: "_updateFragmentBackgroundImage",
      value: function _updateFragmentBackgroundImage(image) {
        this.store.dispatch((0, _updateEditableValue.updateEditableValueContentAction)(this.fragmentEntryLinkId, _constants.BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR, this.editableId, image));
      }
      /**
       * Updates mapped field value
       * @private
       * @review
       */

    }, {
      key: "_updateMappedFieldValue",
      value: function _updateMappedFieldValue() {
        var _this3 = this;

        if (this.getAssetFieldValueURL && (0, _FragmentsEditorGetUtils.editableIsMappedToAssetEntry)(this.editableValues)) {
          (0, _FragmentsEditorFetchUtils.getAssetFieldValue)(this.editableValues.classNameId, this.editableValues.classPK, this.editableValues.fieldId).then(function (response) {
            var fieldValue = response.fieldValue;

            if (fieldValue) {
              _this3._mappedFieldValue = fieldValue.url;

              _this3._renderBackgroundImage();
            }
          });
        }
      }
    }]);

    return FragmentEditableBackgroundImage;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  exports.FragmentEditableBackgroundImage = FragmentEditableBackgroundImage;
  FragmentEditableBackgroundImage.STATE = {
    /**
     * Wether the editable is active
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @private
     * @review
     * @type {string}
     */
    _active: _metalState.Config.internal().bool().value(false),

    /**
     * Mapped asset field value
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @private
     * @review
     * @type {string}
     */
    _mappedFieldValue: _metalState.Config.internal().string(),

    /**
     * Editable ID
     * @default undefined
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @review
     * @type {!string}
     */
    editableId: _metalState.Config.string().required(),

    /**
     * Editable values that should be used instead of the default ones inside
     * editable fields.
     * @default undefined
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @type {!Object}
     */
    editableValues: _metalState.Config.object().required(),

    /**
     * FragmentEntryLink id
     * @default undefined
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @review
     * @type {!string}
     */
    fragmentEntryLinkId: _metalState.Config.string().required(),

    /**
     * @default undefined
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @review
     * @type {!string}
     */
    processor: _metalState.Config.string().required(),

    /**
     * If <code>true</code>, the mapping is activated.
     * @default undefined
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @type {!boolean}
     */
    showMapping: _metalState.Config.bool().required(),

    /**
     * Store instance.
     * @default undefined
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @type {Store}
     */
    store: _metalState.Config.instanceOf(_store.Store)
  };
  var ConnectedFragmentEditableBackgroundImage = (0, _ConnectedComponent["default"])(FragmentEditableBackgroundImage, ['activeItemId', 'activeItemType', 'hoveredItemId', 'hoveredItemType', 'defaultLanguageId', 'defaultSegmentsExperienceId', 'getAssetFieldValueURL', 'imageSelectorURL', 'languageId', 'layoutData', 'mappingFieldsURL', 'portletNamespace', 'segmentsExperienceId', 'selectedMappingTypes']);
  exports.ConnectedFragmentEditableBackgroundImage = ConnectedFragmentEditableBackgroundImage;
  var _default = ConnectedFragmentEditableBackgroundImage;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentEditableBackgroundImage.es.js.map
});
//# sourceMappingURL=FragmentEditableBackgroundImage.es.js.map