Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/components/floating_toolbar/layout_background_image/FloatingToolbarLayoutBackgroundImagePanel.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './FloatingToolbarLayoutBackgroundImagePanelDelegateTemplate.soy', '../../../actions/actions.es', '../../../actions/updateRowConfig.es', '../../../store/ConnectedComponent.es', '../../../utils/FragmentsEditorDialogUtils', '../../../utils/FragmentsEditorFetchUtils.es', '../../../utils/FragmentsEditorGetUtils.es', '../../../utils/FragmentsEditorIdUtils.es', '../../../utils/FragmentsEditorUpdateUtils.es', '../../../utils/constants', './FloatingToolbarLayoutBackgroundImagePanel.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FloatingToolbarLayoutBackgroundImagePanel = exports.ConnectedFloatingToolbarLayoutBackgroundImagePanel = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  require("./FloatingToolbarLayoutBackgroundImagePanelDelegateTemplate.soy");

  var _actions = require("../../../actions/actions.es");

  var _updateRowConfig = require("../../../actions/updateRowConfig.es");

  var _ConnectedComponent = require("../../../store/ConnectedComponent.es");

  var _FragmentsEditorDialogUtils = require("../../../utils/FragmentsEditorDialogUtils");

  var _FragmentsEditorFetchUtils = require("../../../utils/FragmentsEditorFetchUtils.es");

  var _FragmentsEditorGetUtils = require("../../../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorIdUtils = require("../../../utils/FragmentsEditorIdUtils.es");

  var _FragmentsEditorUpdateUtils = require("../../../utils/FragmentsEditorUpdateUtils.es");

  var _constants = require("../../../utils/constants");

  var _FloatingToolbarLayoutBackgroundImagePanel = _interopRequireDefault(require("./FloatingToolbarLayoutBackgroundImagePanel.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var IMAGE_SOURCE_TYPE_IDS = {
    content: 'content_mapping',
    selection: 'manual_selection'
  };
  /**
   * FloatingToolbarLayoutBackgroundImagePanel
   */

  var FloatingToolbarLayoutBackgroundImagePanel =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FloatingToolbarLayoutBackgroundImagePanel, _Component);

    function FloatingToolbarLayoutBackgroundImagePanel() {
      _classCallCheck(this, FloatingToolbarLayoutBackgroundImagePanel);

      return _possibleConstructorReturn(this, _getPrototypeOf(FloatingToolbarLayoutBackgroundImagePanel).apply(this, arguments));
    }

    _createClass(FloatingToolbarLayoutBackgroundImagePanel, [{
      key: "prepareStateForRender",

      /**
       * @inheritdoc
       * @param {object} state
       * @return {object}
       * @review
       */
      value: function prepareStateForRender(state) {
        var nextState = state;
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_backgroundImage'], this._getBackgroundImage());
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_imageSourceTypeIds'], IMAGE_SOURCE_TYPE_IDS);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_imageSourceTypes'], FloatingToolbarLayoutBackgroundImagePanel.getImageSourceTypes());
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['mappedAssetEntries'], nextState.mappedAssetEntries.map(_FragmentsEditorIdUtils.encodeAssetId));
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_mappingSourceTypeIds'], _constants.MAPPING_SOURCE_TYPE_IDS);

        if (nextState.mappingFieldsURL && nextState.selectedMappingTypes && nextState.selectedMappingTypes.type) {
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_mappingSourceTypes'], (0, _FragmentsEditorGetUtils.getMappingSourceTypes)(nextState.selectedMappingTypes.subtype ? nextState.selectedMappingTypes.subtype.label : nextState.selectedMappingTypes.type.label));
        }

        if (nextState.mappedAssetEntries && nextState._selectedAssetEntry && nextState._selectedAssetEntry.classNameId && nextState._selectedAssetEntry.classPK) {
          var mappedAssetEntry = nextState.mappedAssetEntries.find(function (assetEntry) {
            return nextState._selectedAssetEntry.classNameId === assetEntry.classNameId && nextState._selectedAssetEntry.classPK === assetEntry.classPK;
          });

          if (mappedAssetEntry) {
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['item', 'config', 'title'], mappedAssetEntry.title);
          }
        }

        return nextState;
      }
      /**
       * @inheritdoc
       * @param {boolean} firstRender
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered(firstRender) {
        if (firstRender) {
          if (this.item.config.backgroundImage) {
            var backgroundImage = this.item.config.backgroundImage;
            this._selectedAssetEntry.classNameId = this.item.config.backgroundImage.classNameId;
            this._selectedAssetEntry.classPK = this.item.config.backgroundImage.classPK;
            this._selectedImageSourceTypeId = backgroundImage.classNameId || backgroundImage.mappedField ? IMAGE_SOURCE_TYPE_IDS.content : IMAGE_SOURCE_TYPE_IDS.selection;
            this._selectedMappingSourceTypeId = backgroundImage.mappedField ? _constants.MAPPING_SOURCE_TYPE_IDS.structure : _constants.MAPPING_SOURCE_TYPE_IDS.content;
          } else {
            this._selectedImageSourceTypeId = IMAGE_SOURCE_TYPE_IDS.selection;
            this._selectedMappingSourceTypeId = _constants.MAPPING_SOURCE_TYPE_IDS.content;
          }
        }
      }
      /**
       * @param {{config: object}} newItem
       * @param {{config: object}} [oldItem]
       * @inheritdoc
       * @review
       */

    }, {
      key: "syncItem",
      value: function syncItem(newItem, oldItem) {
        var changedBackgroundImage = newItem.config && oldItem && oldItem.config && newItem.config.backgroundImage && !oldItem.config.backgroundImage;
        var changedMappedAsset = newItem.config && newItem.config.backgroundImage && oldItem && oldItem.config && oldItem.config.backgroundImage && newItem.config.backgroundImage.classNameId !== oldItem.config.backgroundImage.classNameId;

        if (!oldItem || changedBackgroundImage || changedMappedAsset) {
          this._loadFields();
        }
      }
      /**
       * Clears fields
       * @private
       * @review
       */

    }, {
      key: "_clearFields",
      value: function _clearFields() {
        this._fields = [];
      }
      /**
       * Clears mapping values
       * @private
       * @review
       */

    }, {
      key: "_clearMappingValues",
      value: function _clearMappingValues() {
        this.store.dispatch((0, _updateRowConfig.updateRowConfigAction)(this.itemId, {
          backgroundImage: ''
        }));
      }
      /**
       * Takes the string of the background image
       * @private
       */

    }, {
      key: "_getBackgroundImage",
      value: function _getBackgroundImage() {
        var config = this.item.config;

        if (!config) {
          return '';
        }

        if (typeof config.backgroundImage === 'string') {
          return config.backgroundImage;
        }

        if (_typeof(config.backgroundImage) === 'object') {
          return config.backgroundImage.title || '';
        }

        return '';
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleAssetBrowserLinkClick",
      value: function _handleAssetBrowserLinkClick(event) {
        var _this = this;

        var _event$delegateTarget = event.delegateTarget.dataset,
            assetBrowserUrl = _event$delegateTarget.assetBrowserUrl,
            assetBrowserWindowTitle = _event$delegateTarget.assetBrowserWindowTitle;
        (0, _FragmentsEditorDialogUtils.openAssetBrowser)({
          assetBrowserURL: assetBrowserUrl,
          callback: function callback(selectedAssetEntry) {
            _this._selectAssetEntry(selectedAssetEntry);
          },
          eventName: "".concat(this.portletNamespace, "selectAsset"),
          modalTitle: assetBrowserWindowTitle
        });
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleAssetEntryLinkClick",
      value: function _handleAssetEntryLinkClick(event) {
        var data = event.delegateTarget.dataset;

        this._selectAssetEntry({
          classNameId: data.classNameId,
          classPK: data.classPk
        });
      }
      /**
       * Handle field option change
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleFieldOptionChange",
      value: function _handleFieldOptionChange(event) {
        var fieldId = event.delegateTarget.value;

        this._selectField(fieldId);
      }
      /**
       * Show image selector
       * @private
       * @review
       */

    }, {
      key: "_handleSelectButtonClick",
      value: function _handleSelectButtonClick() {
        var _this2 = this;

        (0, _FragmentsEditorDialogUtils.openImageSelector)({
          callback: function callback(image) {
            return _this2._updateRowBackgroundImage(image);
          },
          imageSelectorURL: this.imageSelectorURL,
          portletNamespace: this.portletNamespace
        });
      }
      /**
       * Remove existing image if any
       * @private
       * @review
       */

    }, {
      key: "_handleClearButtonClick",
      value: function _handleClearButtonClick() {
        this._updateRowBackgroundImage({});
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleImageSourceTypeSelect",
      value: function _handleImageSourceTypeSelect(event) {
        this._selectedImageSourceTypeId = event.delegateTarget.value;

        if (FloatingToolbarLayoutBackgroundImagePanel.emptyMappingValues(this.item.config)) {
          this._loadFields();
        } else {
          this._clearMappingValues();
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleMappingSourceTypeSelect",
      value: function _handleMappingSourceTypeSelect(event) {
        this._selectedMappingSourceTypeId = event.delegateTarget.value;

        if (FloatingToolbarLayoutBackgroundImagePanel.emptyMappingValues(this.item.config)) {
          this._loadFields();
        } else {
          this._clearMappingValues();
        }
      }
      /**
       * Load the list of fields
       * @private
       * @review
       */

    }, {
      key: "_loadFields",
      value: function _loadFields() {
        var _this3 = this;

        var promise;

        this._clearFields();

        if (this._selectedMappingSourceTypeId === _constants.MAPPING_SOURCE_TYPE_IDS.structure) {
          promise = (0, _FragmentsEditorFetchUtils.getStructureMappingFields)(this.selectedMappingTypes.type.id, this.selectedMappingTypes.subtype.id);
        } else if (this._selectedMappingSourceTypeId === _constants.MAPPING_SOURCE_TYPE_IDS.content && this._selectedAssetEntry.classNameId && this._selectedAssetEntry.classPK) {
          promise = (0, _FragmentsEditorFetchUtils.getAssetMappingFields)(this._selectedAssetEntry.classNameId, this._selectedAssetEntry.classPK);
        }

        if (promise) {
          promise.then(function (response) {
            _this3._fields = response.filter(function (field) {
              return _constants.COMPATIBLE_TYPES['image'].indexOf(field.type) !== -1;
            });
          });
        } else if (this._fields.length) {
          this._clearFields();
        }
      }
      /**
       * @param {object} assetEntry
       * @param {string} assetEntry.classNameId
       * @param {string} assetEntry.classPK
       * @private
       * @review
       */

    }, {
      key: "_selectAssetEntry",
      value: function _selectAssetEntry(assetEntry) {
        this._selectedAssetEntry = assetEntry;
        this.store.dispatch(_objectSpread({}, this._selectedAssetEntry, {
          type: _actions.ADD_MAPPED_ASSET_ENTRY
        }));

        this._loadFields();
      }
      /**
       * @param {string} fieldId
       * @private
       * @review
       */

    }, {
      key: "_selectField",
      value: function _selectField(fieldId) {
        var fieldData = this._selectedMappingSourceTypeId === _constants.MAPPING_SOURCE_TYPE_IDS.content ? {
          classNameId: this._selectedAssetEntry.classNameId,
          classPK: this._selectedAssetEntry.classPK,
          fieldId: fieldId
        } : {
          mappedField: fieldId
        };

        if (fieldId === '') {
          fieldData = {
            classNameId: '',
            classPK: '',
            fieldId: '',
            mappedField: ''
          };
        }

        this.store.dispatch((0, _updateRowConfig.updateRowConfigAction)(this.itemId, {
          backgroundImage: _objectSpread({}, fieldData)
        }));
      }
      /**
       * Updates row image
       * @param {object} backgroundImage Row image
       * @private
       * @review
       */

    }, {
      key: "_updateRowBackgroundImage",
      value: function _updateRowBackgroundImage(backgroundImage) {
        this.store.dispatch((0, _updateRowConfig.updateRowConfigAction)(this.itemId, {
          backgroundImage: backgroundImage
        }));
      }
    }], [{
      key: "emptyMappingValues",

      /**
       * @return {boolean} Mapping values are empty
       * @private
       * @static
       * @review
       */
      value: function emptyMappingValues(config) {
        if (config.backgroundImage) {
          return !config.backgroundImage.classNameId && !config.backgroundImage.classPK && !config.backgroundImage.fieldId && !config.backgroundImage.mappedField;
        }

        return true;
      }
      /**
       * @return {Array<{id: string, label: string}>} Image source types
       * @private
       * @static
       * @review
       */

    }, {
      key: "getImageSourceTypes",
      value: function getImageSourceTypes() {
        return [{
          id: IMAGE_SOURCE_TYPE_IDS.selection,
          label: Liferay.Language.get('manual-selection')
        }, {
          id: IMAGE_SOURCE_TYPE_IDS.content,
          label: Liferay.Language.get('content-mapping')
        }];
      }
    }]);

    return FloatingToolbarLayoutBackgroundImagePanel;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FloatingToolbarLayoutBackgroundImagePanel = FloatingToolbarLayoutBackgroundImagePanel;
  FloatingToolbarLayoutBackgroundImagePanel.STATE = {
    /**
     * @default []
     * @memberOf FloatingToolbarLayoutBackgroundImagePanel
     * @private
     * @review
     * @type {object[]}
     */
    _fields: _metalState.Config.array().internal().value([]),

    /**
     * @default undefined
     * @memberof FloatingToolbarLayoutBackgroundImagePanel
     * @review
     * @type {string}
     */
    _selectedAssetEntry: _metalState.Config.object().internal().value({}),

    /**
     * @default undefined
     * @memberof FloatingToolbarLayoutBackgroundImagePanel
     * @review
     * @type {string}
     */
    _selectedImageSourceTypeId: _metalState.Config.oneOf(Object.values(IMAGE_SOURCE_TYPE_IDS)).internal(),

    /**
     * @default undefined
     * @memberof FloatingToolbarLayoutBackgroundImagePanel
     * @review
     * @type {string}
     */
    _selectedMappingSourceTypeId: _metalState.Config.oneOf(Object.values(_constants.MAPPING_SOURCE_TYPE_IDS)).internal(),

    /**
     * @default undefined
     * @memberof FloatingToolbarLayoutBackgroundImagePanel
     * @review
     * @type {object}
     */
    item: _metalState.Config.required(),

    /**
     * @default undefined
     * @memberof FloatingToolbarLayoutBackgroundImagePanel
     * @review
     * @type {!string}
     */
    itemId: _metalState.Config.string().required()
  };
  var ConnectedFloatingToolbarLayoutBackgroundImagePanel = (0, _ConnectedComponent.getConnectedComponent)(FloatingToolbarLayoutBackgroundImagePanel, ['assetBrowserLinks', 'imageSelectorURL', 'mappedAssetEntries', 'mappingFieldsURL', 'portletNamespace', 'selectedMappingTypes']);
  exports.ConnectedFloatingToolbarLayoutBackgroundImagePanel = ConnectedFloatingToolbarLayoutBackgroundImagePanel;

  _metalSoy["default"].register(ConnectedFloatingToolbarLayoutBackgroundImagePanel, _FloatingToolbarLayoutBackgroundImagePanel["default"]);

  var _default = ConnectedFloatingToolbarLayoutBackgroundImagePanel;
  exports["default"] = _default;
  //# sourceMappingURL=FloatingToolbarLayoutBackgroundImagePanel.es.js.map
});
//# sourceMappingURL=FloatingToolbarLayoutBackgroundImagePanel.es.js.map