Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/components/edit_mode/EditModeWrapper.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-state', '../../actions/actions.es', '../../actions/updateActiveItem.es', '../../store/ConnectedComponent.es', '../../utils/constants'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.HIGHLIGHTED_COMMENT_ID_KEY = exports.EditModeWrapper = exports.ConnectedEditModeWrapper = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _actions = require("../../actions/actions.es");

  var _updateActiveItem = require("../../actions/updateActiveItem.es");

  var _ConnectedComponent = _interopRequireDefault(require("../../store/ConnectedComponent.es"));

  var _constants = require("../../utils/constants");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var WRAPPER_CLASSES = {
    "default": 'fragment-entry-link-list-wrapper',
    padded: 'fragment-entry-link-list-wrapper--padded'
  };
  var HIGHLIGHTED_COMMENT_ID_KEY = 'FRAGMENTS_EDITOR_HIGHLIGHTED_COMMENT_ID';
  /**
   * EditModeWrapper
   * @review
   */

  exports.HIGHLIGHTED_COMMENT_ID_KEY = HIGHLIGHTED_COMMENT_ID_KEY;

  var EditModeWrapper =
  /*#__PURE__*/
  function (_Component) {
    _inherits(EditModeWrapper, _Component);

    function EditModeWrapper() {
      _classCallCheck(this, EditModeWrapper);

      return _possibleConstructorReturn(this, _getPrototypeOf(EditModeWrapper).apply(this, arguments));
    }

    _createClass(EditModeWrapper, [{
      key: "created",

      /**
       * @inheritdoc
       * @review
       */
      value: function created() {
        var _this = this;

        this._url = new URL(location.href);
        requestAnimationFrame(function () {
          _this._handleMessageIdURLParameter();

          _this._handleActiveItemURLParameter();

          _this._handleSidebarPanelIdURLParameter();

          _this._syncURL();

          _this.on('activeItemIdChanged', _this._syncValueToURL('activeItemId'));

          _this.on('activeItemTypeChanged', _this._syncValueToURL('activeItemType'));

          _this.on('selectedSidebarPanelIdChanged', _this._syncValueToURL('sidebarPanelId'));
        });
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "syncSelectedSidebarPanelId",
      value: function syncSelectedSidebarPanelId() {
        this._toggleWrapperPadding();
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "syncSidebarPanels",
      value: function syncSidebarPanels() {
        this._toggleWrapperPadding();
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleActiveItemURLParameter",
      value: function _handleActiveItemURLParameter() {
        var activeItemId = this._url.searchParams.get('activeItemId');

        var activeItemType = this._url.searchParams.get('activeItemType');

        if (activeItemId && activeItemType) {
          this.store.dispatch((0, _updateActiveItem.updateActiveItemAction)(activeItemId, activeItemType));
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleMessageIdURLParameter",
      value: function _handleMessageIdURLParameter() {
        var messageId = this._url.searchParams.get('messageId');

        if (this.fragmentEntryLinks && messageId) {
          var matchComment = function matchComment(comment) {
            return comment.commentId === messageId;
          };

          var fragmentEntryLink = Object.values(this.fragmentEntryLinks).find(function (fragmentEntryLink) {
            return fragmentEntryLink.comments.find(function (comment) {
              return matchComment(comment) || comment.children.find(matchComment);
            });
          });

          if (fragmentEntryLink) {
            this._url.searchParams["delete"]('messageId');

            this._url.searchParams.set('sidebarPanelId', 'comments');

            this._url.searchParams.set('activeItemId', fragmentEntryLink.fragmentEntryLinkId);

            this._url.searchParams.set('activeItemType', _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment);

            window.sessionStorage.setItem(HIGHLIGHTED_COMMENT_ID_KEY, messageId);
          }
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleSidebarPanelIdURLParameter",
      value: function _handleSidebarPanelIdURLParameter() {
        var sidebarPanelId = this._url.searchParams.get('sidebarPanelId');

        var sidebarPanel = this.sidebarPanels.find(function (panel) {
          return panel.sidebarPanelId === sidebarPanelId;
        });

        if (sidebarPanelId !== null && sidebarPanel) {
          this.store.dispatch({
            type: _actions.UPDATE_SELECTED_SIDEBAR_PANEL_ID,
            value: sidebarPanel.sidebarPanelId
          });
        }
      }
      /**
       * Syncs internal URL to window state
       * @private
       * @review
       */

    }, {
      key: "_syncURL",
      value: function _syncURL() {
        var skipLoadPopstate;

        if (Liferay.SPA && Liferay.SPA.app) {
          skipLoadPopstate = Liferay.SPA.app.skipLoadPopstate;
          Liferay.SPA.app.skipLoadPopstate = true;
        }

        history.replaceState(null, document.head.title, this._url.href);
        requestAnimationFrame(function () {
          if (Liferay.SPA && Liferay.SPA.app && typeof skipLoadPopstate === 'boolean') {
            Liferay.SPA.app.skipLoadPopstate = skipLoadPopstate;
          }
        });
      }
      /**
       * @param {string} key
       * @private
       * @review
       */

    }, {
      key: "_syncValueToURL",
      value: function _syncValueToURL(key) {
        var _this2 = this;

        /**
         * @param {{ newVal: any }} change
         */
        return function (change) {
          if (change.newVal !== null) {
            _this2._url.searchParams.set(key, change.newVal);
          } else {
            _this2._url.searchParams["delete"](key);
          }

          _this2._syncURL();
        };
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_toggleWrapperPadding",
      value: function _toggleWrapperPadding() {
        var _this3 = this;

        var sidebarPanel = this.sidebarPanels.find(function (panel) {
          return panel.sidebarPanelId === _this3.selectedSidebarPanelId;
        });
        var wrapper = document.getElementById('wrapper');

        if (wrapper) {
          wrapper.classList.add(WRAPPER_CLASSES["default"]);

          if (sidebarPanel) {
            wrapper.classList.add(WRAPPER_CLASSES.padded);
          } else {
            wrapper.classList.remove(WRAPPER_CLASSES.padded);
          }
        }
      }
    }]);

    return EditModeWrapper;
  }(_metalComponent["default"]);

  exports.EditModeWrapper = EditModeWrapper;
  EditModeWrapper.STATE = {
    /**
     * Internal URL object
     * @default new URL
     * @memberof EditModeWrapper
     * @review
     * @type {URL}
     */
    _url: _metalState.Config.instanceOf(URL).internal()
  };
  var ConnectedEditModeWrapper = (0, _ConnectedComponent["default"])(EditModeWrapper, ['activeItemId', 'activeItemType', 'fragmentEntryLinks', 'selectedSidebarPanelId', 'sidebarPanels']);
  exports.ConnectedEditModeWrapper = ConnectedEditModeWrapper;
  var _default = ConnectedEditModeWrapper;
  exports["default"] = _default;
  //# sourceMappingURL=EditModeWrapper.es.js.map
});
//# sourceMappingURL=EditModeWrapper.es.js.map