Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/components/edit_mode/DisabledAreaPopover.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './DisabledAreaPopover.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.DisabledAreaPopover = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _metalPosition = require("frontend-js-metal-web$metal-position");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _DisabledAreaPopover = _interopRequireDefault(require("./DisabledAreaPopover.soy"));

  var _POPOVER_POSITIONS;

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * Mapping from metal-position to popover positions
   * @review
   * @type {!object}
   */
  var POPOVER_POSITIONS = (_POPOVER_POSITIONS = {}, _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.Bottom, 'bottom'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.BottomLeft, 'bottom'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.BottomRight, 'bottom'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.Left, 'left'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.Right, 'right'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.Top, 'top'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.TopLeft, 'top'), _defineProperty(_POPOVER_POSITIONS, _metalPosition.Align.TopRight, 'top'), _POPOVER_POSITIONS);
  /**
   * DisabledAreaPopover
   * @review
   */

  var DisabledAreaPopover =
  /*#__PURE__*/
  function (_Component) {
    _inherits(DisabledAreaPopover, _Component);

    function DisabledAreaPopover() {
      _classCallCheck(this, DisabledAreaPopover);

      return _possibleConstructorReturn(this, _getPrototypeOf(DisabledAreaPopover).apply(this, arguments));
    }

    _createClass(DisabledAreaPopover, [{
      key: "created",

      /**
       * @inheritDoc
       * @review
       */
      value: function created() {
        this._attachListener();

        this._documentListeners = [(0, _metalDom.on)(document.body, 'click', this._handleDocumentClick.bind(this)), (0, _metalDom.on)('.fragment-entry-link-list-wrapper', 'scroll', this._handleFragmentEntryLinkListScroll.bind(this))];
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._detachListener();

        this._documentListeners.forEach(function (documentListener) {
          return documentListener.removeListener();
        });
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered() {
        var _this = this;

        if (this._position) {
          requestAnimationFrame(function () {
            var popoverPosition = _metalPosition.Align.TopCenter;

            var suggestedAlign = _metalPosition.Align.suggestAlignBestRegion(_this.refs.popover, _this._clickedElement, popoverPosition);

            if (suggestedAlign.position !== popoverPosition) {
              popoverPosition = _metalPosition.Align.BottomCenter;
            }

            _metalPosition.Align.align(_this.refs.popover, _this._clickedElement, popoverPosition, false);

            _this._setPosition(popoverPosition);
          });
        }
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncSelector",
      value: function syncSelector() {
        this._detachListener();

        this._attachListener();
      }
      /**
       * Attachs a click listener for elements defined in selector
       * property and calls _detachListener for old selectors if necessary.
       * @private
       * @review
       */

    }, {
      key: "_attachListener",
      value: function _attachListener() {
        if (this._elementListener) {
          this._detachListener();
        }

        if (this.selector) {
          this._elementListener = (0, _metalDom.delegate)(document.body, 'click', this.selector, this._handleElementClick.bind(this));
        }
      }
      /**
       * Dettachs a click listener (if any).
       * @private
       * @review
       */

    }, {
      key: "_detachListener",
      value: function _detachListener() {
        if (this._elementListener) {
          this._elementListener.removeListener();

          this._elementListener = null;
        }
      }
      /**
       * Handles a click over DOM (but not over a defined element)
       * updating the _clickedElement property and setting visibility to false.
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDocumentClick",
      value: function _handleDocumentClick() {
        this._hidePopover();
      }
      /**
       * Handles a click over any element defined in selector property by
       * updating the _clickedElement property and setting visibility to true.
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleElementClick",
      value: function _handleElementClick(event) {
        event.stopImmediatePropagation();
        this._clickedElement = event.delegateTarget;

        this._setPosition(_metalPosition.Align.TopCenter);
      }
      /**
       * Handles a click over DOM (but not over a defined element)
       * updating the _clickedElement property and setting visibility to false.
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleFragmentEntryLinkListScroll",
      value: function _handleFragmentEntryLinkListScroll() {
        this._hidePopover();
      }
      /**
       * Hides the popover
       * @private
       * @review
       */

    }, {
      key: "_hidePopover",
      value: function _hidePopover() {
        this._clickedElement = null;
        this._position = null;
      }
      /**
       * Sets the popover position from the position given by metal-position
       * align method.
       * @param {number} alignPosition
       * @private
       * @review
       */

    }, {
      key: "_setPosition",
      value: function _setPosition(alignPosition) {
        if (this._position !== POPOVER_POSITIONS[alignPosition]) {
          this._position = POPOVER_POSITIONS[alignPosition];
        }
      }
    }]);

    return DisabledAreaPopover;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.DisabledAreaPopover = DisabledAreaPopover;
  DisabledAreaPopover.STATE = {
    /**
     * Clicked element
     * @default null
     * @instance
     * @memberOf DisabledAreaPopover
     * @private
     * @review
     * @type {!object}
     */
    _clickedElement: _metalState.Config.object().value(null),

    /**
     * Listeners attached to document
     * @default []
     * @instance
     * @memberOf DisabledAreaPopover
     * @private
     * @review
     * @type {!Array<object>}
     */
    _documentListeners: _metalState.Config.arrayOf(_metalState.Config.object()).value([]),

    /**
     * Click listener attached to DOM
     * @default null
     * @instance
     * @memberOf DisabledAreaPopover
     * @private
     * @review
     * @type {!object}
     */
    _elementListener: _metalState.Config.object().value(null),

    /**
     * Popover position
     * @default null
     * @instance
     * @memberOf DisabledAreaPopover
     * @private
     * @review
     * @type {!string}
     */
    _position: _metalState.Config.string().value(null),

    /**
     * Selector for elements where this popover should be shown
     * @default undefined
     * @instance
     * @memberOf DisabledAreaPopover
     * @review
     * @type {!string}
     */
    selector: _metalState.Config.string().required()
  };

  _metalSoy["default"].register(DisabledAreaPopover, _DisabledAreaPopover["default"]);

  var _default = DisabledAreaPopover;
  exports["default"] = _default;
  //# sourceMappingURL=DisabledAreaPopover.es.js.map
});
//# sourceMappingURL=DisabledAreaPopover.es.js.map