Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/components/common/InlineConfirm.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './Button.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.InlineConfirm = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _Button = _interopRequireDefault(require("./Button.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var CONFIRM_BUTTON_CLASS = 'fragments-editor__inline-confirm-button';

  var InlineConfirm = function InlineConfirm(props) {
    var onCancelButtonClick = props.onCancelButtonClick,
        onConfirmButtonClick = props.onConfirmButtonClick;

    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        performingAction = _useState2[0],
        setPerformingAction = _useState2[1];

    var wrapper = (0, _react.useRef)(null);
    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

    (0, _react.useEffect)(function () {
      if (wrapper.current) {
        var confirmButton = wrapper.current.querySelector(".".concat(CONFIRM_BUTTON_CLASS));

        if (confirmButton) {
          confirmButton.focus();
        }
      }

      var _handleDocumentFocusOut = function _handleDocumentFocusOut() {
        requestAnimationFrame(function () {
          if (wrapper.current && !performingAction) {
            if (!wrapper.current.contains(document.activeElement) && wrapper.current !== document.activeElement) {
              onCancelButtonClick();
            }
          }
        });
      };

      document.addEventListener('focusout', _handleDocumentFocusOut, true);
      return function () {
        return window.removeEventListener('focusout', _handleDocumentFocusOut, true);
      };
    }, [performingAction, onCancelButtonClick]);
    return _react["default"].createElement("div", {
      className: "fragments-editor__inline-confirm",
      onKeyDown: function onKeyDown(e) {
        return e.key === 'Escape' && onCancelButtonClick();
      },
      ref: wrapper,
      role: "alertdialog",
      tabIndex: "-1"
    }, _react["default"].createElement("p", {
      className: "text-center text-secondary"
    }, _react["default"].createElement("strong", null, props.message)), _react["default"].createElement(_button["default"].Group, {
      spaced: true
    }, _react["default"].createElement(_Button["default"], {
      className: CONFIRM_BUTTON_CLASS,
      disabled: performingAction,
      displayType: "primary",
      loading: performingAction,
      onClick: function _handleConfirmButtonClick() {
        if (wrapper.current) {
          wrapper.current.focus();
        }

        setPerformingAction(true);
        onConfirmButtonClick().then(function () {
          if (isMounted()) {
            setPerformingAction(false);
          }
        });
      },
      small: true
    }, props.confirmButtonLabel), _react["default"].createElement(_Button["default"], {
      disabled: performingAction,
      displayType: "secondary",
      onClick: onCancelButtonClick,
      small: true,
      type: "button"
    }, props.cancelButtonLabel)));
  };

  exports.InlineConfirm = InlineConfirm;
  InlineConfirm.propTypes = {
    cancelButtonLabel: _propTypes["default"].string,
    confirmButtonLabel: _propTypes["default"].string,
    message: _propTypes["default"].string,
    onCancelButtonClick: _propTypes["default"].func,
    onConfirmButtonClick: _propTypes["default"].func
  };
  var _default = InlineConfirm;
  exports["default"] = _default;
  //# sourceMappingURL=InlineConfirm.es.js.map
});
//# sourceMappingURL=InlineConfirm.es.js.map