Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/actions/updateRowColumns.es", ['module', 'exports', 'require', '../utils/FragmentsEditorFetchUtils.es', '../utils/FragmentsEditorGetUtils.es', '../utils/FragmentsEditorUpdateUtils.es', './actions.es', './saveChanges.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.updateRowColumnsAction = updateRowColumnsAction;

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  var _FragmentsEditorGetUtils = require("../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  var _actions = require("./actions.es");

  var _saveChanges = require("./saveChanges.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * @param {Array} columns
   * @param {string} rowId
   * @return {function}
   * @review
   */
  function updateRowColumnsAction(columns, rowId) {
    return function (dispatch, getState) {
      var state = getState();
      var rowIndex = (0, _FragmentsEditorGetUtils.getRowIndex)(state.layoutData.structure, rowId);
      var previousData = state.layoutData;
      var nextData = previousData;

      if (rowIndex !== -1) {
        nextData = (0, _FragmentsEditorUpdateUtils.setIn)(previousData, ['structure', rowIndex.toString(), 'columns'], columns);
      }

      dispatch(updateRowColumnsLoadingAction(nextData));
      dispatch((0, _saveChanges.enableSavingChangesStatusAction)());
      (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextData, state.segmentsExperienceId).then(function () {
        dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
        dispatch((0, _saveChanges.updateLastSaveDateAction)());
      })["catch"](function () {
        dispatch(updateRowColumnsErrorAction(previousData));
        dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
      });
    };
  }
  /**
   * @param {Array} layoutData
   * @return {object}
   * @review
   */

  function updateRowColumnsErrorAction(layoutData) {
    return {
      type: _actions.UPDATE_ROW_COLUMNS_ERROR,
      value: layoutData
    };
  }
  /**
   * @param {Array} layoutData
   * @return {object}
   * @review
   */

  function updateRowColumnsLoadingAction(layoutData) {
    return {
      type: _actions.UPDATE_ROW_COLUMNS_LOADING,
      value: layoutData
    };
  }
  //# sourceMappingURL=updateRowColumns.es.js.map
});
//# sourceMappingURL=updateRowColumns.es.js.map