Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/actions/updateEditableValue.es", ['module', 'exports', 'require', '../reducers/fragments.es', '../utils/FragmentsEditorFetchUtils.es', '../utils/FragmentsEditorUpdateUtils.es', '../utils/constants', '../utils/prefixSegmentsExperienceId.es', './actions.es', './saveChanges.es', './updatePageContents.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.updateFragmentEntryLinkContent = updateFragmentEntryLinkContent;
  exports.updateFragmentConfigurationAction = exports.updateEditableValueFieldIdAction = exports.updateEditableValueMappedFieldAction = exports.updateEditableValueContentAction = void 0;

  var _fragments = require("../reducers/fragments.es");

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  var _constants = require("../utils/constants");

  var _prefixSegmentsExperienceId = require("../utils/prefixSegmentsExperienceId.es");

  var _actions = require("./actions.es");

  var _saveChanges = require("./saveChanges.es");

  var _updatePageContents = require("./updatePageContents.es");

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  /**
   * Sets the editable value content.
   * @param {string} fragmentEntryLinkId
   * @param {EDITABLE_FRAGMENT_ENTRY_PROCESSOR|BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR} processor
   * @param {string} editableId
   * @param {string} content
   */
  var updateEditableValueContentAction = function updateEditableValueContentAction(fragmentEntryLinkId, processor, editableId, content) {
    return function (dispatch, getState) {
      return _sendEditableValues(fragmentEntryLinkId, [].concat(_toConsumableArray(['classNameId', 'classPK', 'fieldId', 'mappedField'].map(function (field) {
        return {
          path: [processor, editableId, field]
        };
      })), [{
        content: content,
        path: _getSegmentsExperienceId(getState) ? [processor, editableId, _getSegmentsExperienceId(getState), _getLanguageId(getState)] : [processor, editableId, _getLanguageId(getState)]
      }]), dispatch, getState);
    };
  };
  /**
   * Sets the editable value mappedField.
   * @param {string} fragmentEntryLinkId
   * @param {EDITABLE_FRAGMENT_ENTRY_PROCESSOR|BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR} processor
   * @param {string} editableId
   * @param {string} mappedField
   */

  exports.updateEditableValueContentAction = updateEditableValueContentAction;

  var updateEditableValueMappedFieldAction = function updateEditableValueMappedFieldAction(fragmentEntryLinkId, processor, editableId, mappedField) {
    return function (dispatch, getState) {
      return _sendEditableValues(fragmentEntryLinkId, [{
        path: [processor, editableId]
      }, {
        content: mappedField,
        path: [processor, editableId, 'mappedField']
      }], dispatch, getState);
    };
  };
  /**
   * Sets the editable value classNameId, classPK and fieldId.
   * @param {string} fragmentEntryLinkId
   * @param {EDITABLE_FRAGMENT_ENTRY_PROCESSOR|BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR} processor
   * @param {string} editableId
   * @param {object} mapData
   * @param {string} mapData.classNameId
   * @param {string} mapData.classPK
   * @param {string} mapData.fieldId
   */

  exports.updateEditableValueMappedFieldAction = updateEditableValueMappedFieldAction;

  var updateEditableValueFieldIdAction = function updateEditableValueFieldIdAction(fragmentEntryLinkId, processor, editableId, mapData) {
    return function (dispatch, getState) {
      return _sendEditableValues(fragmentEntryLinkId, [{
        path: [processor, editableId]
      }].concat(_toConsumableArray(Object.entries(mapData).map(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            key = _ref2[0],
            value = _ref2[1];

        return {
          content: value,
          path: [processor, editableId, key]
        };
      }))), dispatch, getState);
    };
  };
  /**
   * @param {number} fragmentEntryLinkId
   * @param {object} configuration
   * @review
   */

  exports.updateEditableValueFieldIdAction = updateEditableValueFieldIdAction;

  var updateFragmentConfigurationAction = function updateFragmentConfigurationAction(fragmentEntryLinkId, configuration) {
    return function (dispatch, getState) {
      return _sendEditableValues(fragmentEntryLinkId, [{
        content: configuration,
        path: _getSegmentsExperienceId(getState) ? [_constants.FREEMARKER_FRAGMENT_ENTRY_PROCESSOR, _getSegmentsExperienceId(getState)] : [_constants.FREEMARKER_FRAGMENT_ENTRY_PROCESSOR]
      }], dispatch, getState).then(function () {
        var state = getState();
        return dispatch(updateFragmentEntryLinkContent(fragmentEntryLinkId, state.segmentsExperienceId || state.defaultSegmentsExperienceId));
      });
    };
  };
  /**
   * @param {number} fragmentEntryLinkId
   * @param {number} segmentsExperienceId
   * @review
   */

  exports.updateFragmentConfigurationAction = updateFragmentConfigurationAction;

  function updateFragmentEntryLinkContent(fragmentEntryLinkId, segmentsExperienceId) {
    return function (dispatch, getState) {
      var state = getState();
      var fragmentEntryLink = state.fragmentEntryLinks[fragmentEntryLinkId];
      (0, _fragments.getFragmentEntryLinkContent)(state.renderFragmentEntryURL, fragmentEntryLink, state.portletNamespace, segmentsExperienceId).then(function (response) {
        var content = response.content,
            fragmentEntryLinkId = response.fragmentEntryLinkId;
        dispatch({
          fragmentEntryLinkContent: content,
          fragmentEntryLinkId: fragmentEntryLinkId,
          type: _actions.UPDATE_FRAGMENT_ENTRY_LINK_CONTENT
        });
      });
    };
  }
  /**
   * @param {function} getState
   */

  var _getLanguageId = function _getLanguageId(getState) {
    var state = getState();
    return state.languageId || state.defaultLanguageId;
  };
  /**
   * @param {function} getState
   */

  var _getSegmentsExperienceId = function _getSegmentsExperienceId(getState) {
    var state = getState();
    return (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(state.segmentsExperienceId || state.defaultSegmentsExperienceId);
  };
  /**
   *
   * @param {object} editableValues
   * @param {{path: string[], content: any}} change
   */

  var _mergeChange = function _mergeChange(editableValues, change) {
    if (!change.content) {
      return (0, _FragmentsEditorUpdateUtils.updateIn)(editableValues, change.path, function (editable) {
        var newEditable = undefined;

        if (editable && (editable.defaultValue || editable.config)) {
          newEditable = {
            config: editable.config,
            defaultValue: editable.defaultValue
          };
        }

        return newEditable;
      });
    }

    return (0, _FragmentsEditorUpdateUtils.setIn)(editableValues, change.path, change.content);
  };
  /**
   *
   * @param {string} fragmentEntryLinkId
   * @param {Array<{path: string[], content: any}>} changes
   * @param {function} dispatch
   * @param {function} getState
   */

  var _sendEditableValues = function _sendEditableValues(fragmentEntryLinkId, changes, dispatch, getState) {
    var previousEditableValues = getState().fragmentEntryLinks[fragmentEntryLinkId].editableValues;
    var nextEditableValues = changes.reduce(function (editableValues, change) {
      return _mergeChange(editableValues, change);
    }, previousEditableValues);
    dispatch(_updateEditableValuesLoadingAction(fragmentEntryLinkId, nextEditableValues));
    dispatch((0, _saveChanges.enableSavingChangesStatusAction)());
    return (0, _FragmentsEditorFetchUtils.updateEditableValues)(fragmentEntryLinkId, nextEditableValues).then(function () {
      dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
      dispatch((0, _saveChanges.updateLastSaveDateAction)());
    }).then(function () {
      var hasContentChanges = changes.some(function (change) {
        return change.path.includes('mappedField') || change.path.includes('fieldId');
      });

      if (hasContentChanges) {
        return dispatch((0, _updatePageContents.updatePageContentsAction)());
      }
    })["catch"](function () {
      dispatch(_updateEditableValuesErrorAction(fragmentEntryLinkId, previousEditableValues));
      dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
    });
  };
  /**
   * @param {string} fragmentEntryLinkId
   * @param {object} editableValues
   * @param {Date} [date=new Date()]
   * @return {object}
   * @review
   */

  function _updateEditableValuesErrorAction(fragmentEntryLinkId, editableValues) {
    var date = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new Date();
    return {
      date: date,
      editableValues: editableValues,
      fragmentEntryLinkId: fragmentEntryLinkId,
      type: _actions.UPDATE_EDITABLE_VALUE_ERROR
    };
  }
  /**
   * @param {string} fragmentEntryLinkId
   * @param {object} editableValues
   * @return {object}
   * @review
   */

  function _updateEditableValuesLoadingAction(fragmentEntryLinkId, editableValues) {
    return {
      editableValues: editableValues,
      fragmentEntryLinkId: fragmentEntryLinkId,
      type: _actions.UPDATE_EDITABLE_VALUE_LOADING
    };
  }
  //# sourceMappingURL=updateEditableValue.es.js.map
});
//# sourceMappingURL=updateEditableValue.es.js.map