Liferay.Loader.define("layout-content-page-editor-web@1.0.52/js/actions/removeFragmentEntryLinks.es", ['module', 'exports', 'require', '../utils/FragmentsEditorFetchUtils.es', '../utils/LayoutDataList.es', './actions.es', './updatePageContents.es', './updatePageEditorLayoutData.es', './updateWidgets.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.removeFragmentEntryLinksAction = removeFragmentEntryLinksAction;
  exports.removeFragmentEntryLinkAction = removeFragmentEntryLinkAction;

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  var _LayoutDataList = require("../utils/LayoutDataList.es");

  var _actions = require("./actions.es");

  var _updatePageContents = require("./updatePageContents.es");

  var _updatePageEditorLayoutData = require("./updatePageEditorLayoutData.es");

  var _updateWidgets = require("./updateWidgets.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * Removes a list of fragment entry links
   * @param {array} fragmentEntryLinks
   * @review
   */
  function removeFragmentEntryLinksAction(fragmentEntryLinks) {
    return function (dispatch) {
      return (0, _FragmentsEditorFetchUtils.removeFragmentEntryLinks)(fragmentEntryLinks).then(function () {
        return dispatch((0, _updatePageContents.updatePageContentsAction)());
      });
    };
  }
  /**
   * Removes a fragment entry link
   * @param {string} fragmentEntryLinkId
   * @review
   */

  function removeFragmentEntryLinkAction(fragmentEntryLinkId) {
    return function (dispatch, getState) {
      var state = getState();
      var fragmentEntryLinkIsUsedInOtherExperience = (0, _LayoutDataList.containsFragmentEntryLinkId)(state.layoutDataList, fragmentEntryLinkId, state.segmentsExperienceId || state.defaultSegmentsExperienceId);
      dispatch((0, _updateWidgets.updateWidgetsAction)([fragmentEntryLinkId]));
      dispatch(_removeFragmentEntryAction(fragmentEntryLinkId, fragmentEntryLinkIsUsedInOtherExperience));
      dispatch((0, _updatePageEditorLayoutData.updatePageEditorLayoutDataAction)());

      if (!fragmentEntryLinkIsUsedInOtherExperience) {
        dispatch(removeFragmentEntryLinksAction([fragmentEntryLinkId]));
      } else {
        (0, _FragmentsEditorFetchUtils.removeExperience)(state.segmentsExperienceId, [fragmentEntryLinkId], false);
      }
    };
  }

  function _removeFragmentEntryAction(fragmentEntryLinkId, fragmentEntryLinkIsUsedInOtherExperience) {
    return {
      fragmentEntryLinkId: fragmentEntryLinkId,
      fragmentEntryLinkIsUsedInOtherExperience: fragmentEntryLinkIsUsedInOtherExperience,
      type: _actions.REMOVE_FRAGMENT_ENTRY_LINK
    };
  }
  //# sourceMappingURL=removeFragmentEntryLinks.es.js.map
});
//# sourceMappingURL=removeFragmentEntryLinks.es.js.map