"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/utils/debouncedAlert.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.debouncedAlert = debouncedAlert;
  exports.default = void 0;

  /**
   * Returns a debounced function that will delay it execution until delay
   * has passed. If window is closed or navigation is performed before
   * this delay, an alert will be shown to prevent it from not being executed.
   * @param {function} callback
   * @param {number} [delay=0]
   * @param {string} [message='Do you want to leave this site...']
   * @return {function}
   * @review
   */
  function debouncedAlert(callback) {
    var delay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var message = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Liferay.Language.get('do-you-want-to-leave-this-site');
    var beforeNavigateHandler = null;
    var timeoutId = null;
    /**
     * @review
     */

    var clearPendingCallback = function clearPendingCallback() {
      window.removeEventListener('beforeunload', handleBeforeUnload);

      if (beforeNavigateHandler) {
        beforeNavigateHandler.detach();
        beforeNavigateHandler = null;
      }

      if (timeoutId) {
        clearTimeout(timeoutId);
        timeoutId = null;
      }
    };
    /**
     * @param {{originalEvent: Event}} event
     * @review
     */

    var handleBeforeNavigate = function handleBeforeNavigate(event) {
      if (confirm(message)) {
        clearPendingCallback();
      } else {
        event.originalEvent.preventDefault();
      }
    };
    /**
     * @param {BeforeUnloadEvent} event
     * @review
     */

    var handleBeforeUnload = function handleBeforeUnload(event) {
      event.returnValue = message;
      return message;
    };

    return function () {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      clearPendingCallback();
      beforeNavigateHandler = Liferay.on('beforeNavigate', handleBeforeNavigate);
      window.addEventListener('beforeunload', handleBeforeUnload);
      timeoutId = setTimeout(function () {
        clearPendingCallback();
        callback.apply(void 0, args);
      }, delay);
    };
  }

  var _default = debouncedAlert;
  exports.default = _default;
  //# sourceMappingURL=debouncedAlert.es.js.map
});
//# sourceMappingURL=debouncedAlert.es.js.map