"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/utils/FragmentsEditorUpdateUtils.es", ['module', 'exports', 'require', '../actions/actions.es', './rowConstants', '../actions/saveChanges.es', './constants', './FragmentsEditorGetUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.add = add;
  exports.addRow = addRow;
  exports.deleteIn = deleteIn;
  exports.moveItem = moveItem;
  exports.moveRow = moveRow;
  exports.remove = remove;
  exports.removeItem = removeItem;
  exports.setDraggingItemPosition = setDraggingItemPosition;
  exports.setIn = setIn;
  exports.updateIn = updateIn;
  exports.updateRow = updateRow;
  exports.updateWidgets = updateWidgets;

  var _actions = require("../actions/actions.es");

  var _rowConstants = require("./rowConstants");

  var _saveChanges = require("../actions/saveChanges.es");

  var _constants = require("./constants");

  var _FragmentsEditorGetUtils = require("./FragmentsEditorGetUtils.es");

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  /**
   * Inserts an element in the given position of a given array and returns
   * a copy of the array
   * @param {!Array} array
   * @param {*} element
   * @param {!number} position
   * @return {Array}
   */
  function add(array, element, position) {
    var newArray = _toConsumableArray(array);

    newArray.splice(position, 0, element);
    return newArray;
  }
  /**
   * Returns a new layoutData with the given columns inserted as a new row
   * at the given position
   *
   * @param {Array} layoutColumns
   * @param {object} layoutData
   * @param {number} position
   * @param {Array} fragmentEntryLinkIds
   * @param {string} type
   * @return {object}
   */

  function addRow(layoutColumns, layoutData, position) {
    var fragmentEntryLinkIds = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];
    var type = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : _constants.FRAGMENTS_EDITOR_ROW_TYPES.componentRow;
    var nextColumnId = layoutData.nextColumnId || 0;
    var nextRowId = layoutData.nextRowId || 0;
    var columns = [];
    layoutColumns.forEach(function (columnSize) {
      columns.push({
        columnId: "".concat(nextColumnId),
        fragmentEntryLinkIds: fragmentEntryLinkIds,
        size: columnSize
      });
      nextColumnId += 1;
    });
    var defaultConfig = type === _constants.FRAGMENTS_EDITOR_ROW_TYPES.sectionRow ? _rowConstants.DEFAULT_SECTION_ROW_CONFIG : _rowConstants.DEFAULT_COMPONENT_ROW_CONFIG;
    var nextStructure = add(layoutData.structure, {
      columns: columns,
      config: defaultConfig,
      rowId: "".concat(nextRowId),
      type: type
    }, position);
    var nextData = setIn(layoutData, ['nextColumnId'], nextColumnId);
    nextData = setIn(nextData, ['structure'], nextStructure);
    nextData = setIn(nextData, ['nextRowId'], nextRowId + 1);
    return nextData;
  }
  /**
   * Removes the last key in keyPath from the given object and returns a new one
   * @param {Array|Object} object Original object that will be copied
   * @param {Array<string>} keyPath Array of strings used for reaching the deep property
   * @return {Array|Object} Copy of the original object without the last key in keyPath
   * @review
   */

  function deleteIn(object, keyPath) {
    var lastKey = keyPath.slice(-1);
    var newKeyPath = keyPath.slice(0, keyPath.length - 1);
    return updateIn(object, newKeyPath, function (lastItem) {
      var newLastItem = lastItem instanceof Array ? _toConsumableArray(lastItem) : Object.assign({}, lastItem);
      delete newLastItem[lastKey];
      return newLastItem;
    });
  }
  /**
   * Dispatches necessary actions to move an item to another position
   * @param {!Object} store Store instance that dispatches the actions
   * @param {!string} moveItemAction
   * @param {!Object} moveItemPayload Data that is passed to the reducer
   * @review
   */

  function moveItem(store, moveItemAction, moveItemPayload) {
    store.dispatch((0, _saveChanges.enableSavingChangesStatusAction)()).dispatch(Object.assign({}, moveItemPayload, {
      type: moveItemAction
    })).dispatch((0, _saveChanges.updateLastSaveDateAction)()).dispatch((0, _saveChanges.disableSavingChangesStatusAction)()).dispatch({
      type: _actions.CLEAR_DROP_TARGET
    });
  }
  /**
   * Moves a row one position in the given direction
   * @param {number} direction
   * @param {number} rowIndex
   * @param {{}} store
   * @param {Array} structure
   * @review
   */

  function moveRow(direction, rowIndex, store, structure) {
    var row = structure[rowIndex];
    var targetRow = structure[rowIndex + direction];

    if (targetRow) {
      var moveItemPayload = {
        rowId: row.rowId,
        targetBorder: (0, _FragmentsEditorGetUtils.getTargetBorder)(direction),
        targetItemId: targetRow.rowId
      };
      moveItem(store, _actions.MOVE_ROW, moveItemPayload);
    }
  }
  /**
   * Removes from the given array the element in the given position and
   * returns a new array
   * @param {!Array} array
   * @param {!number} position
   * @return {Array}
   * @review
   */

  function remove(array, position) {
    var newArray = _toConsumableArray(array);

    newArray.splice(position, 1);
    return newArray;
  }
  /**
   * Dispatches necessary actions to remove an item
   * @param {!Object} store Store instance that dispatches the actions
   * @param {!string} removeItemAction
   * @param {!Object} removeItemPayload Data that is passed to the reducer
   * @review
   */

  function removeItem(store, removeItemAction, removeItemPayload) {
    store.dispatch((0, _saveChanges.enableSavingChangesStatusAction)()).dispatch(Object.assign({}, removeItemPayload, {
      type: removeItemAction
    })).dispatch((0, _saveChanges.updateLastSaveDateAction)()).dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
  }
  /**
   * Set dragging item's position to mouse coordinates
   * @param {MouseEvent} event
   */

  function setDraggingItemPosition(event) {
    var draggingElement = document.body.querySelector(".".concat(_constants.FRAGMENTS_EDITOR_DRAGGING_CLASS));

    if (draggingElement instanceof HTMLElement) {
      var newXPos = event.clientX - draggingElement.offsetWidth / 2;
      var newYPos = event.clientY - draggingElement.offsetHeight / 2;
      requestAnimationFrame(function () {
        setElementPosition(draggingElement, newXPos, newYPos);
      });
    }
  }
  /**
   * Set an element's position to new x and y coordinates
   * @param {HTMLElement} element
   * @param {number} xPos
   * @param {number} yPos
   */

  function setElementPosition(element, xPos, yPos) {
    element.style.left = "".concat(xPos, "px");
    element.style.top = "".concat(yPos, "px");
  }
  /**
   * Recursively inserts a value inside an object creating
   * a copy of the original target. It the object (or any in the path),
   * it's an Array, it will generate new Arrays, preserving the same structure.
   * @param {Array|Object} object Original object that will be copied
   * @param {Array<string>} keyPath Array of strings used for reaching the deep property
   * @param {*} value Value to be inserted
   * @return {Array|Object} Copy of the original object with the new value
   * @review
   */

  function setIn(object, keyPath, value) {
    return updateIn(object, keyPath, function () {
      return value;
    });
  }
  /**
   * Recursively inserts the value returned from updater inside an object creating
   * a copy of the original target. It the object (or any in the path),
   * it's an Array, it will generate new Arrays, preserving the same structure.
   * Updater receives the previous value or defaultValue and returns a new value.
   * @param {Array|Object} object Original object that will be copied
   * @param {Array<string>} keyPath Array of strings used for reaching the deep property
   * @param {function} updater Update function
   * @param {*} [defaultValue] Default value to be sent to updater function if
   *  there is no existing value
   * @return {Object}
   * @review
   */

  function updateIn(object, keyPath, updater, defaultValue) {
    var _keyPath = _slicedToArray(keyPath, 1),
        nextKey = _keyPath[0];

    var target = object;

    if (keyPath.length > 1) {
      target = target instanceof Array ? _toConsumableArray(target) : Object.assign({}, target);
      target[nextKey] = updateIn(target[nextKey] || {}, keyPath.slice(1), updater, defaultValue);
    } else {
      var nextValue = typeof target[nextKey] === 'undefined' ? defaultValue : target[nextKey];
      var updatedNextValue = updater(nextValue);

      if (updatedNextValue !== target[nextKey]) {
        target = target instanceof Array ? _toConsumableArray(target) : Object.assign({}, target);
        target[nextKey] = updatedNextValue;
      }
    }

    return target;
  }
  /**
   * Updates row
   * @param {!Object} store Store instance that dispatches the actions
   * @param {string} updateAction Update action name
   * @param {object} payload Row payload
   * @private
   * @review
   */

  function updateRow(store, updateAction, payload) {
    store.dispatch((0, _saveChanges.enableSavingChangesStatusAction)()).dispatch(Object.assign({}, payload, {
      type: updateAction
    })).dispatch((0, _saveChanges.updateLastSaveDateAction)()).dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
  }
  /**
   * @param {Object} state
   * @param {Object[]} state.fragmentEntryLinks
   * @param {Object[]} state.widgets
   * @param {string} fragmentEntryLinkId
   * @return {Object} Next state
   */

  function updateWidgets(state, fragmentEntryLinkId) {
    var fragmentEntryLink = state.fragmentEntryLinks[fragmentEntryLinkId];
    var nextState = state;

    if (fragmentEntryLink.portletId) {
      var widget = (0, _FragmentsEditorGetUtils.getWidget)(state.widgets, fragmentEntryLink.portletId);

      if (!widget.instanceable && widget.used) {
        var widgetPath = (0, _FragmentsEditorGetUtils.getWidgetPath)(state.widgets, fragmentEntryLink.portletId);
        nextState = setIn(state, [].concat(_toConsumableArray(widgetPath), ['used']), false);
      }
    }

    return nextState;
  }
  //# sourceMappingURL=FragmentsEditorUpdateUtils.es.js.map
});
//# sourceMappingURL=FragmentsEditorUpdateUtils.es.js.map