"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/utils/FragmentsEditorGetUtils.es", ['module', 'exports', 'require', '../utils/constants'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.deepClone = deepClone;
  exports.getColumn = getColumn;
  exports.getDropRowPosition = getDropRowPosition;
  exports.getItemPath = getItemPath;
  exports.getFragmentColumn = getFragmentColumn;
  exports.getFragmentRowIndex = getFragmentRowIndex;
  exports.getItemMoveDirection = getItemMoveDirection;
  exports.getRowFragmentEntryLinkIds = getRowFragmentEntryLinkIds;
  exports.getRowIndex = getRowIndex;
  exports.getTargetBorder = getTargetBorder;
  exports.getWidget = getWidget;
  exports.getWidgetPath = getWidgetPath;
  exports.itemIsInPath = itemIsInPath;

  var _constants = require("../utils/constants");

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  var ARROW_DOWN_KEYCODE = 40;
  var ARROW_UP_KEYCODE = 38;
  var MOVE_ITEM_DIRECTIONS = {
    DOWN: 1,
    UP: -1
  };
  /**
   * @param {object} objectToClone
   * @returns {object}
   */

  function deepClone(objectToClone) {
    var cloned = objectToClone;

    if (_typeof(cloned) == 'object' && cloned !== null) {
      if (Array.isArray(cloned)) {
        cloned = objectToClone.map(function (arrayItem) {
          return deepClone(arrayItem);
        });
      } else {
        cloned = Object.assign({}, cloned);
        Object.keys(cloned).forEach(function (clonedKey) {
          cloned[clonedKey] = deepClone(cloned[clonedKey]);
        });
      }
    }

    return cloned;
  }
  /**
   * Returns the column with the given columnId
   * @param {Object} structure
   * @param {string} columnId
   * @return {Object}
   */

  function getColumn(structure, columnId) {
    return structure.map(function (row) {
      return row.columns.find(function (_column) {
        return _column.columnId === columnId;
      });
    }).filter(function (column) {
      return column;
    }).find(function (column) {
      return column;
    });
  }
  /**
   * Returns the position in the structure of the given row
   * @param {object} structure
   * @param {number} targetRowId
   * @param {string} targetBorder
   * @return {number}
   */

  function getDropRowPosition(structure, targetRowId, targetBorder) {
    var position = structure.length;
    var targetPosition = structure.findIndex(function (row) {
      return row.rowId === targetRowId;
    });

    if (targetPosition > -1 && targetBorder) {
      if (targetBorder === _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.top) {
        position = targetPosition;
      } else {
        position = targetPosition + 1;
      }
    }

    return position;
  }
  /**
   * Returns the column that contains the fragment
   * with the given fragmentEntryLinkId.
   *
   * @param {Array} structure
   * @param {string} fragmentEntryLinkId
   * @return {Object}
   */

  function getFragmentColumn(structure, fragmentEntryLinkId) {
    return structure.map(function (row) {
      return row.columns.find(function (_column) {
        return _column.fragmentEntryLinkIds.find(function (fragmentId) {
          return fragmentId === fragmentEntryLinkId;
        });
      });
    }).filter(function (column) {
      return column;
    }).find(function (column) {
      return column;
    });
  }
  /**
   * Returns the row index of a given fragmentEntryLinkId.
   * -1 if it is not present.
   *
   * @param {Array} structure
   * @param {string} fragmentEntryLinkId
   * @return {number}
   */

  function getFragmentRowIndex(structure, fragmentEntryLinkId) {
    return structure.findIndex(function (row) {
      return row.columns.find(function (column) {
        return column.fragmentEntryLinkIds.find(function (_fragmentEntryLinkId) {
          return _fragmentEntryLinkId === fragmentEntryLinkId;
        });
      });
    });
  }
  /**
   * @param {number} keycode
   * @return {number|null}
   * @review
   */

  function getItemMoveDirection(keycode) {
    var direction = null;

    if (keycode === ARROW_UP_KEYCODE) {
      direction = MOVE_ITEM_DIRECTIONS.UP;
    } else if (keycode === ARROW_DOWN_KEYCODE) {
      direction = MOVE_ITEM_DIRECTIONS.DOWN;
    }

    return direction;
  }
  /**
   * For a given itemId and itemType, returns an array
   * with the whole path of active elements.
   * @param {string|null} itemId
   * @param {string|null} itemType
   * @param {object[]} structure
   * @return {Array<{itemId: string, itemType}>}
   */

  function getItemPath(itemId, itemType, structure) {
    var itemPath = [];

    if (itemId && itemType && structure.length) {
      itemPath = [{
        itemId: itemId,
        itemType: itemType
      }];

      if (itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable) {
        var _itemId$split = itemId.split('-'),
            _itemId$split2 = _slicedToArray(_itemId$split, 1),
            fragmentEntryLinkId = _itemId$split2[0];

        if (fragmentEntryLinkId) {
          itemPath = [].concat(_toConsumableArray(itemPath), _toConsumableArray(getItemPath(fragmentEntryLinkId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment, structure)));
        }
      } else if (itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment) {
        var _ref;

        var column = (_ref = []).concat.apply(_ref, _toConsumableArray(structure.map(function (row) {
          return row.columns;
        }))).find(function (_column) {
          return _column.fragmentEntryLinkIds.indexOf(itemId) !== -1;
        });

        if (column) {
          itemPath = [].concat(_toConsumableArray(itemPath), _toConsumableArray(getItemPath(column.columnId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.column, structure)));
        }
      } else if (itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.column) {
        var row = structure.find(function (row) {
          return row.columns.find(function (column) {
            return column.columnId === itemId;
          });
        });

        if (row) {
          itemPath = [].concat(_toConsumableArray(itemPath), _toConsumableArray(getItemPath(row.rowId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row, structure)));
        }
      }
    }

    return itemPath;
  }
  /**
   * Get the fragmentEntryLinkIds of the fragments inside the given row
   * @param {{columns: Array<{fragmentEntryLinkIds: Array<string>}>}} row
   * @return {string[]}
   * @review
   */

  function getRowFragmentEntryLinkIds(row) {
    var fragmentEntryLinkIds = [];
    row.columns.forEach(function (column) {
      fragmentEntryLinkIds = fragmentEntryLinkIds.concat(column.fragmentEntryLinkIds);
    });
    return fragmentEntryLinkIds;
  }
  /**
   * Returns the index of the row with the given rowId
   * @param {Array} structure
   * @param {string} rowId
   * @return {number}
   */

  function getRowIndex(structure, rowId) {
    return structure.findIndex(function (row) {
      return row.rowId === rowId;
    });
  }
  /**
   * Get target item border from the direction the item is moving in
   * @param {number} direction
   * @return {string}
   * @review
   */

  function getTargetBorder(direction) {
    var targetBorder = null;

    if (direction === MOVE_ITEM_DIRECTIONS.UP) {
      targetBorder = _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.top;
    } else if (direction === MOVE_ITEM_DIRECTIONS.DOWN) {
      targetBorder = _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.bottom;
    }

    return targetBorder;
  }
  /**
   * Get widget from the widgets tree by portletId
   * @param {!Array} widgets
   * @param {!string} portletId
   * @return {object}
   * @review
   */

  function getWidget(widgets, portletId) {
    var widget = null;
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = widgets[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var widgetCategory = _step.value;
        var _widgetCategory$categ = widgetCategory.categories,
            categories = _widgetCategory$categ === void 0 ? [] : _widgetCategory$categ,
            _widgetCategory$portl = widgetCategory.portlets,
            portlets = _widgetCategory$portl === void 0 ? [] : _widgetCategory$portl;
        var categoryPortlet = portlets.find(function (_portlet) {
          return _portlet.portletId === portletId;
        });
        var subCategoryPortlet = getWidget(categories, portletId);

        if (categoryPortlet) {
          widget = categoryPortlet;
        }

        if (subCategoryPortlet) {
          widget = subCategoryPortlet;
        }
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    return widget;
  }
  /**
   * Get widget path from the widgets tree by portletId
   * @param {Array<{categories: Array, portlets: Array}>} widgets
   * @param {string} portletId
   * @param {string[]} [_path=['widgets']]
   * @return {object}
   * @review
   */

  function getWidgetPath(widgets, portletId) {
    var _path = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ['widgets'];

    var widgetPath = null;

    for (var categoryIndex = 0; categoryIndex < widgets.length; categoryIndex += 1) {
      var _widgets$categoryInde = widgets[categoryIndex],
          _widgets$categoryInde2 = _widgets$categoryInde.categories,
          categories = _widgets$categoryInde2 === void 0 ? [] : _widgets$categoryInde2,
          _widgets$categoryInde3 = _widgets$categoryInde.portlets,
          portlets = _widgets$categoryInde3 === void 0 ? [] : _widgets$categoryInde3;
      var categoryPortletIndex = portlets.findIndex(function (_portlet) {
        return _portlet.portletId === portletId;
      });
      var subCategoryPortletPath = getWidgetPath(categories, portletId, [].concat(_toConsumableArray(_path), [categoryIndex.toString(), 'categories']));

      if (categoryPortletIndex !== -1) {
        widgetPath = [].concat(_toConsumableArray(_path), [categoryIndex, 'portlets', categoryPortletIndex]);
      }

      if (subCategoryPortletPath) {
        widgetPath = subCategoryPortletPath;
      }
    }

    return widgetPath;
  }
  /**
   * @param {object} path
   * @param {string} itemId
   * @param {string} itemType
   * @return {boolean} Item is in path
   * @review
   */

  function itemIsInPath(path, itemId, itemType) {
    return path.some(function (pathItem) {
      return pathItem.itemId === itemId && pathItem.itemType === itemType;
    });
  }
  //# sourceMappingURL=FragmentsEditorGetUtils.es.js.map
});
//# sourceMappingURL=FragmentsEditorGetUtils.es.js.map