"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/utils/FragmentsEditorFetchUtils.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.removeExperience = removeExperience;
  exports.removeFragmentEntryLinks = removeFragmentEntryLinks;
  exports.setStore = setStore;
  exports.updateEditableValues = updateEditableValues;
  exports.updatePageEditorLayoutData = updatePageEditorLayoutData;

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  /**
   * @type {object}
   */
  var _store;
  /**
   * @param {object} body
   * @param {string} portletNamespace
   * @param {FormData} [_formData=new FormData()]
   * @return {FormData}
   * @review
   */

  function _getFormData(body, portletNamespace) {
    var _formData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new FormData();

    Object.entries(body).forEach(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          key = _ref2[0],
          value = _ref2[1];

      _formData.append("".concat(portletNamespace).concat(key), value);
    });
    return _formData;
  }
  /**
   * @param {string} url
   * @param {object} [body={}]
   * @private
   * @return {Promise<Response>}
   * @review
   */

  function _fetch(url) {
    var body = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    return fetch(url, {
      body: _getFormData(body, _store.getState().portletNamespace),
      credentials: 'include',
      method: 'POST'
    });
  }
  /**
   * @param {string} segmentsExperienceId
   * @param {Array<string>} [fragmentEntryLinkIds=[]]
   * @return {Promise<Response>}
   */

  function removeExperience(segmentsExperienceId) {
    var fragmentEntryLinkIds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

    var state = _store.getState();

    var body = {
      segmentsExperienceId: segmentsExperienceId
    };

    if (fragmentEntryLinkIds && fragmentEntryLinkIds.length) {
      body.fragmentEntryLinkIds = JSON.stringify(fragmentEntryLinkIds);
    }

    return _fetch(state.deleteSegmentsExperienceURL, body);
  }
  /**
   * @param {{}} layoutData
   * @param {string[]} fragmentEntryLinkIds
   * @param {string} segmentsExperienceId
   * @return {Promise<Response[]>}
   */

  function removeFragmentEntryLinks(layoutData, fragmentEntryLinkIds, segmentsExperienceId) {
    var state = _store.getState();

    return Promise.all(fragmentEntryLinkIds.map(function (fragmentEntryLinkId) {
      return _fetch(state.deleteFragmentEntryLinkURL, {
        classNameId: state.classNameId,
        classPK: state.classPK,
        data: JSON.stringify(layoutData),
        fragmentEntryLinkId: fragmentEntryLinkId,
        segmentsExperienceId: segmentsExperienceId
      });
    }));
  }
  /**
   * Sets the store
   * @param {object} store
   */

  function setStore(store) {
    _store = store;
  }
  /**
   * @param {string} fragmentEntryLinkId
   * @param {object} editableValues
   * @return {Promise<Response>}
   */

  function updateEditableValues(fragmentEntryLinkId, editableValues) {
    var state = _store.getState();

    return _fetch(state.editFragmentEntryLinkURL, {
      editableValues: JSON.stringify(editableValues),
      fragmentEntryLinkId: fragmentEntryLinkId
    });
  }
  /**
   * @param {Object} layoutData
   * @param {string} segmentsExperienceId
   * @return {Promise<Response>}
   */

  function updatePageEditorLayoutData(layoutData, segmentsExperienceId) {
    var state = _store.getState();

    return _fetch(state.updateLayoutPageTemplateDataURL, {
      classNameId: state.classNameId,
      classPK: state.classPK,
      data: JSON.stringify(layoutData),
      segmentsExperienceId: segmentsExperienceId
    });
  }
  //# sourceMappingURL=FragmentsEditorFetchUtils.es.js.map
});
//# sourceMappingURL=FragmentsEditorFetchUtils.es.js.map