"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/store/store.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', './state.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.Store = exports.createStore = exports.disconnect = exports.connect = void 0;

  var _metalState = _interopRequireWildcard(require("frontend-js-metal-web$metal-state"));

  var _state = require("./state.es");

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj.default = obj;return newObj;
    }
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * ID of the development devTool that may be connected to store.
   * We are relying on redux-devtools, so we can continue using
   * them when we move to a proper state-management library.
   *
   * They provide a global hook that is available when the browser
   * has redux-devtools-extension installed:
   *
   * http://extension.remotedev.io/#usage
   *
   * @review
   */
  var STORE_DEVTOOLS_ID = '__REDUX_DEVTOOLS_EXTENSION__';
  /**
   * Connects a given component to a given store, syncing it's properties with it.
   * @param {Component} component
   * @param {Store} store
   * @review
   */

  var connect = function connect(component, store) {
    component._storeChangeListener = store.on('change', function () {
      return syncStoreState(component, store);
    });
    syncStoreState(component, store);
  };
  /**
   * Disconnects a given component from it's store
   * @param {ConnectedComponent} component
   */

  exports.connect = connect;

  var disconnect = function disconnect(component) {
    if (component._storeChangeListener) {
      component._storeChangeListener.removeListener();

      component._storeChangeListener = null;
    }
  };
  /**
   * Creates a store and links the given components to it.
   * Each component will receive the store as `store` attribute.
   * @param {object} initialState
   * @param {function[]} reducers
   * @param {string[]} componentIds
   * @return {Store}
   * @review
   */

  exports.disconnect = disconnect;

  var createStore = function createStore(initialState, reducers) {
    var componentIds = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
    var store = new Store(initialState, reducers);
    componentIds.forEach(function (componentId) {
      Liferay.componentReady(componentId).then(function (component) {
        component.store = store;
        connect(component, store);
      });
    });
    return store;
  };
  /**
   * @param {ConnectedComponent} component
   * @param {Store} store
   */

  exports.createStore = createStore;

  var syncStoreState = function syncStoreState(component, store) {
    var state = store.getState();
    component.getStateKeys().filter(function (key) {
      return key in state;
    }).filter(function (key) {
      return component[key] !== state[key];
    }).forEach(function (key) {
      component[key] = state[key];
    });
  };
  /**
   * Redux-like store that can be used for maintaining a State that can only be
   * modified with pure reducers.
   *
   * Store emits a "change" event with the nextState every time the state has
   * been changed.
   *
   * @review
   */

  var Store =
  /*#__PURE__*/
  function (_State) {
    _inherits(Store, _State);

    /**
     * @param {object} [initialState={}]
     * @param {function[]} [reducers=[]]
     * @review
     */
    function Store() {
      var _this;

      var initialState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var reducers = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

      _classCallCheck(this, Store);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(Store).call(this));
      _this.dispatch = _this.dispatch.bind(_assertThisInitialized(_this));
      _this.getState = _this.getState.bind(_assertThisInitialized(_this));

      _this._setInitialState(initialState);

      _this.registerReducers(reducers);

      if (false && STORE_DEVTOOLS_ID in window) {
        _this._devTools = window[STORE_DEVTOOLS_ID].connect();

        _this._devTools.init(_this._state);
      }

      return _this;
    }
    /**
     * @inheritDoc
     */

    _createClass(Store, [{
      key: "disposed",
      value: function disposed() {
        if (false && this._devTools) {
          this._devTools.disconnect();
        }
      }
      /**
       * Dispatch an action to the store. Each action is identified by a given
       * actionType, and can contain an optional payload with any kind of
       * information.
       * @param {{type: string}|function(function, function): Promise|void} action
       * @return {Store}
       * @review
       */

    }, {
      key: "dispatch",
      value: function dispatch(action) {
        var _this2 = this;

        if (typeof action === 'function') {
          this._dispatchPromise = this._dispatchPromise.then(function () {
            return Promise.resolve(action(_this2.dispatch, _this2.getState));
          });
        } else {
          this._dispatchPromise = this._dispatchPromise.then(function () {
            return _this2._reducers.reduce(function (promiseNextState, reducer) {
              return promiseNextState.then(function (nextState) {
                return Promise.resolve(reducer(nextState, action));
              });
            }, Promise.resolve(_this2._state)).then(function (nextState) {
              if (_this2._state !== nextState) {
                _this2._state = _this2._getFrozenState(nextState);

                _this2.emit('change', _this2._state);

                if (false && _this2._devTools) {
                  _this2._devTools.send(action, _this2._state);
                }
              }

              return new Promise(function (resolve) {
                requestAnimationFrame(function () {
                  resolve(_this2);
                });
              });
            });
          });
        }

        return this;
      }
    }, {
      key: "done",
      value: function done(callback) {
        var _this3 = this;

        this._dispatchPromise = this._dispatchPromise.then(function () {
          return callback(_this3);
        });
        return this;
      }
    }, {
      key: "failed",
      value: function failed(callback) {
        this._dispatchPromise = this._dispatchPromise.catch(function (error) {
          return callback(error);
        });
        return this;
      }
      /**
       * Returns current state.
       * Warning: that state cannot be modified anyway.
       * @return {object} Current state
       * @review
       */

    }, {
      key: "getState",
      value: function getState() {
        return this._state;
      }
      /**
       * Adds a new reducer to the store.
       *
       * A reducer is a function that receives a state, an actionType and
       * an optional payload with information, and returns a new state without
       * altering the original one.
       *
       * @param {!function} reducer
       * @review
       */

    }, {
      key: "registerReducer",
      value: function registerReducer(reducer) {
        this._reducers = [].concat(_toConsumableArray(this._reducers), [reducer]);
      }
      /**
       * Adds a list of reducers to the store.
       * @param {!Array<function>} reducers
       * @review
       * @see {Store.registerReducer}
       */

    }, {
      key: "registerReducers",
      value: function registerReducers(reducers) {
        this._reducers = [].concat(_toConsumableArray(this._reducers), _toConsumableArray(reducers));
      }
      /**
       * For a given state, returns a frozen copy of it
       * @param {object} state
       * @private
       * @return {object} Frozen state
       * @review
       */

    }, {
      key: "_getFrozenState",
      value: function _getFrozenState(state) {
        var _this4 = this;

        var differentState = !this._state || Object.entries(state).some(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              key = _ref2[0],
              value = _ref2[1];

          return _this4._state[key] !== value;
        });

        if (differentState) {
          this._state = state;
          Object.freeze(this._state);
        }

        return this._state;
      }
      /**
       * Sets the store state to the given state. This function should not be
       * called after setting the initialState.
       * The given initial state is combined with DEFAULT_INITIAL_STATE to provide
       * default values for unknown data.
       * @param {!Object} initialState
       * @return {Object}
       * @private
       * @review
       */

    }, {
      key: "_setInitialState",
      value: function _setInitialState(initialState) {
        if (this._state) {
          throw new Error('State already initialized');
        }

        this._state = this._getFrozenState(Object.assign({}, _state.DEFAULT_INITIAL_STATE, initialState));
        return this._state;
      }
    }]);

    return Store;
  }(_metalState.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.Store = Store;
  Store.STATE = {
    /**
     * Redux devtools
     * @instance
     * @memberOf Store
     * @private
     * @review
     * @type {any|null}
     */
    _devTools: _metalState.Config.any().internal().value(null),

    /**
     * @default Promise.resolve()
     * @instance
     * @memberOf Store
     * @private
     * @review
     * @type {Promise}
     */
    _dispatchPromise: _metalState.Config.instanceOf(Promise).internal().value(Promise.resolve()),

    /**
     * @default []
     * @instance
     * @memberOf Store
     * @private
     * @review
     * @type {function[]}
     */
    _reducers: _metalState.Config.arrayOf(_metalState.Config.func()).internal().value([]),

    /**
     * @default null
     * @instance
     * @memberOf Store
     * @private
     * @review
     * @type {object}
     */
    _state: _metalState.Config.object().internal().value(null)
  };
  var _default = Store;
  exports.default = _default;
  //# sourceMappingURL=store.es.js.map
});
//# sourceMappingURL=store.es.js.map