"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/reducers/translations.es", ['module', 'exports', 'require', '../actions/actions.es', '../utils/FragmentsEditorUpdateUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.languageIdReducer = languageIdReducer;

  var _actions = require("../actions/actions.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  /**
   * Reducer for changing languageId
   * @param {object} state
   * @param {object} action
   * @param {string} action.languageId
   * @param {string} action.type
   * @return {object}
   * @review
   */
  function languageIdReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.CHANGE_LANGUAGE_ID) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['languageId'], action.languageId);
    }

    return nextState;
  }
  //# sourceMappingURL=translations.es.js.map
});
//# sourceMappingURL=translations.es.js.map