"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/reducers/segmentsExperiences.es", ['module', 'exports', 'require', '../actions/actions.es', '../utils/FragmentsEditorGetUtils.es', '../utils/FragmentsEditorUpdateUtils.es', '../utils/FragmentsEditorFetchUtils.es', '../utils/LayoutDataList.es', '../utils/prefixSegmentsExperienceId.es', '../utils/constants'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.createSegmentsExperienceReducer = createSegmentsExperienceReducer;
  exports.deleteSegmentsExperienceReducer = deleteSegmentsExperienceReducer;
  exports.editSegmentsExperienceReducer = editSegmentsExperienceReducer;
  exports.updateSegmentsExperiencePriorityReducer = updateSegmentsExperiencePriorityReducer;
  exports.selectSegmentsExperienceReducer = selectSegmentsExperienceReducer;

  var _actions = require("../actions/actions.es");

  var _FragmentsEditorGetUtils = require("../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  var _LayoutDataList = require("../utils/LayoutDataList.es");

  var _prefixSegmentsExperienceId = require("../utils/prefixSegmentsExperienceId.es");

  var _constants = require("../utils/constants");

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var CREATE_SEGMENTS_EXPERIENCE_URL = '/segments.segmentsexperience/add-segments-experience';
  var EDIT_SEGMENTS_EXPERIENCE_URL = '/segments.segmentsexperience/update-segments-experience';
  var UPDATE_SEGMENTS_EXPERIENCE_PRIORITY_URL = '/segments.segmentsexperience/update-segments-experience-priority';
  /**
   * Stores a the layout data of a new experience in layoutDataList
   * @param {object} state
   * @param {Array<{segmentsExperienceId: string}>} state.layoutDataList
   * @param {object} state.layoutData
   * @param {string} state.defaultSegmentsExperienceId
   * @param {string} segmentsExperienceId The segmentsExperience id that owns this LayoutData
   * @returns {Promise}
   */

  function _storeNewLayoutData(state, segmentsExperienceId) {
    var nextState = state;
    return new Promise(function (resolve, reject) {
      var baseLayoutData = null;

      if (nextState.defaultSegmentsExperienceId === nextState.segmentsExperienceId || !nextState.segmentsExperienceId) {
        baseLayoutData = (0, _FragmentsEditorGetUtils.deepClone)(nextState.layoutData);
      } else {
        var defaultExperienceLayoutListItem = nextState.layoutDataList.find(function (segmentedLayout) {
          return segmentedLayout.segmentsExperienceId === nextState.defaultSegmentsExperienceId;
        });
        baseLayoutData = defaultExperienceLayoutListItem && (0, _FragmentsEditorGetUtils.deepClone)(defaultExperienceLayoutListItem.layoutData);
      }

      (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(baseLayoutData, segmentsExperienceId).then(function () {
        nextState.layoutDataList.push({
          layoutData: baseLayoutData,
          segmentsExperienceId: segmentsExperienceId
        });
        return resolve(nextState);
      }).catch(function (e) {
        reject(e);
      });
    });
  }
  /**
   *
   * @param {object} state
   * @param {object} state.layoutData
   * @param {Array<{segmentsExperienceId: string ,layoutData: object}>} state.layoutDataList
   * @param {string} segmentsExperienceId
   * @returns {Promise}
   */

  function _switchLayoutDataList(state, segmentsExperienceId) {
    var nextState = state;
    return new Promise(function (resolve, reject) {
      try {
        (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(state.layoutData, state.segmentsExperienceId || state.defaultSegmentsExperienceId).then(function () {
          var prevLayout = nextState.layoutData;
          var prevSegmentsExperienceId = state.segmentsExperienceId || nextState.defaultSegmentsExperienceId;
          var layoutData = {};

          if (segmentsExperienceId === prevSegmentsExperienceId) {
            layoutData = nextState.layoutData;
          } else {
            var layoutDataItem = nextState.layoutDataList.find(function (segmentedLayout) {
              return segmentedLayout.segmentsExperienceId === segmentsExperienceId;
            });
            layoutData = layoutDataItem ? layoutDataItem.layoutData : (0, _LayoutDataList.getEmptyLayoutData)();
          }

          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], layoutData);
          var newlayoutDataList = nextState.layoutDataList.map(function (segmentedLayout) {
            return segmentedLayout.segmentsExperienceId === prevSegmentsExperienceId ? Object.assign({}, segmentedLayout, {
              layoutData: prevLayout
            }) : segmentedLayout;
          });
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutDataList'], newlayoutDataList);
          resolve(nextState);
        }).catch(function (error) {
          reject(error);
        });
      } catch (e) {
        reject(e);
      }
    });
  }
  /**
   *
   * @param {object} state
   * @param {Array<{segmentsExperienceId: string}>} state.layoutDataList
   * @param {string} state.defaultSegmentsExperienceId
   * @returns {object}
   */

  function _switchLayoutDataToDefault(state) {
    var nextState = state;
    var baseLayoutData = nextState.layoutDataList.find(function (layoutDataItem) {
      return layoutDataItem.segmentsExperienceId === nextState.defaultSegmentsExperienceId;
    });
    nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], baseLayoutData.layoutData);
    return nextState;
  }
  /**
   *
   * @param {object} state
   * @param {Array<{segmentsExperienceId: string}>} state.layoutDataList
   * @param {string} segmentsExperienceId
   * @returns {object}
   */

  function _removeLayoutDataItem(state, segmentsExperienceId) {
    var nextState = state;
    nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutDataList'], nextState.layoutDataList.filter(function (layoutDataItem) {
      return layoutDataItem.segmentsExperienceId !== segmentsExperienceId;
    }));
    return nextState;
  }
  /**
   * @param {object} state
   * @param {string} state.classNameId
   * @param {string} state.classPK
   * @param {string} state.defaultLanguageId
   * @param {string} state.defaultSegmentsExperienceId
   * @param {Array} state.layoutData
   * @param {Array<{segmentsExperienceId: string}>} state.layoutDataList
   * @param {object} action
   * @param {string} action.segmentsEntryId
   * @param {string} action.name
   * @param {string} action.type
   * @return {Promise}
   * @review
   */

  function createSegmentsExperienceReducer(state, action) {
    return new Promise(function (resolve, reject) {
      var nextState = state;

      if (action.type === _actions.CREATE_SEGMENTS_EXPERIENCE) {
        var _nextState = nextState,
            classNameId = _nextState.classNameId,
            classPK = _nextState.classPK;
        var name = action.name,
            segmentsEntryId = action.segmentsEntryId;
        var nameMap = JSON.stringify(_defineProperty({}, state.defaultLanguageId, name));
        Liferay.Service(CREATE_SEGMENTS_EXPERIENCE_URL, {
          active: true,
          classNameId: classNameId,
          classPK: classPK,
          nameMap: nameMap,
          segmentsEntryId: segmentsEntryId,
          serviceContext: JSON.stringify({
            scopeGroupId: themeDisplay.getScopeGroupId(),
            userId: themeDisplay.getUserId()
          })
        }, function (obj) {
          var active = obj.active,
              nameCurrentValue = obj.nameCurrentValue,
              priority = obj.priority,
              segmentsEntryId = obj.segmentsEntryId,
              segmentsExperienceId = obj.segmentsExperienceId;
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['availableSegmentsExperiences', segmentsExperienceId], {
            active: active,
            name: nameCurrentValue,
            priority: priority,
            segmentsEntryId: segmentsEntryId,
            segmentsExperienceId: segmentsExperienceId
          });

          _storeNewLayoutData(nextState, segmentsExperienceId).then(function (response) {
            _switchLayoutDataList(response, segmentsExperienceId).then(function (newState) {
              var nextNewState = (0, _FragmentsEditorUpdateUtils.setIn)(newState, ['segmentsExperienceId'], segmentsExperienceId);
              nextNewState = _provideDefaultValueToFragments(nextNewState, segmentsExperienceId);
              resolve(nextNewState);
            }).catch(function (e) {
              reject(e);
            });
          });
        }, function (error) {
          reject(error);
        });
      } else {
        resolve(nextState);
      }
    });
  }
  /**
   * Adds content to each fragmentEntryLink editable value
   * based on the defaultSegment values, or on the defaultValue
   *
   * @param {object} state
   * @param {string} state.defaultSegmentsExperienceId
   * @param {object} state.fragmentEntryLinks
   * @param {object} state.layoutData
   * @param {string} incomingExperienceId
   * @returns {object}
   */

  function _provideDefaultValueToFragments(state, incomingExperienceId) {
    var nextState = state;
    var defaultSegmentsExperienceKey = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(nextState.defaultSegmentsExperienceId);
    var incomingExperienceKey = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(incomingExperienceId);
    var newFragmentEntryLinks = Object.entries(nextState.fragmentEntryLinks).reduce(function (acc, entry) {
      var _entry = _slicedToArray(entry, 2),
          fragmentEntryLinkId = _entry[0],
          fragmentEntryLink = _entry[1];

      var newAcc = acc;

      if ((0, _FragmentsEditorGetUtils.getFragmentRowIndex)(nextState.layoutData.structure, fragmentEntryLinkId) !== -1) {
        var newEditableValues = Object.assign({}, fragmentEntryLink.editableValues, _defineProperty({}, _constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR, Object.entries(fragmentEntryLink.editableValues[_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR]).reduce(function (editableAcc, editableEntry) {
          var _editableEntry = _slicedToArray(editableEntry, 2),
              editableKey = _editableEntry[0],
              editableValue = _editableEntry[1];

          var newEditableValue = editableValue;

          if (editableValue[defaultSegmentsExperienceKey]) {
            newEditableValue = Object.assign({}, editableValue, _defineProperty({}, _prefixSegmentsExperienceId.prefixSegmentsExperienceId, (0, _FragmentsEditorGetUtils.deepClone)(editableValue[defaultSegmentsExperienceKey])));
          } else {
            newEditableValue = Object.assign({}, editableValue, _defineProperty({}, incomingExperienceKey, {
              defaultValue: editableValue.defaultValue
            }));
          }

          return Object.assign({}, editableAcc, _defineProperty({}, editableKey, newEditableValue));
        }, {})));
        var newFragmentEntryLink = Object.assign({}, fragmentEntryLink, {
          editableValues: newEditableValues
        });
        newAcc = Object.assign({}, acc, _defineProperty({}, fragmentEntryLinkId, newFragmentEntryLink));
      }

      return newAcc;
    }, {});
    return (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEntryLinks'], newFragmentEntryLinks);
  }
  /**
   * @param {object} state
   * @param {Array} state.availableSegmentsExperiences
   * @param {string} state.defaultSegmentsExperienceId
   * @param {{structure: Array}} state.layoutData
   * @param {array} state.layoutDataList
   * @param {string} state.segmentsExperienceId
   * @param {object} action
   * @param {string} action.segmentsExperienceId
   * @param {string} action.type
   * @returns {Promise}
   */

  function deleteSegmentsExperienceReducer(state, action) {
    return new Promise(function (resolve, reject) {
      try {
        var nextState = state;

        if (action.type === _actions.DELETE_SEGMENTS_EXPERIENCE) {
          var segmentsExperienceId = action.segmentsExperienceId;
          var fragmentEntryLinkIds = nextState.layoutData.structure.reduce(function (allFragmentEntryLinkIds, row) {
            return [].concat(_toConsumableArray(allFragmentEntryLinkIds), _toConsumableArray((0, _FragmentsEditorGetUtils.getRowFragmentEntryLinkIds)(row)));
          }, []).filter(function (fragmentEntryLinkId) {
            return !(0, _LayoutDataList.containsFragmentEntryLinkId)(nextState.layoutDataList, fragmentEntryLinkId, segmentsExperienceId);
          });
          (0, _FragmentsEditorFetchUtils.removeExperience)(segmentsExperienceId, fragmentEntryLinkIds).then(function () {
            var priority = nextState.availableSegmentsExperiences[segmentsExperienceId].priority;
            var availableSegmentsExperiences = Object.assign({}, nextState.availableSegmentsExperiences);
            delete availableSegmentsExperiences[segmentsExperienceId];
            var experienceIdToSelect = segmentsExperienceId === nextState.segmentsExperienceId ? nextState.defaultSegmentsExperienceId : nextState.segmentsExperienceId;
            Object.values(availableSegmentsExperiences).forEach(function (experience) {
              var segmentExperiencePriority = experience.priority;

              if (segmentExperiencePriority > priority) {
                experience.priority = segmentExperiencePriority - 1;
              }
            });
            nextState = _removeLayoutDataItem(nextState, segmentsExperienceId);
            nextState = _switchLayoutDataToDefault(nextState);
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['availableSegmentsExperiences'], availableSegmentsExperiences);
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['segmentsExperienceId'], experienceIdToSelect);
            resolve(nextState);
          }, function (error) {
            reject(error);
          });
        } else {
          resolve(nextState);
        }
      } catch (e) {
        reject(e);
      }
    });
  }
  /**
   *
   *
   * @export
   * @param {object} state
   * @param {object} state.layoutData
   * @param {object} state.layoutDataList
   * @param {string} state.segmentsExperienceId
   * @param {object} action
   * @param {string} action.segmentsExperienceId
   * @param {string} action.type
   * @returns {Promise}
   */

  function selectSegmentsExperienceReducer(state, action) {
    return new Promise(function (resolve, reject) {
      var nextState = state;

      if (action.type === _actions.SELECT_SEGMENTS_EXPERIENCE) {
        _switchLayoutDataList(nextState, action.segmentsExperienceId).then(function (newState) {
          var nextNewState = (0, _FragmentsEditorUpdateUtils.setIn)(newState, ['segmentsExperienceId'], action.segmentsExperienceId);
          resolve(nextNewState);
        }).catch(function (e) {
          reject(e);
        });
      } else {
        resolve(nextState);
      }
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.segmentsEntryId
   * @param {string} action.name
   * @param {string} action.segmentsExperienceId
   * @param {string} action.type
   * @return {Promise}
   * @review
   */

  function editSegmentsExperienceReducer(state, action) {
    return new Promise(function (resolve, reject) {
      var nextState = state;

      if (action.type === _actions.EDIT_SEGMENTS_EXPERIENCE) {
        var name = action.name,
            segmentsEntryId = action.segmentsEntryId,
            segmentsExperienceId = action.segmentsExperienceId;
        var nameMap = JSON.stringify(_defineProperty({}, state.defaultLanguageId, name));
        Liferay.Service(EDIT_SEGMENTS_EXPERIENCE_URL, {
          active: true,
          nameMap: nameMap,
          segmentsEntryId: segmentsEntryId,
          segmentsExperienceId: segmentsExperienceId
        }, function (obj) {
          var active = obj.active,
              nameCurrentValue = obj.nameCurrentValue,
              priority = obj.priority,
              segmentsEntryId = obj.segmentsEntryId,
              segmentsExperienceId = obj.segmentsExperienceId;
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['availableSegmentsExperiences', segmentsExperienceId], {
            active: active,
            name: nameCurrentValue,
            priority: priority,
            segmentsEntryId: segmentsEntryId,
            segmentsExperienceId: segmentsExperienceId
          });
          resolve(nextState);
        }, function (error) {
          reject(error);
        });
      } else {
        resolve(nextState);
      }
    });
  }
  /**
   *
   *
   * @param {object} state
   * @param {Array} state.availableSegmentsExperiences
   * @param {object} action
   * @param {('up' | 'down')} action.direction
   * @param {string} action.segmentsExperienceId
   * @param {number|string} action.priority
   * @param {string} action.type
   * @return {Promise}
   */

  function updateSegmentsExperiencePriorityReducer(state, action) {
    return new Promise(function (resolve, reject) {
      var nextState = state;

      if (action.type === _actions.UPDATE_SEGMENTS_EXPERIENCE_PRIORITY) {
        var direction = action.direction,
            oldPriority = action.priority,
            segmentsExperienceId = action.segmentsExperienceId;
        var priority = typeof oldPriority === 'number' ? oldPriority : parseInt(oldPriority, 10);
        var newPriority = direction === 'up' ? priority + 1 : priority - 1;
        Liferay.Service(UPDATE_SEGMENTS_EXPERIENCE_PRIORITY_URL, {
          newPriority: newPriority,
          segmentsExperienceId: segmentsExperienceId
        }).then(function () {
          var availableSegmentsExperiencesArray = Object.values(nextState.availableSegmentsExperiences);
          var subTargetExperience = availableSegmentsExperiencesArray.find(function (experience) {
            return experience.priority === newPriority;
          });
          var targetExperience = availableSegmentsExperiencesArray.find(function (experience) {
            return experience.priority === priority;
          });
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['availableSegmentsExperiences', targetExperience.segmentsExperienceId, 'priority'], newPriority);
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['availableSegmentsExperiences', subTargetExperience.segmentsExperienceId, 'priority'], priority);
          resolve(nextState);
        }).catch(function (error) {
          reject(error);
        });
      } else {
        resolve(nextState);
      }
    });
  }
  //# sourceMappingURL=segmentsExperiences.es.js.map
});
//# sourceMappingURL=segmentsExperiences.es.js.map