"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/reducers/rows.es", ['module', 'exports', 'require', '../actions/actions.es', '../utils/FragmentsEditorUpdateUtils.es', '../utils/LayoutDataList.es', '../utils/FragmentsEditorGetUtils.es', '../utils/FragmentsEditorFetchUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.addRowReducer = addRowReducer;
  exports.moveRowReducer = moveRowReducer;
  exports.removeRowReducer = removeRowReducer;
  exports.updateRowColumnsReducer = updateRowColumnsReducer;
  exports.updateRowColumnsNumberReducer = updateRowColumnsNumberReducer;
  exports.updateRowConfigReducer = void 0;

  var _actions = require("../actions/actions.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  var _LayoutDataList = require("../utils/LayoutDataList.es");

  var _FragmentsEditorGetUtils = require("../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  /**
   * @param {object} state
   * @param {object} action
   * @param {Array} action.layoutColumns
   * @param {string} action.type
   * @return {object}
   * @review
   */
  function addRowReducer(state, action) {
    var nextState = state;
    return new Promise(function (resolve) {
      if (action.type === _actions.ADD_ROW) {
        var position = (0, _FragmentsEditorGetUtils.getDropRowPosition)(nextState.layoutData.structure, nextState.dropTargetItemId, nextState.dropTargetBorder);
        var nextData = (0, _FragmentsEditorUpdateUtils.addRow)(action.layoutColumns, nextState.layoutData, position);
        (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextData, nextState.segmentsExperienceId).then(function () {
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], nextData);
          resolve(nextState);
        }).catch(function () {
          resolve(nextState);
        });
      } else {
        resolve(nextState);
      }
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.rowId
   * @param {string} action.targetBorder
   * @param {string} action.targetItemId
   * @param {object} action.type
   * @return {object}
   * @review
   */

  function moveRowReducer(state, action) {
    var nextState = state;
    return new Promise(function (resolve) {
      if (action.type === _actions.MOVE_ROW) {
        var nextData = _moveRow(action.rowId, nextState.layoutData, action.targetItemId, action.targetBorder);

        (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextData, nextState.segmentsExperienceId).then(function () {
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], nextData);
          resolve(nextState);
        }).catch(function () {
          resolve(nextState);
        });
      } else {
        resolve(nextState);
      }
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.rowId
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function removeRowReducer(state, action) {
    var nextState = state;
    return new Promise(function (resolve) {
      if (action.type === _actions.REMOVE_ROW) {
        nextState = (0, _FragmentsEditorUpdateUtils.updateIn)(nextState, ['layoutData', 'structure'], function (structure) {
          return (0, _FragmentsEditorUpdateUtils.remove)(structure, (0, _FragmentsEditorGetUtils.getRowIndex)(structure, action.rowId));
        }, []);
        var fragmentEntryLinkIds = (0, _FragmentsEditorGetUtils.getRowFragmentEntryLinkIds)(state.layoutData.structure[(0, _FragmentsEditorGetUtils.getRowIndex)(state.layoutData.structure, action.rowId)]).filter(function (fragmentEntryLinkId) {
          return !(0, _LayoutDataList.containsFragmentEntryLinkId)(nextState.layoutDataList, fragmentEntryLinkId, nextState.segmentsExperienceId || nextState.defaultSegmentsExperienceId);
        });
        fragmentEntryLinkIds.forEach(function (fragmentEntryLinkId) {
          nextState = (0, _FragmentsEditorUpdateUtils.updateWidgets)(nextState, fragmentEntryLinkId);
        });
        (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextState.layoutData, nextState.segmentsExperienceId).then(function () {
          return (0, _FragmentsEditorFetchUtils.removeFragmentEntryLinks)(nextState.layoutData, fragmentEntryLinkIds, nextState.segmentsExperienceId);
        }).then(function () {
          resolve(nextState);
        }).catch(function () {
          resolve(state);
        });
      } else {
        resolve(state);
      }
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {object} action.layoutData
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function updateRowColumnsReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.UPDATE_ROW_COLUMNS_ERROR || action.type === _actions.UPDATE_ROW_COLUMNS_LOADING) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], action.layoutData);
    }

    return nextState;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {Array} action.fragmentEntryLinkIdsToRemove
   * @param {object} action.layoutData
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function updateRowColumnsNumberReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.UPDATE_ROW_COLUMNS_NUMBER_SUCCESS) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], action.layoutData);
      action.fragmentEntryLinkIdsToRemove.forEach(function (fragmentEntryLinkId) {
        nextState = (0, _FragmentsEditorUpdateUtils.updateWidgets)(nextState, fragmentEntryLinkId);
      });
    }

    return nextState;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {object} action.config
   * @param {string} action.rowId
   * @param {string} action.type
   * @return {object}
   */

  var updateRowConfigReducer = function updateRowConfigReducer(state, action) {
    return new Promise(function (resolve) {
      var nextState = state;

      if (action.type === _actions.UPDATE_ROW_CONFIG) {
        var rowIndex = (0, _FragmentsEditorGetUtils.getRowIndex)(nextState.layoutData.structure, action.rowId);

        if (rowIndex === -1) {
          resolve(nextState);
        } else {
          Object.entries(action.config).forEach(function (entry) {
            var _entry = _slicedToArray(entry, 2),
                key = _entry[0],
                value = _entry[1];

            var configPath = ['layoutData', 'structure', rowIndex, 'config', key];
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, configPath, value);
          });
          (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextState.layoutData, nextState.segmentsExperienceId).then(function () {
            resolve(nextState);
          }).catch(function () {
            resolve(state);
          });
        }
      } else {
        resolve(nextState);
      }
    });
  };
  /**
   * Returns a new layoutData with the given row moved to the position
   * calculated with targetItemId and targetItemBorder
   * @param {string} rowId
   * @param {object} layoutData
   * @param {string} targetItemId
   * @param {string} targetItemBorder
   * @private
   * @return {object}
   * @review
   */

  exports.updateRowConfigReducer = updateRowConfigReducer;

  function _moveRow(rowId, layoutData, targetItemId, targetItemBorder) {
    var index = (0, _FragmentsEditorGetUtils.getRowIndex)(layoutData.structure, rowId);
    var row = layoutData.structure[index];
    var nextStructure = (0, _FragmentsEditorUpdateUtils.remove)(layoutData.structure, index);
    var position = (0, _FragmentsEditorGetUtils.getDropRowPosition)(nextStructure, targetItemId, targetItemBorder);
    nextStructure = (0, _FragmentsEditorUpdateUtils.add)(nextStructure, row, position);
    return (0, _FragmentsEditorUpdateUtils.setIn)(layoutData, ['structure'], nextStructure);
  }
  //# sourceMappingURL=rows.es.js.map
});
//# sourceMappingURL=rows.es.js.map