"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/reducers/placeholders.es", ['module', 'exports', 'require', '../actions/actions.es', '../utils/FragmentsEditorUpdateUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.updateActiveItemReducer = updateActiveItemReducer;
  exports.updateDropTargetReducer = updateDropTargetReducer;
  exports.updateHoveredItemReducer = updateHoveredItemReducer;

  var _actions = require("../actions/actions.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  /**
   * Updates active element data with the information sent.
   * @param {!object} state
   * @param {object} action
   * @param {string} action.activeItemId
   * @param {string} action.activeItemType
   * @param {string} action.type
   * @return {object}
   * @review
   */
  function updateActiveItemReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.CLEAR_ACTIVE_ITEM) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['activeItemId'], null);
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['activeItemType'], null);
    } else if (action.type === _actions.UPDATE_ACTIVE_ITEM) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['activeItemId'], action.activeItemId);
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['activeItemType'], action.activeItemType);
    }

    return nextState;
  }
  /**
   * Updates drop target element with the information sent.
   * @param {!object} state
   * @param {object} action
   * @param {string} action.dropTargetBorder
   * @param {string} action.dropTargetItemId
   * @param {string} action.dropTargetItemType
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function updateDropTargetReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.CLEAR_DROP_TARGET) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['dropTargetBorder'], null);
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['dropTargetItemId'], null);
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['dropTargetItemType'], null);
    } else if (action.type === _actions.UPDATE_DROP_TARGET) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['dropTargetBorder'], action.dropTargetBorder);
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['dropTargetItemId'], action.dropTargetItemId);
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['dropTargetItemType'], action.dropTargetItemType);
    }

    return nextState;
  }
  /**
   * Updates hovered element data with the information sent.
   * @param {object} state
   * @param {object} action
   * @param {string} action.hoveredItemId
   * @param {string} action.hoveredItemType
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function updateHoveredItemReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.CLEAR_HOVERED_ITEM) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['hoveredItemId'], null);
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['hoveredItemType'], null);
    } else if (action.type === _actions.UPDATE_HOVERED_ITEM) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['hoveredItemId'], action.hoveredItemId);
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['hoveredItemType'], action.hoveredItemType);
    }

    return nextState;
  }
  //# sourceMappingURL=placeholders.es.js.map
});
//# sourceMappingURL=placeholders.es.js.map