"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/reducers/dialogs.es", ['module', 'exports', 'require', '../actions/actions.es', '../utils/FragmentsEditorUpdateUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.hideMappingDialogReducer = hideMappingDialogReducer;
  exports.hideMappingTypeDialogReducer = hideMappingTypeDialogReducer;
  exports.openAssetTypeDialogReducer = openAssetTypeDialogReducer;
  exports.openMappingFieldsDialogReducer = openMappingFieldsDialogReducer;
  exports.selectMappeableTypeReducer = selectMappeableTypeReducer;

  var _actions = require("../actions/actions.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.type
   * @return {object}
   * @review
   */
  function openAssetTypeDialogReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.OPEN_ASSET_TYPE_DIALOG) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['selectMappingTypeDialogVisible'], true);
    }

    return nextState;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.editableId
   * @param {string} action.editableType
   * @param {string} action.fragmentEntryLinkId
   * @param {string} action.mappedFieldId
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function openMappingFieldsDialogReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.OPEN_MAPPING_FIELDS_DIALOG) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['selectMappingDialogEditableId'], action.editableId);
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['selectMappingDialogEditableType'], action.editableType);
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['selectMappingDialogMappedFieldId'], action.mappedFieldId);
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['selectMappingDialogFragmentEntryLinkId'], action.fragmentEntryLinkId);

      if (nextState.selectedMappingTypes && nextState.selectedMappingTypes.type) {
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['selectMappingDialogVisible'], true);
      } else {
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['selectMappingTypeDialogVisible'], true);
      }
    }

    return nextState;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {{}} action.mappingTypes
   * @param {string} action.selectedMappingSubtypeId
   * @param {string} action.selectedMappingTypeId
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function selectMappeableTypeReducer(state, action) {
    return new Promise(function (resolve) {
      var nextState = state;

      if (action.type === _actions.SELECT_MAPPEABLE_TYPE) {
        _selectMappingType(nextState.classPK, nextState.portletNamespace, action.selectedMappingSubtypeId, action.selectedMappingTypeId, nextState.updateLayoutPageTemplateEntryAssetTypeURL).then(function () {
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['selectedMappingTypes'], action.mappingTypes);

          if (nextState.selectMappingDialogFragmentEntryLinkId && nextState.selectMappingDialogEditableId) {
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['selectMappingDialogVisible'], true);
          }

          resolve(nextState);
        }).catch(function () {
          resolve(nextState);
        });
      } else {
        resolve(nextState);
      }
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function hideMappingDialogReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.HIDE_MAPPING_DIALOG) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['selectMappingDialogVisible'], false);
    }

    return nextState;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function hideMappingTypeDialogReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.HIDE_MAPPING_TYPE_DIALOG) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['selectMappingTypeDialogVisible'], false);
    }

    return nextState;
  }
  /**
   * @param {string} classPK
   * @param {string} portletNamespace
   * @param {string} selectedMappingSubtypeId
   * @param {string} selectedMappingTypeId
   * @param {string} updateLayoutPageTemplateEntryAssetTypeURL
   * @return {object}
   * @review
   */

  function _selectMappingType(classPK, portletNamespace, selectedMappingSubtypeId, selectedMappingTypeId, updateLayoutPageTemplateEntryAssetTypeURL) {
    var formData = new FormData();
    formData.append("".concat(portletNamespace, "classTypeId"), selectedMappingSubtypeId);
    formData.append("".concat(portletNamespace, "classNameId"), selectedMappingTypeId);
    formData.append("".concat(portletNamespace, "classPK"), classPK);
    return fetch(updateLayoutPageTemplateEntryAssetTypeURL, {
      body: formData,
      credentials: 'include',
      method: 'POST'
    }).then(function (response) {
      return response.json();
    });
  }
  //# sourceMappingURL=dialogs.es.js.map
});
//# sourceMappingURL=dialogs.es.js.map