"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/mapping_type/SelectMappingTypeForm.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', 'frontend-js-web/liferay/PortletBase.es', 'frontend-js-metal-web$metal-soy', '../../store/ConnectedComponent.es', '../../actions/actions.es', '../../utils/FragmentsEditorUpdateUtils.es', './SelectMappingTypeForm.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.SelectMappingTypeForm = exports.ConnectedSelectMappingTypeForm = void 0;

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _PortletBase2 = _interopRequireDefault(require("frontend-js-web/liferay/PortletBase.es"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _ConnectedComponent = _interopRequireDefault(require("../../store/ConnectedComponent.es"));

  var _actions = require("../../actions/actions.es");

  var _FragmentsEditorUpdateUtils = require("../../utils/FragmentsEditorUpdateUtils.es");

  var _SelectMappingTypeForm = _interopRequireDefault(require("./SelectMappingTypeForm.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * SelectMappingTypeForm
   */
  var SelectMappingTypeForm =
  /*#__PURE__*/
  function (_PortletBase) {
    _inherits(SelectMappingTypeForm, _PortletBase);

    function SelectMappingTypeForm() {
      _classCallCheck(this, SelectMappingTypeForm);

      return _possibleConstructorReturn(this, _getPrototypeOf(SelectMappingTypeForm).apply(this, arguments));
    }

    _createClass(SelectMappingTypeForm, [{
      key: "prepareStateForRender",

      /**
        * @inheritdoc
        * @review
        */
      value: function prepareStateForRender(state) {
        var nextState = state;

        if (state.selectedMappingTypes) {
          if (state.selectedMappingTypes.type) {
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_mappingTypes'], [state.selectedMappingTypes.type]);
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_selectedMappingTypeId'], state.selectedMappingTypes.type.id);
          }

          if (state.selectedMappingTypes.subtype) {
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_mappingSubtypes'], [state.selectedMappingTypes.subtype]);
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_selectedMappingSubtypeId'], state.selectedMappingTypes.subtype.id);
          }
        }

        return nextState;
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered() {
        if (!this._mappingTypes) {
          this._loadMappingTypes();
        }

        if (this._mappingTypes && this._mappingTypes.length === 1 && !this._selectedMappingTypeId) {
          this._handleMappingTypeSelectChange();
        }

        if (this._mappingSubtypes && this._mappingSubtypes.length === 1 && !this._selectedMappingSubtypeId) {
          this._handleMappingSubtypeSelectChange();
        }
      }
      /**
       * Close asset type selection dialog
       * @private
       * @review
       */

    }, {
      key: "_handleCancelButtonClick",
      value: function _handleCancelButtonClick() {
        this._mappingSubtypes = [];
        this._mappingTypes = null;
        this._selectedMappingTypeId = '';
        this._selectedMappingSubtypeId = '';
        this.store.dispatch({
          type: _actions.HIDE_MAPPING_TYPE_DIALOG
        });
      }
      /**
       * Callback executed when a mapping subtype has been selected.
       * @private
       * @review
       */

    }, {
      key: "_handleMappingSubtypeSelectChange",
      value: function _handleMappingSubtypeSelectChange() {
        var selectInput = this.refs.selectMappingSubtype;

        var mappingSubtype = this._mappingSubtypes.find(function (_mappingSubtype) {
          return _mappingSubtype.id === selectInput.value;
        });

        this._selectedMappingSubtypeId = mappingSubtype.id;
      }
      /**
       * Callback executed when a mapping type has been selected.
       * It loads a mapping subtype list if necessary.
       * @private
       * @review
       */

    }, {
      key: "_handleMappingTypeSelectChange",
      value: function _handleMappingTypeSelectChange() {
        var selectInput = this.refs.selectMappingType;

        var mappingType = this._mappingTypes.find(function (_mappingType) {
          return _mappingType.id === selectInput.value;
        });

        this._selectedMappingTypeId = mappingType.id;
        this._mappingSubtypes = [];

        this._loadMappingSubtypes();
      }
      /**
       * Sends selected mapping type and subtype to the server
       * and closes this dialog.
       * @private
       * @review
       */

    }, {
      key: "_handleSubmitButtonClick",
      value: function _handleSubmitButtonClick() {
        var _this = this;

        var mappingTypes = {};

        var subtype = this._mappingSubtypes.find(function (_subtype) {
          return _subtype.id === _this._selectedMappingSubtypeId;
        });

        var type = this._mappingTypes.find(function (_type) {
          return _type.id === _this._selectedMappingTypeId;
        });

        if (subtype) {
          mappingTypes.subtype = {
            id: this._selectedMappingSubtypeId,
            label: subtype.label
          };
        }

        if (type) {
          mappingTypes.type = {
            id: this._selectedMappingTypeId,
            label: type.label
          };
        }

        this.store.dispatch({
          type: _actions.HIDE_MAPPING_TYPE_DIALOG
        }).dispatch({
          mappingTypes: mappingTypes,
          selectedMappingSubtypeId: this._selectedMappingSubtypeId,
          selectedMappingTypeId: this._selectedMappingTypeId,
          type: _actions.SELECT_MAPPEABLE_TYPE
        }).dispatch({
          lastSaveDate: new Date(),
          type: _actions.UPDATE_LAST_SAVE_DATE
        });
      }
      /**
       * Load a list of mapping subtypes.
       * @private
       * @return {Promise}
       * @review
       */

    }, {
      key: "_loadMappingSubtypes",
      value: function _loadMappingSubtypes() {
        var _this2 = this;

        this._mappingSubtypes = null;
        return this.fetch(this.getInfoClassTypesURL, {
          classNameId: this._selectedMappingTypeId
        }).then(function (response) {
          return response.json();
        }).then(function (response) {
          _this2._mappingSubtypes = response;
        });
      }
      /**
       * Load a list of mapping types.
       * @private
       * @return {Promise}
       * @review
       */

    }, {
      key: "_loadMappingTypes",
      value: function _loadMappingTypes() {
        var _this3 = this;

        return this.fetch(this.getInfoDisplayContributorsURL, {}).then(function (response) {
          return response.json();
        }).then(function (response) {
          _this3._mappingTypes = response;
        });
      }
    }]);

    return SelectMappingTypeForm;
  }(_PortletBase2.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.SelectMappingTypeForm = SelectMappingTypeForm;
  SelectMappingTypeForm.STATE = {
    /**
     * List of available mapping types
     * @default null
     * @instance
     * @memberOf SelectMappingTypeForm
     * @private
     * @review
     * @type {Array<{
     *   id: !string,
     *   label: !string
     * }>}
     */
    _mappingTypes: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      id: _metalState.Config.string().required(),
      label: _metalState.Config.string().required()
    })).value(null),

    /**
     * List of available mapping subtypes
     * @default null
     * @instance
     * @memberOf SelectMappingTypeForm
     * @private
     * @review
     * @type {Array<{
     *   id: !string,
     *   label: !string
     * }>}
     */
    _mappingSubtypes: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      id: _metalState.Config.string().required(),
      label: _metalState.Config.string().required()
    })).value([]),

    /**
     * String with the selected mapping type id
     * @default ''
     * @instance
     * @memberOf SelectMappingTypeForm
     * @private
     * @review
     * @type {string}
     */
    _selectedMappingTypeId: _metalState.Config.string().internal().value(''),

    /**
     * String with the selected mapping subtype id
     * @default ''
     * @instance
     * @memberOf SelectMappingTypeForm
     * @private
     * @review
     * @type {string}
     */
    _selectedMappingSubtypeId: _metalState.Config.string().internal().value('')
  };
  var ConnectedSelectMappingTypeForm = (0, _ConnectedComponent.default)(SelectMappingTypeForm, ['classPK', 'getInfoClassTypesURL', 'getInfoDisplayContributorsURL', 'portletNamespace', 'savingChanges', 'selectedMappingTypes']);
  exports.ConnectedSelectMappingTypeForm = ConnectedSelectMappingTypeForm;

  _metalSoy.default.register(ConnectedSelectMappingTypeForm, _SelectMappingTypeForm.default);

  var _default = ConnectedSelectMappingTypeForm;
  exports.default = _default;
  //# sourceMappingURL=SelectMappingTypeForm.es.js.map
});
//# sourceMappingURL=SelectMappingTypeForm.es.js.map