"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/fragment_entry_link/FragmentStyleEditor.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', '../../store/store.es', './FragmentEditableFieldTooltip.es', '../fragment_processors/FragmentStyleEditors.es', '../../actions/actions.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.FragmentStyleEditor = void 0;

  var _metalState = _interopRequireWildcard(require("frontend-js-metal-web$metal-state"));

  var _store = require("../../store/store.es");

  var _FragmentEditableFieldTooltip = _interopRequireDefault(require("./FragmentEditableFieldTooltip.es"));

  var _FragmentStyleEditors = _interopRequireDefault(require("../fragment_processors/FragmentStyleEditors.es"));

  var _actions = require("../../actions/actions.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj.default = obj;return newObj;
    }
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Creates a Fragment Style Editor component.
   */
  var FragmentStyleEditor =
  /*#__PURE__*/
  function (_State) {
    _inherits(FragmentStyleEditor, _State);

    /**
     * @inheritDoc
     */
    function FragmentStyleEditor() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, FragmentStyleEditor);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(FragmentStyleEditor)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.disposeStyleTooltip = _this.disposeStyleTooltip.bind(_assertThisInitialized(_this));
      _this._handleButtonClick = _this._handleButtonClick.bind(_assertThisInitialized(_this));
      _this._handleChangeStyle = _this._handleChangeStyle.bind(_assertThisInitialized(_this));
      _this._handleNodeClick = _this._handleNodeClick.bind(_assertThisInitialized(_this));

      _this.syncType();

      _this._onNodeClickHandler = document.addEventListener('click', _this._handleNodeClick);
      return _this;
    }
    /**
     * @inheritdoc
     * @review
     */

    _createClass(FragmentStyleEditor, [{
      key: "dispose",
      value: function dispose() {
        document.removeEventListener('click', this._handleNodeClick);

        _get(_getPrototypeOf(FragmentStyleEditor.prototype), "dispose", this).call(this);
      }
      /**
       * Callback executed when a type property changes. This updates the fragment
       * style editor being used.
       */

    }, {
      key: "syncType",
      value: function syncType() {
        this._styleEditor = _FragmentStyleEditors.default[this.type];
      }
      /**
       * Handles click events for styled nodes.
       * @param {Event} event The node click.
       * @private
       */

    }, {
      key: "_handleNodeClick",
      value: function _handleNodeClick(event) {
        if (this.node && (event.target === this.node || this.node.contains(event.target))) {
          event.preventDefault();
          event.stopPropagation();

          if (this._tooltip) {
            this.disposeStyleTooltip();
          } else if (this._styleEditor) {
            this.emit('openTooltip');
            this._tooltip = new _FragmentEditableFieldTooltip.default({
              alignElement: this.node,
              buttons: this._styleEditor.getButtons(this.showMapping),
              store: this.store
            });

            this._tooltip.on('buttonClick', this._handleButtonClick);
          }
        } else if (this._tooltip) {
          this.disposeStyleTooltip();
        }
      }
      /**
       * Handles click events for tooltip buttons.
       * @param {{buttonId: string}} event The tooltip button click.
       */

    }, {
      key: "_handleButtonClick",
      value: function _handleButtonClick(event) {
        if (this._styleEditor) {
          this._styleEditor.init(event.buttonId, this.node, this.portletNamespace, this.editorsOptions, this._handleChangeStyle, this.disposeStyleTooltip);
        }
      }
      /**
       * Handles a change style event.
       * @param {Object} event
       * @param {string} event.eventType
       */

    }, {
      key: "_handleChangeStyle",
      value: function _handleChangeStyle(event) {
        if (event.eventType === 'map') {
          this.store.dispatch({
            editableId: "".concat(this.selectorText, " ").concat(event.name),
            editableType: event.type,
            fragmentEntryLinkId: this.fragmentEntryLinkId,
            mappedFieldId: '',
            type: _actions.OPEN_MAPPING_FIELDS_DIALOG
          });
          this.disposeStyleTooltip();
        } else {
          this.emit('styleChanged', {
            name: "".concat(this.selectorText, " ").concat(event.name),
            value: event.value
          });
        }
      }
      /**
       * Disposes of the style tooltip if it exists.
       */

    }, {
      key: "disposeStyleTooltip",
      value: function disposeStyleTooltip() {
        if (this._tooltip) {
          this._tooltip.dispose();

          this._tooltip = null;
        }
      }
    }]);

    return FragmentStyleEditor;
  }(_metalState.default);
  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  exports.FragmentStyleEditor = FragmentStyleEditor;
  FragmentStyleEditor.STATE = {
    /**
     * CSS rules text.
     * @default undefined
     * @instance
     * @memberOf FragmentStyleEditor
     * @type {!string}
     */
    cssText: _metalState.Config.string().required(),

    /**
     * Options that are sent to the editors.
     * @default undefined
     * @instance
     * @memberOf FragmentStyleEditor
     * @type {!object}
     */
    editorsOptions: _metalState.Config.object().required(),

    /**
     * Fragment entry link ID.
     * @default undefined
     * @instance
     * @memberOf FragmentStyleEditor
     * @type {!string}
     */
    fragmentEntryLinkId: _metalState.Config.string().required(),

    /**
     * Node to instantiate the style editor on.
     * @instance
     * @memberOf FragmentStyleEditor
     * @type {HTMLElement}
     */
    node: _metalState.Config.internal().object(),

    /**
     * Portlet namespace.
     * @default undefined
     * @instance
     * @memberOf FragmentStyleEditor
     * @type {!string}
     */
    portletNamespace: _metalState.Config.string().required(),

    /**
     * CSS selector text.
     * @default undefined
     * @instance
     * @memberOf FragmentStyleEditor
     * @type {!string}
     */
    selectorText: _metalState.Config.string().required(),

    /**
     * If <code>true</code>, the mapping is activated.
     * @default undefined
     * @instance
     * @memberOf FragmentStyleEditor
     * @type {!boolean}
     */
    showMapping: _metalState.Config.bool().required(),

    /**
     * Store instance.
     * @default undefined
     * @instance
     * @memberOf FragmentStyleEditor
     * @type {Store}
     */
    store: _metalState.Config.instanceOf(_store.Store),

    /**
     * Style editor type.
     * @default undefined
     * @instance
     * @memberOf FragmentStyleEditor
     * @type {!string}
     */
    type: _metalState.Config.string().required(),

    /**
     * Style editor instance being used.
     * @default null
     * @instance
     * @memberOf FragmentStyleEditor
     * @type {FragmentStyleEditors}
     */
    _styleEditor: _metalState.Config.internal().object().value(null)
  };
  var _default = FragmentStyleEditor;
  exports.default = _default;
  //# sourceMappingURL=FragmentStyleEditor.es.js.map
});
//# sourceMappingURL=FragmentStyleEditor.es.js.map