"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/fragment_entry_link/FragmentEditableField.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', 'frontend-js-web/liferay/PortletBase.es', 'frontend-js-metal-web$metal-soy', '../floating_toolbar/image_properties/FloatingToolbarImagePropertiesPanel.es', '../floating_toolbar/link/FloatingToolbarLinkPanel.es', '../floating_toolbar/mapping/FloatingToolbarMappingPanel.es', '../floating_toolbar/text_properties/FloatingToolbarTextPropertiesPanel.es', './FragmentEditableFieldTooltip.es', '../../actions/actions.es', '../../utils/constants', '../../actions/saveChanges.es', '../../store/ConnectedComponent.es', '../../utils/FragmentsEditorGetUtils.es', '../../utils/prefixSegmentsExperienceId.es', '../../utils/FragmentsEditorUpdateUtils.es', '../../utils/FragmentsEditorComponentUtils.es', '../../actions/updateEditableValue.es', '../floating_toolbar/FloatingToolbar.es', '../fragment_processors/FragmentProcessors.es', './FragmentEditableField.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.FragmentEditableField = exports.ConnectedFragmentEditableField = void 0;

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _PortletBase2 = _interopRequireDefault(require("frontend-js-web/liferay/PortletBase.es"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  require("../floating_toolbar/image_properties/FloatingToolbarImagePropertiesPanel.es");

  require("../floating_toolbar/link/FloatingToolbarLinkPanel.es");

  require("../floating_toolbar/mapping/FloatingToolbarMappingPanel.es");

  require("../floating_toolbar/text_properties/FloatingToolbarTextPropertiesPanel.es");

  require("./FragmentEditableFieldTooltip.es");

  var _actions = require("../../actions/actions.es");

  var _constants = require("../../utils/constants");

  var _saveChanges = require("../../actions/saveChanges.es");

  var _ConnectedComponent = require("../../store/ConnectedComponent.es");

  var _FragmentsEditorGetUtils = require("../../utils/FragmentsEditorGetUtils.es");

  var _prefixSegmentsExperienceId = require("../../utils/prefixSegmentsExperienceId.es");

  var _FragmentsEditorUpdateUtils = require("../../utils/FragmentsEditorUpdateUtils.es");

  var _FragmentsEditorComponentUtils = require("../../utils/FragmentsEditorComponentUtils.es");

  var _updateEditableValue = require("../../actions/updateEditableValue.es");

  var _FloatingToolbar = _interopRequireDefault(require("../floating_toolbar/FloatingToolbar.es"));

  var _FragmentProcessors = _interopRequireDefault(require("../fragment_processors/FragmentProcessors.es"));

  var _FragmentEditableField = _interopRequireDefault(require("./FragmentEditableField.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * FragmentEditableField
   */
  var FragmentEditableField =
  /*#__PURE__*/
  function (_PortletBase) {
    _inherits(FragmentEditableField, _PortletBase);

    function FragmentEditableField() {
      _classCallCheck(this, FragmentEditableField);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentEditableField).apply(this, arguments));
    }

    _createClass(FragmentEditableField, [{
      key: "created",

      /**
       * @inheritDoc
       * @review
       */
      value: function created() {
        this._handleEditableChanged = this._handleEditableChanged.bind(this);
        this._handleEditableDestroyed = this._handleEditableDestroyed.bind(this);
        this._handleFloatingToolbarButtonClicked = this._handleFloatingToolbarButtonClicked.bind(this);
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._destroyProcessors();

        this._disposeFloatingToolbar();
      }
      /**
       * @inheritDoc
       * @param {!object} state
       * @returns {object}
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        var defaultSegmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.defaultSegmentsExperienceId);
        var segmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.segmentsExperienceId);
        var segmentedValue = this.editableValues[segmentsExperienceId] || this.editableValues[defaultSegmentsExperienceId] || this.editableValues;
        var translatedValue = segmentedValue[this.languageId] || segmentedValue[this.defaultLanguageId];

        var mapped = FragmentEditableField._isMapped(this.editableValues);

        var value = mapped ? this._mappedFieldValue || this.editableValues.defaultValue : translatedValue || this.editableValues.defaultValue;
        var processor = _FragmentProcessors.default[this.type] || _FragmentProcessors.default.fallback;

        var content = _metalSoy.default.toIncDom(processor.render(this.content, value, this.editableValues));

        var highlighted = FragmentEditableField._isHighlighted(state.activeItemId, state.activeItemType, state.fragmentEntryLinkId, state.hoveredItemId, state.hoveredItemType, state.layoutData.structure);

        var itemId = this._getItemId();

        var translated = !mapped && Boolean(segmentedValue[this.languageId]);
        var nextState = state;
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_highlighted'], highlighted);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_mapped'], mapped);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_translated'], translated);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['content'], content);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['itemId'], itemId);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['itemTypes'], _constants.FRAGMENTS_EDITOR_ITEM_TYPES);
        return nextState;
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered() {
        if (this._getItemId() === this.activeItemId && this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable) {
          this._createFloatingToolbar();
        } else {
          this._disposeFloatingToolbar();
        }

        if (this._getItemId() === this.fragmentEditorClear) {
          this._clearEditor();

          this._handleEditableDestroyed();
        } else if (this._getItemId() === this.fragmentEditorEnabled) {
          this._enableEditor();

          this._disposeFloatingToolbar();
        }
      }
      /**
       * @inheritDoc
       * @return {boolean}
       * @review
       */

    }, {
      key: "shouldUpdate",
      value: function shouldUpdate(changes) {
        return this._getItemId() === this.fragmentEditorEnabled ? (0, _FragmentsEditorComponentUtils.shouldUpdateOnChangeProperties)(changes, ['fragmentEditorEnabled', 'languageId', 'segmentsExperienceId']) : (0, _FragmentsEditorComponentUtils.shouldUpdatePureComponent)(changes);
      }
      /**
       * Handle editableValues changed
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncEditableValues",
      value: function syncEditableValues() {
        this._loadMappedFieldLabel();

        this._updateMappedFieldValue();
      }
      /**
       * Handle getAssetFieldValueURL changed
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncGetAssetFieldValueURL",
      value: function syncGetAssetFieldValueURL() {
        this._updateMappedFieldValue();
      }
      /**
       * Clears the corresponding editor
       * @private
       * @review
       */

    }, {
      key: "_clearEditor",
      value: function _clearEditor() {
        this._handleEditableChanged('');

        this.store.dispatch({
          itemId: '',
          type: _actions.CLEAR_FRAGMENT_EDITOR
        });
      }
      /**
       * Creates a new instance of FloatingToolbar
       * @private
       * @review
       */

    }, {
      key: "_createFloatingToolbar",
      value: function _createFloatingToolbar() {
        var processor = _FragmentProcessors.default[this.type] || _FragmentProcessors.default.fallback;
        var config = {
          anchorElement: this.element,
          buttons: processor.getFloatingToolbarButtons(this.editableValues),
          classes: this.editableValues.mappedField || this.editableValues.fieldId ? 'fragments-editor__floating-toolbar--mapped-field' : '',
          events: {
            buttonClicked: this._handleFloatingToolbarButtonClicked
          },
          item: {
            editableId: this.editableId,
            editableValues: this.editableValues,
            fragmentEntryLinkId: this.fragmentEntryLinkId,
            type: this.type
          },
          itemId: this._getItemId(),
          itemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable,
          portalElement: document.body,
          store: this.store
        };

        if (this._floatingToolbar) {
          this._floatingToolbar.setState(config);
        } else {
          this._floatingToolbar = new _FloatingToolbar.default(config);
        }
      }
      /**
       * Call destroy method on all processors
       * @private
       * @review
       */

    }, {
      key: "_destroyProcessors",
      value: function _destroyProcessors() {
        Object.values(_FragmentProcessors.default).forEach(function (fragmentProcessor) {
          return fragmentProcessor.destroy();
        });
      }
      /**
       * Disposes an existing instance of FloatingToolbar
       * @private
       * @review
       */

    }, {
      key: "_disposeFloatingToolbar",
      value: function _disposeFloatingToolbar() {
        if (this._floatingToolbar) {
          this._floatingToolbar.dispose();

          this._floatingToolbar = null;
        }
      }
      /**
       * Enables the corresponding editor
       * @private
       * @review
       */

    }, {
      key: "_enableEditor",
      value: function _enableEditor() {
        var _ref = _FragmentProcessors.default[this.type] || _FragmentProcessors.default.fallback,
            init = _ref.init;

        init(this.refs.editable, this.fragmentEntryLinkId, this.portletNamespace, this.processorsOptions, this._handleEditableChanged, this._handleEditableDestroyed);
      }
      /**
       * @private
       * @return {string} Valid FragmentsEditor itemId for it's
       * 	fragmentEntryLinkId and editableId
       * @review
       */

    }, {
      key: "_getItemId",
      value: function _getItemId() {
        return "".concat(this.fragmentEntryLinkId, "-").concat(this.editableId);
      }
      /**
       * Handle editable click event
       * @private
       * @review
       */

    }, {
      key: "_handleEditableClick",
      value: function _handleEditableClick() {
        if (this._preventEditableClick) {
          this._preventEditableClick = false;
        } else {
          this.store.dispatch({
            itemId: "".concat(this.fragmentEntryLinkId, "-").concat(this.editableId),
            type: _actions.ENABLE_FRAGMENT_EDITOR
          });
        }
      }
      /**
       * Handle editable focus event
       * @private
       * @review
       */

    }, {
      key: "_handleEditableFocus",
      value: function _handleEditableFocus() {
        this._preventEditableClick = true;
      }
      /**
       * Callback executed when the exiting editor is destroyed
       * @private
       * @review
       */

    }, {
      key: "_handleEditableDestroyed",
      value: function _handleEditableDestroyed() {
        this.store.dispatch({
          type: _actions.DISABLE_FRAGMENT_EDITOR
        });
      }
      /**
       * Callback executed when an editable value changes
       * @param {string} newValue
       * @private
       */

    }, {
      key: "_handleEditableChanged",
      value: function _handleEditableChanged(newValue) {
        var editableValueSegmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.segmentsExperienceId) || (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.defaultSegmentsExperienceId);

        if (this.type === 'image') {
          this.store.dispatch((0, _saveChanges.enableSavingChangesStatusAction)()).dispatch({
            config: _defineProperty({}, _constants.EDITABLE_FIELD_CONFIG_KEYS.imageSource, newValue),
            editableId: this.editableId,
            fragmentEntryLinkId: this.fragmentEntryLinkId,
            type: _actions.UPDATE_CONFIG_ATTRIBUTES
          }).dispatch((0, _saveChanges.updateLastSaveDateAction)()).dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
        }

        this.store.dispatch((0, _updateEditableValue.updateEditableValueAction)(this.fragmentEntryLinkId, this.editableId, this.languageId || _constants.DEFAULT_LANGUAGE_ID_KEY, newValue, editableValueSegmentsExperienceId));
      }
      /**
       * Callback executed when an floating toolbar button is clicked
       * @param {Event} event
       * @param {Object} data
       * @private
       */

    }, {
      key: "_handleFloatingToolbarButtonClicked",
      value: function _handleFloatingToolbarButtonClicked(event, data) {
        var panelId = data.panelId,
            type = data.type;

        if (type === 'editor') {
          this.store.dispatch({
            itemId: this._getItemId(),
            type: _actions.ENABLE_FRAGMENT_EDITOR
          });
        } else if (type === 'panel' && panelId === _constants.FLOATING_TOOLBAR_BUTTONS.map.panelId && this.mappingFieldsURL && !this.selectedMappingTypes.type) {
          event.preventDefault();
          this.store.dispatch({
            type: _actions.OPEN_ASSET_TYPE_DIALOG
          });
        }
      }
      /**
       * Load mapped field label
       * @private
       * @review
       */

    }, {
      key: "_loadMappedFieldLabel",
      value: function _loadMappedFieldLabel() {
        var _this = this;

        var promise;
        var mappedFieldId;

        if (this.editableValues.mappedField && this.selectedMappingTypes.type) {
          var data = {
            classNameId: this.selectedMappingTypes.type.id
          };

          if (this.selectedMappingTypes.subtype) {
            data.classTypeId = this.selectedMappingTypes.subtype.id;
          }

          mappedFieldId = this.editableValues.mappedField;
          promise = this.fetch(this.mappingFieldsURL, data);
        } else if (this.editableValues.classNameId && this.editableValues.classPK && this.editableValues.fieldId && this.getAssetMappingFieldsURL) {
          mappedFieldId = this.editableValues.fieldId;
          promise = this.fetch(this.getAssetMappingFieldsURL, {
            classNameId: this.editableValues.classNameId,
            classPK: this.editableValues.classPK
          });
        }

        if (promise) {
          promise.then(function (response) {
            return response.json();
          }).then(function (response) {
            var field = response.find(function (field) {
              return field.key === mappedFieldId;
            });

            if (field) {
              _this._mappedFieldLabel = field.label;
            }
          });
        }
      }
      /**
       * Updates mapped field value
       * @private
       * @review
       */

    }, {
      key: "_updateMappedFieldValue",
      value: function _updateMappedFieldValue() {
        var _this2 = this;

        if (this.getAssetFieldValueURL && FragmentEditableField._isMappedToAssetEntry(this.editableValues)) {
          this.fetch(this.getAssetFieldValueURL, {
            classNameId: this.editableValues.classNameId,
            classPK: this.editableValues.classPK,
            fieldId: this.editableValues.fieldId
          }).then(function (response) {
            return response.json();
          }).then(function (response) {
            var fieldValue = response.fieldValue;

            if (fieldValue) {
              if (_this2.type === 'image' && fieldValue.url) {
                _this2._mappedFieldValue = fieldValue.url;
              } else {
                _this2._mappedFieldValue = fieldValue;
              }
            }
          });
        }
      }
    }], [{
      key: "_isHighlighted",

      /**
       * Checks if the given editable should be highlighted
       * @param {string} activeItemId
       * @param {string} activeItemType
       * @param {string} hoveredItemId
       * @param {string} hoveredItemType
       * @param {object} structure
       * @private
       * @return {boolean}
       * @review
       */
      value: function _isHighlighted(activeItemId, activeItemType, fragmentEntryLinkId, hoveredItemId, hoveredItemType, structure) {
        var fragmentInActivePath = (0, _FragmentsEditorGetUtils.itemIsInPath)((0, _FragmentsEditorGetUtils.getItemPath)(activeItemId, activeItemType, structure), fragmentEntryLinkId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment) && activeItemType !== _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable;

        var fragmentInHoveredPath = (0, _FragmentsEditorGetUtils.itemIsInPath)((0, _FragmentsEditorGetUtils.getItemPath)(hoveredItemId, hoveredItemType, structure), fragmentEntryLinkId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment);
        return fragmentInActivePath || fragmentInHoveredPath;
      }
      /**
       * Checks if the given editable is mapped
       * @param {object} editableValues
       * @private
       * @return {boolean}
       * @review
       */

    }, {
      key: "_isMapped",
      value: function _isMapped(editableValues) {
        return Boolean(editableValues.mappedField || editableValues.classNameId && editableValues.classPK && editableValues.fieldId);
      }
      /**
       * Checks if the given editable is mapped to an asset entry
       * @param {object} editableValues
       * @private
       * @return {boolean}
       * @review
       */

    }, {
      key: "_isMappedToAssetEntry",
      value: function _isMappedToAssetEntry(editableValues) {
        return Boolean(editableValues.classNameId && editableValues.classPK && editableValues.fieldId);
      }
    }]);

    return FragmentEditableField;
  }(_PortletBase2.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FragmentEditableField = FragmentEditableField;
  FragmentEditableField.STATE = {
    /**
     * Editable content to be rendered
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    content: _metalState.Config.string().required(),

    /**
     * Editable ID
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    editableId: _metalState.Config.string().required(),

    /**
     * Editable values
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!object}
     */
    editableValues: _metalState.Config.object().required(),

    /**
     * FragmentEntryLink id
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    fragmentEntryLinkId: _metalState.Config.string().required(),

    /**
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    processor: _metalState.Config.string().required(),

    /**
     * Set of options that are sent to the processors.
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!object}
     */
    processorsOptions: _metalState.Config.object().required(),

    /**
     * Editable type
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    type: _metalState.Config.oneOf(['html', 'image', 'link', 'rich-text', 'text']).required(),

    /**
     * Internal FloatingToolbar instance.
     * @default null
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {object|null}
     */
    _floatingToolbar: _metalState.Config.internal().value(null),

    /**
     * Translated label of the mapped field
     * @instance
     * @memberOf FragmentEditableField
     * @private
     * @review
     * @type {string}
     */
    _mappedFieldLabel: _metalState.Config.internal().string(),

    /**
     * Mapped asset field value
     * @instance
     * @memberOf FragmentEditableField
     * @private
     * @review
     * @type {string}
     */
    _mappedFieldValue: _metalState.Config.internal().string(),

    /**
     * Prevent editable click effect
     * @instance
     * @memberOf FragmentEditableField
     * @private
     * @review
     * @type {boolean}
     */
    _preventEditableClick: _metalState.Config.bool().value()
  };
  var ConnectedFragmentEditableField = (0, _ConnectedComponent.getConnectedComponent)(FragmentEditableField, ['activeItemId', 'activeItemType', 'defaultLanguageId', 'defaultSegmentsExperienceId', 'fragmentEditorClear', 'fragmentEditorEnabled', 'getAssetFieldValueURL', 'getAssetMappingFieldsURL', 'hoveredItemId', 'hoveredItemType', 'languageId', 'layoutData', 'mappingFieldsURL', 'portletNamespace', 'segmentsExperienceId', 'selectedMappingTypes']);
  exports.ConnectedFragmentEditableField = ConnectedFragmentEditableField;

  _metalSoy.default.register(ConnectedFragmentEditableField, _FragmentEditableField.default);

  var _default = ConnectedFragmentEditableField;
  exports.default = _default;
  //# sourceMappingURL=FragmentEditableField.es.js.map
});
//# sourceMappingURL=FragmentEditableField.es.js.map