"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/fragment_entry_link/FragmentEditableBackgroundImage.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-component', '../../store/store.es', '../../utils/constants', '../fragment_processors/EditableBackgroundImageProcessor.es', './FragmentEditableFieldTooltip.es', '../../store/ConnectedComponent.es', '../../utils/prefixSegmentsExperienceId.es', '../../actions/updateEditableValue.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.FragmentEditableBackgroundImage = exports.ConnectedFragmentEditableBackgroundImage = void 0;

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _store = require("../../store/store.es");

  var _constants = require("../../utils/constants");

  var _EditableBackgroundImageProcessor = _interopRequireDefault(require("../fragment_processors/EditableBackgroundImageProcessor.es"));

  var _FragmentEditableFieldTooltip = _interopRequireDefault(require("./FragmentEditableFieldTooltip.es"));

  var _ConnectedComponent = _interopRequireDefault(require("../../store/ConnectedComponent.es"));

  var _prefixSegmentsExperienceId = require("../../utils/prefixSegmentsExperienceId.es");

  var _updateEditableValue = require("../../actions/updateEditableValue.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var TOOLTIP_BUTTON_IDS = {
    map: 'map',
    remove: 'remove',
    select: 'select'
  };
  /**
   * FragmentEditableBackgroundImage
   */

  var FragmentEditableBackgroundImage =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FragmentEditableBackgroundImage, _Component);

    function FragmentEditableBackgroundImage() {
      _classCallCheck(this, FragmentEditableBackgroundImage);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentEditableBackgroundImage).apply(this, arguments));
    }

    _createClass(FragmentEditableBackgroundImage, [{
      key: "created",

      /**
       * @inheritDoc
       * @review
       */
      value: function created() {
        this._handleClick = this._handleClick.bind(this);
        this._handleOutsideTooltipClick = this._handleOutsideTooltipClick.bind(this);
        this._handleSelectBackgroundImage = this._handleSelectBackgroundImage.bind(this);
        this._handleTooltipButtonClick = this._handleTooltipButtonClick.bind(this);
        this.element.addEventListener('click', this._handleClick);
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this.element.removeEventListener('click', this._handleClick);

        this._disposeTooltip();
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncEditableValues",
      value: function syncEditableValues() {
        this._renderBackgroundImage();
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncDefaultLanguageId",
      value: function syncDefaultLanguageId() {
        this._renderBackgroundImage();
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_disposeTooltip",
      value: function _disposeTooltip() {
        if (this._tooltip) {
          this._tooltip.dispose();

          this._tooltip = null;
        }
      }
      /**
       * Get background image translated value
       * @private
       * @review
       */

    }, {
      key: "_getBackgroundImageValue",
      value: function _getBackgroundImageValue() {
        var defaultSegmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.defaultSegmentsExperienceId);
        var segmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.segmentsExperienceId);
        var segmentedValue = this.editableValues[segmentsExperienceId] || this.editableValues[defaultSegmentsExperienceId] || this.editableValues;
        var translatedValue = segmentedValue[this.languageId] || segmentedValue[this.defaultLanguageId];
        return translatedValue;
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleClick",
      value: function _handleClick() {
        if (this._tooltip) {
          this._disposeTooltip();
        } else {
          this._tooltip = new _FragmentEditableFieldTooltip.default({
            alignElement: this.element,
            buttons: FragmentEditableBackgroundImage.getButtons(this.showMapping, this._getBackgroundImageValue()),
            store: this.store
          });

          this._tooltip.on('buttonClick', this._handleTooltipButtonClick);

          this._tooltip.on('outsideTooltipClick', this._handleOutsideTooltipClick);
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleOutsideTooltipClick",
      value: function _handleOutsideTooltipClick() {
        this._disposeTooltip();
      }
      /**
       * @param {string} backgroundImageURL
       * @private
       * @review
       */

    }, {
      key: "_handleSelectBackgroundImage",
      value: function _handleSelectBackgroundImage(backgroundImageURL) {
        this._updateBackgroundImage(backgroundImageURL);
      }
      /**
       * Handles click events for tooltip buttons.
       * @param {object} event The tooltip button click.
       */

    }, {
      key: "_handleTooltipButtonClick",
      value: function _handleTooltipButtonClick(event) {
        var _this = this;

        if (event.buttonId === TOOLTIP_BUTTON_IDS.select) {
          _EditableBackgroundImageProcessor.default.init(this._handleSelectBackgroundImage, this.imageSelectorURL, this.portletNamespace);
        } else if (event.buttonId === TOOLTIP_BUTTON_IDS.remove) {
          this._updateBackgroundImage('');

          requestAnimationFrame(function () {
            _this._disposeTooltip();
          });
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_renderBackgroundImage",
      value: function _renderBackgroundImage() {
        var translatedValue = this._getBackgroundImageValue();

        _EditableBackgroundImageProcessor.default.render(this.element, translatedValue);
      }
      /**
       * Dispatches action to update editableValues with new background image url
       * @param {string} backgroundImageURL
       */

    }, {
      key: "_updateBackgroundImage",
      value: function _updateBackgroundImage(backgroundImageURL) {
        var defaultSegmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.defaultSegmentsExperienceId);
        var segmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.segmentsExperienceId);
        this.store.dispatch((0, _updateEditableValue.updateEditableValueAction)(this.fragmentEntryLinkId, this.editableId, this.languageId || _constants.DEFAULT_LANGUAGE_ID_KEY, backgroundImageURL, segmentsExperienceId || defaultSegmentsExperienceId, _constants.BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR));
      }
    }], [{
      key: "getButtons",

      /**
       * Returns the list of buttons to be shown inside the tooltip.
       * @param {boolean} showMapping
       * @param {boolean} showRemoveButton
       * @return {Array<{id: string, label: string}>}
       * @review
       */
      value: function getButtons(showMapping, showRemoveButton) {
        var buttons = [{
          icon: 'pencil',
          id: TOOLTIP_BUTTON_IDS.select,
          label: Liferay.Language.get('select-background')
        }];

        if (showMapping) {
          buttons.push({
            icon: 'bolt',
            id: TOOLTIP_BUTTON_IDS.map,
            label: Liferay.Language.get('map-background')
          });
        }

        if (showRemoveButton) {
          buttons.push({
            icon: 'times-circle',
            id: TOOLTIP_BUTTON_IDS.remove,
            label: Liferay.Language.get('remove-background')
          });
        }

        return buttons;
      }
    }]);

    return FragmentEditableBackgroundImage;
  }(_metalComponent.default);
  /**
   * State definition.
   * @static
   * @type {!Object}
   */

  exports.FragmentEditableBackgroundImage = FragmentEditableBackgroundImage;
  FragmentEditableBackgroundImage.STATE = {
    /**
     * FragmentEntryLink id
     * @default undefined
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @review
     * @type {!string}
     */
    fragmentEntryLinkId: _metalState.Config.string().required(),

    /**
     * Editable ID
     * @default undefined
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @review
     * @type {!string}
     */
    editableId: _metalState.Config.string().required(),

    /**
     * Editable values that should be used instead of the default ones inside
     * editable fields.
     * @default undefined
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @type {!Object}
     */
    editableValues: _metalState.Config.object().required(),

    /**
     * @default undefined
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @review
     * @type {!string}
     */
    processor: _metalState.Config.string().required(),

    /**
     * If <code>true</code>, the mapping is activated.
     * @default undefined
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @type {!boolean}
     */
    showMapping: _metalState.Config.bool().required(),

    /**
     * Store instance.
     * @default undefined
     * @instance
     * @memberOf FragmentEditableBackgroundImage
     * @type {Store}
     */
    store: _metalState.Config.instanceOf(_store.Store)
  };
  var ConnectedFragmentEditableBackgroundImage = (0, _ConnectedComponent.default)(FragmentEditableBackgroundImage, ['defaultLanguageId', 'defaultSegmentsExperienceId', 'imageSelectorURL', 'languageId', 'portletNamespace', 'segmentsExperienceId']);
  exports.ConnectedFragmentEditableBackgroundImage = ConnectedFragmentEditableBackgroundImage;
  var _default = ConnectedFragmentEditableBackgroundImage;
  exports.default = _default;
  //# sourceMappingURL=FragmentEditableBackgroundImage.es.js.map
});
//# sourceMappingURL=FragmentEditableBackgroundImage.es.js.map