"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/floating_toolbar/spacing/FloatingToolbarSpacingPanel.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-checkbox', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './FloatingToolbarSpacingPanelDelegateTemplate.soy', '../../../utils/rowConstants', '../../../store/ConnectedComponent.es', './FloatingToolbarSpacingPanel.soy', '../../../utils/FragmentsEditorUpdateUtils.es', '../../../actions/updateRowColumnsNumber.es', '../../../actions/actions.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.FloatingToolbarSpacingPanel = void 0;

  require("frontend-taglib-clay$clay-checkbox");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

  require("./FloatingToolbarSpacingPanelDelegateTemplate.soy");

  var _rowConstants = require("../../../utils/rowConstants");

  var _ConnectedComponent = _interopRequireDefault(require("../../../store/ConnectedComponent.es"));

  var _FloatingToolbarSpacingPanel = _interopRequireDefault(require("./FloatingToolbarSpacingPanel.soy"));

  var _FragmentsEditorUpdateUtils = require("../../../utils/FragmentsEditorUpdateUtils.es");

  var _updateRowColumnsNumber = require("../../../actions/updateRowColumnsNumber.es");

  var _actions = require("../../../actions/actions.es");

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj.default = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * FloatingToolbarSpacingPanel
   */
  var FloatingToolbarSpacingPanel =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FloatingToolbarSpacingPanel, _Component);

    function FloatingToolbarSpacingPanel() {
      _classCallCheck(this, FloatingToolbarSpacingPanel);

      return _possibleConstructorReturn(this, _getPrototypeOf(FloatingToolbarSpacingPanel).apply(this, arguments));
    }

    _createClass(FloatingToolbarSpacingPanel, [{
      key: "_handleColumnSpacingOptionChange",

      /**
       * Handle container option change
       * @param {Event} event
       */
      value: function _handleColumnSpacingOptionChange(event) {
        this._updateRowConfig(_defineProperty({}, _rowConstants.CONFIG_KEYS.columnSpacing, event.target.checked));
      }
      /**
       * Handle container spacing checkbox mousedown
       * @param {Event} event
       */

    }, {
      key: "_handleColumnSpacingOptionMousedown",
      value: function _handleColumnSpacingOptionMousedown(event) {
        event.preventDefault();
      }
      /**
       * Handle container option change
       * @param {Event} event
       */

    }, {
      key: "_handleContainerPaddingOptionChange",
      value: function _handleContainerPaddingOptionChange(event) {
        var delegateTarget = event.delegateTarget;
        var paddingDirectionId = delegateTarget.dataset.paddingDirectionId;
        var value = delegateTarget.value;

        this._updateRowConfig(_defineProperty({}, _rowConstants.CONFIG_KEYS["padding".concat(paddingDirectionId)], value));
      }
      /**
       * Handle container option change
       * @param {Event} event
       */

    }, {
      key: "_handleContainerTypeOptionChange",
      value: function _handleContainerTypeOptionChange(event) {
        this._updateRowConfig(_defineProperty({}, _rowConstants.CONFIG_KEYS.containerType, event.delegateTarget.value));
      }
      /**
       * Handle number of columns option change
       * @param {Event} event
       */

    }, {
      key: "_handleNumberOfColumnsOptionChange",
      value: function _handleNumberOfColumnsOptionChange(event) {
        var newValue = event.delegateTarget.value;
        var prevValue = this.item.columns.length;
        var updateRowColumns = true;

        if (newValue < prevValue) {
          var columnsToRemove = this.item.columns.slice(newValue - prevValue);
          var showConfirmation;

          for (var i = 0; i < columnsToRemove.length; i++) {
            if (columnsToRemove[i].fragmentEntryLinkIds.length > 0) {
              showConfirmation = true;
              break;
            }
          }

          if (showConfirmation && !confirm(Liferay.Language.get('reducing-the-number-of-columns-will-lose-the-content-added-to-the-deleted-columns-are-you-sure-you-want-to-proceed'))) {
            event.preventDefault();
            event.delegateTarget.querySelector("option[value=\"".concat(prevValue, "\"]")).selected = true;
            updateRowColumns = false;
          }
        }

        if (updateRowColumns) {
          this.store.dispatch((0, _updateRowColumnsNumber.updateRowColumnsNumberAction)(event.delegateTarget.value, this.itemId));
        }
      }
      /**
       * Updates row configuration
       * @param {object} config Row configuration
       * @private
       * @review
       */

    }, {
      key: "_updateRowConfig",
      value: function _updateRowConfig(config) {
        (0, _FragmentsEditorUpdateUtils.updateRow)(this.store, _actions.UPDATE_ROW_CONFIG, {
          config: config,
          rowId: this.itemId
        });
      }
    }]);

    return FloatingToolbarSpacingPanel;
  }(_metalComponent.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FloatingToolbarSpacingPanel = FloatingToolbarSpacingPanel;
  FloatingToolbarSpacingPanel.STATE = {
    /**
     * @default CONTAINER_TYPES
     * @memberOf FloatingToolbarSpacingPanel
     * @private
     * @review
     * @type {object[]}
     */
    _containerTypes: _metalSoy.Config.array().internal().value(_rowConstants.CONTAINER_TYPES),

    /**
     * @default CONTAINER_TYPES
     * @memberOf FloatingToolbarSpacingPanel
     * @private
     * @review
     * @type {object[]}
     */
    _numberOfColumnsOptions: _metalSoy.Config.array().internal().value(_rowConstants.NUMBER_OF_COLUMNS_OPTIONS),

    /**
     * @default PADDING_OPTIONS
     * @memberOf FloatingToolbarSpacingPanel
     * @private
     * @review
     * @type {object[]}
     */
    _paddingOptions: _metalSoy.Config.array().internal().value(_rowConstants.PADDING_OPTIONS),

    /**
     * @default undefined
     * @memberof FloatingToolbarSpacingPanel
     * @review
     * @type {!string}
     */
    itemId: _metalSoy.Config.string().required(),

    /**
     * @default undefined
     * @memberof FloatingToolbarSpacingPanel
     * @review
     * @type {object}
     */
    store: _metalSoy.Config.object().value(null)
  };
  var ConnectedFloatingToolbarSpacingPanel = (0, _ConnectedComponent.default)(FloatingToolbarSpacingPanel, ['layoutData', 'spritemap']);

  _metalSoy.default.register(ConnectedFloatingToolbarSpacingPanel, _FloatingToolbarSpacingPanel.default);

  var _default = FloatingToolbarSpacingPanel;
  exports.default = _default;
  //# sourceMappingURL=FloatingToolbarSpacingPanel.es.js.map
});
//# sourceMappingURL=FloatingToolbarSpacingPanel.es.js.map