"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/floating_toolbar/mapping/FloatingToolbarMappingPanel.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-dropdown', 'frontend-js-web/liferay/PortletBase.es', 'frontend-js-metal-web$metal-soy', './FloatingToolbarMappingPanelDelegateTemplate.soy', '../../../actions/actions.es', '../../../utils/constants', '../../../utils/FragmentsEditorIdUtils.es', '../../../utils/FragmentsEditorDialogUtils', '../../../utils/FragmentsEditorUpdateUtils.es', '../../../actions/updateEditableValue.es', '../../../store/ConnectedComponent.es', './FloatingToolbarMappingPanel.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.FloatingToolbarMappingPanel = exports.ConnectedFloatingToolbarMappingPanel = void 0;

  require("frontend-taglib-clay$clay-dropdown");

  var _PortletBase2 = _interopRequireDefault(require("frontend-js-web/liferay/PortletBase.es"));

  var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

  require("./FloatingToolbarMappingPanelDelegateTemplate.soy");

  var _actions = require("../../../actions/actions.es");

  var _constants = require("../../../utils/constants");

  var _FragmentsEditorIdUtils = require("../../../utils/FragmentsEditorIdUtils.es");

  var _FragmentsEditorDialogUtils = require("../../../utils/FragmentsEditorDialogUtils");

  var _FragmentsEditorUpdateUtils = require("../../../utils/FragmentsEditorUpdateUtils.es");

  var _updateEditableValue = require("../../../actions/updateEditableValue.es");

  var _ConnectedComponent = _interopRequireDefault(require("../../../store/ConnectedComponent.es"));

  var _FloatingToolbarMappingPanel = _interopRequireDefault(require("./FloatingToolbarMappingPanel.soy"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj.default = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var SOURCE_TYPE_IDS = {
    content: 'specific_content',
    structure: 'structure'
  };
  /**
   * FloatingToolbarMappingPanel
   */

  var FloatingToolbarMappingPanel =
  /*#__PURE__*/
  function (_PortletBase) {
    _inherits(FloatingToolbarMappingPanel, _PortletBase);

    function FloatingToolbarMappingPanel() {
      _classCallCheck(this, FloatingToolbarMappingPanel);

      return _possibleConstructorReturn(this, _getPrototypeOf(FloatingToolbarMappingPanel).apply(this, arguments));
    }

    _createClass(FloatingToolbarMappingPanel, [{
      key: "prepareStateForRender",

      /**
       * @inheritdoc
       * @param {object} state
       * @return {object}
       * @review
       */
      value: function prepareStateForRender(state) {
        var nextState = state;
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['mappedAssetEntries'], nextState.mappedAssetEntries.map(_FragmentsEditorIdUtils.encodeAssetId));
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_sourceTypeIds'], SOURCE_TYPE_IDS);

        if (nextState.mappingFieldsURL && nextState.selectedMappingTypes && nextState.selectedMappingTypes.type) {
          nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_sourceTypes'], FloatingToolbarMappingPanel._getSourceTypes(nextState.selectedMappingTypes.subtype ? nextState.selectedMappingTypes.subtype.label : nextState.selectedMappingTypes.type.label));
        }

        if (nextState.mappedAssetEntries && nextState.item.editableValues.classNameId && nextState.item.editableValues.classPK) {
          var mappedAssetEntry = nextState.mappedAssetEntries.find(function (assetEntry) {
            return nextState.item.editableValues.classNameId === assetEntry.classNameId && nextState.item.editableValues.classPK === assetEntry.classPK;
          });

          if (mappedAssetEntry) {
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['item', 'editableValues', 'title'], mappedAssetEntry.title);
            nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['item', 'editableValues', 'encodedId'], mappedAssetEntry);
          }
        }

        return nextState;
      }
      /**
       * @inheritdoc
       * @param {boolean} firstRender
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered(firstRender) {
        if (firstRender) {
          this._selectedSourceTypeId = SOURCE_TYPE_IDS.content;

          if (this.item && this.mappingFieldsURL && !this.item.editableValues.classNameId) {
            this._selectedSourceTypeId = SOURCE_TYPE_IDS.structure;
          }
        }
      }
      /**
       * @param {{editableValues: object}} newItem
       * @param {{editableValues: object}} [oldItem]
       * @inheritdoc
       * @review
       */

    }, {
      key: "syncItem",
      value: function syncItem(newItem, oldItem) {
        if (!oldItem || newItem.editableValues !== oldItem.editableValues) {
          this._loadFields();
        }
      }
      /**
       * Clears editable values
       * @private
       * @review
       */

    }, {
      key: "_clearEditableValues",
      value: function _clearEditableValues() {
        this.store.dispatch((0, _updateEditableValue.updateEditableValuesAction)(this.item.fragmentEntryLinkId, this.item.editableId, [{
          content: '',
          editableValueId: 'classNameId'
        }, {
          content: '',
          editableValueId: 'classPK'
        }, {
          content: '',
          editableValueId: 'fieldId'
        }, {
          content: '',
          editableValueId: 'mappedField'
        }]));
      }
      /**
       * Clears fields
       * @private
       * @review
       */

    }, {
      key: "_clearFields",
      value: function _clearFields() {
        this._fields = [];
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleAssetBrowserLinkClick",
      value: function _handleAssetBrowserLinkClick(event) {
        var _this = this;

        var _event$delegateTarget = event.delegateTarget.dataset,
            assetBrowserUrl = _event$delegateTarget.assetBrowserUrl,
            assetBrowserWindowTitle = _event$delegateTarget.assetBrowserWindowTitle;
        (0, _FragmentsEditorDialogUtils.openAssetBrowser)({
          assetBrowserURL: assetBrowserUrl,
          callback: function callback(selectedAssetEntry) {
            _this._selectAssetEntry(selectedAssetEntry);

            _this.store.dispatch(Object.assign({}, selectedAssetEntry, {
              type: _actions.ADD_MAPPED_ASSET_ENTRY
            }));

            requestAnimationFrame(function () {
              _this.refs.panel.focus();
            });
          },
          modalTitle: assetBrowserWindowTitle,
          portletNamespace: this.portletNamespace
        });
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleAssetEntryLinkClick",
      value: function _handleAssetEntryLinkClick(event) {
        var _this2 = this;

        var data = event.delegateTarget.dataset;

        this._selectAssetEntry({
          classNameId: data.classNameId,
          classPK: data.classPk
        });

        requestAnimationFrame(function () {
          _this2.refs.panel.focus();
        });
      }
      /**
       * Handle field option change
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleFieldOptionChange",
      value: function _handleFieldOptionChange(event) {
        var fieldId = event.delegateTarget.value;

        if (this._selectedSourceTypeId === SOURCE_TYPE_IDS.content) {
          this.store.dispatch((0, _updateEditableValue.updateEditableValuesAction)(this.item.fragmentEntryLinkId, this.item.editableId, [{
            content: fieldId,
            editableValueId: 'fieldId'
          }]));
        } else if (this._selectedSourceTypeId === SOURCE_TYPE_IDS.structure) {
          this.store.dispatch((0, _updateEditableValue.updateEditableValuesAction)(this.item.fragmentEntryLinkId, this.item.editableId, [{
            content: fieldId,
            editableValueId: 'mappedField'
          }]));
        }
      }
      /**
       * Handle source option change
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleSourceTypeChange",
      value: function _handleSourceTypeChange(event) {
        this._selectedSourceTypeId = event.delegateTarget.value;

        this._clearEditableValues();
      }
      /**
       * Load the list of fields
       * @private
       * @review
       */

    }, {
      key: "_loadFields",
      value: function _loadFields() {
        var _this3 = this;

        var promise;

        this._clearFields();

        if (this._selectedSourceTypeId === SOURCE_TYPE_IDS.structure) {
          var data = {
            classNameId: this.selectedMappingTypes.type.id
          };

          if (this.selectedMappingTypes.subtype) {
            data.classTypeId = this.selectedMappingTypes.subtype.id;
          }

          promise = this.fetch(this.mappingFieldsURL, data);
        } else if (this._selectedSourceTypeId === SOURCE_TYPE_IDS.content && this.item.editableValues.classNameId && this.item.editableValues.classPK) {
          promise = this.fetch(this.getAssetMappingFieldsURL, {
            classNameId: this.item.editableValues.classNameId,
            classPK: this.item.editableValues.classPK
          });
        }

        if (promise) {
          promise.then(function (response) {
            return response.json();
          }).then(function (response) {
            _this3._fields = response.filter(function (field) {
              return _constants.COMPATIBLE_TYPES[_this3.item.type].indexOf(field.type) !== -1;
            });
          });
        } else if (this._fields.length) {
          this._clearFields();
        }
      }
      /**
       * @param {object} assetEntry
       * @param {string} assetEntry.classNameId
       * @param {string} assetEntry.classPK
       * @private
       * @review
       */

    }, {
      key: "_selectAssetEntry",
      value: function _selectAssetEntry(assetEntry) {
        this.store.dispatch((0, _updateEditableValue.updateEditableValuesAction)(this.item.fragmentEntryLinkId, this.item.editableId, [{
          content: assetEntry.classNameId,
          editableValueId: 'classNameId'
        }, {
          content: assetEntry.classPK,
          editableValueId: 'classPK'
        }, {
          content: '',
          editableValueId: 'fieldId'
        }]));
      }
    }], [{
      key: "_getSourceTypes",

      /**
       * @param {string} subtypeLabel
       * @return {Array<{id: string, label: string}>} Source types
       * @private
       * @static
       * @review
       */
      value: function _getSourceTypes(subtypeLabel) {
        return [{
          id: SOURCE_TYPE_IDS.structure,
          label: Liferay.Util.sub(Liferay.Language.get('x-default'), subtypeLabel)
        }, {
          id: SOURCE_TYPE_IDS.content,
          label: Liferay.Language.get('specific-content')
        }];
      }
    }]);

    return FloatingToolbarMappingPanel;
  }(_PortletBase2.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {object}
   */

  exports.FloatingToolbarMappingPanel = FloatingToolbarMappingPanel;
  FloatingToolbarMappingPanel.STATE = {
    /**
     * @default undefined
     * @memberof FloatingToolbarMappingPanel
     * @review
     * @type {object}
     */
    item: _metalSoy.Config.required(),

    /**
     * @default undefined
     * @memberof FloatingToolbarMappingPanel
     * @review
     * @type {string}
     */
    itemId: _metalSoy.Config.string().required(),

    /**
     * @default []
     * @memberOf FloatingToolbarMappingPanel
     * @private
     * @review
     * @type {object[]}
     */
    _fields: _metalSoy.Config.array().internal().value([]),

    /**
     * @default undefined
     * @memberof FloatingToolbarMappingPanel
     * @review
     * @type {string}
     */
    _selectedSourceTypeId: _metalSoy.Config.oneOf(Object.values(SOURCE_TYPE_IDS)).internal()
  };
  var ConnectedFloatingToolbarMappingPanel = (0, _ConnectedComponent.default)(FloatingToolbarMappingPanel, ['assetBrowserLinks', 'getAssetMappingFieldsURL', 'mappedAssetEntries', 'mappingFieldsURL', 'portletNamespace', 'selectedMappingTypes', 'spritemap']);
  exports.ConnectedFloatingToolbarMappingPanel = ConnectedFloatingToolbarMappingPanel;

  _metalSoy.default.register(ConnectedFloatingToolbarMappingPanel, _FloatingToolbarMappingPanel.default);

  var _default = ConnectedFloatingToolbarMappingPanel;
  exports.default = _default;
  //# sourceMappingURL=FloatingToolbarMappingPanel.es.js.map
});
//# sourceMappingURL=FloatingToolbarMappingPanel.es.js.map