"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/components/floating_toolbar/FloatingToolbar.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-state', '../../store/ConnectedComponent.es', './FloatingToolbar.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.FloatingToolbar = exports.ConnectedFloatingToolbar = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalPosition = require("frontend-js-metal-web$metal-position");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _ConnectedComponent = _interopRequireDefault(require("../../store/ConnectedComponent.es"));

  var _FloatingToolbar = _interopRequireDefault(require("./FloatingToolbar.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * FloatingToolbar
   */
  var FloatingToolbar =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FloatingToolbar, _Component);

    function FloatingToolbar() {
      _classCallCheck(this, FloatingToolbar);

      return _possibleConstructorReturn(this, _getPrototypeOf(FloatingToolbar).apply(this, arguments));
    }

    _createClass(FloatingToolbar, [{
      key: "created",

      /**
       * @inheritdoc
       * @review
       */
      value: function created() {
        this._defaultButtonClicked = this._defaultButtonClicked.bind(this);
        this._handleWindowResize = this._handleWindowResize.bind(this);
        this._handleWrapperScroll = this._handleWrapperScroll.bind(this);
        window.addEventListener('resize', this._handleWindowResize);
        var wrapper = document.querySelector('.fragment-entry-link-list-wrapper');

        if (wrapper) {
          wrapper.addEventListener('scroll', this._handleWrapperScroll);
        }
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "attached",
      value: function attached() {
        this.addListener('buttonClicked', this._defaultButtonClicked, true);
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        window.removeEventListener('resize', this._handleWindowResize);
        var wrapper = document.querySelector('.fragment-entry-link-list-wrapper');

        if (wrapper) {
          wrapper.removeEventListener('scroll', this._handleWrapperScroll);
        }
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered() {
        var _this = this;

        this._align();

        requestAnimationFrame(function () {
          _this._align();
        });
      }
      /**
       * @param {string} selectedPanelId
       * @return {string}
       * @review
       */

    }, {
      key: "syncSelectedPanelId",
      value: function syncSelectedPanelId(selectedPanelId) {
        this._selectedPanel = this.buttons.find(function (button) {
          return button.panelId === selectedPanelId;
        });
        return selectedPanelId;
      }
      /**
       * Select or deselect panel. Default handler for button clicked event.
       * @param {Event} event
       * @param {Object} data
       * @private
       */

    }, {
      key: "_defaultButtonClicked",
      value: function _defaultButtonClicked(event, data) {
        var panelId = data.panelId;

        if (!event.defaultPrevented) {
          if (this.selectedPanelId === panelId) {
            this.selectedPanelId = null;
          } else {
            this.selectedPanelId = panelId;
          }
        }
      }
      /**
       * Handle panel button click
       * @param {MouseEvent} event Click event
       */

    }, {
      key: "_handlePanelButtonClick",
      value: function _handlePanelButtonClick(event) {
        var _event$delegateTarget = event.delegateTarget.dataset,
            _event$delegateTarget2 = _event$delegateTarget.panelId,
            panelId = _event$delegateTarget2 === void 0 ? null : _event$delegateTarget2,
            type = _event$delegateTarget.type;
        this.emit('buttonClicked', event, {
          panelId: panelId,
          type: type
        });
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleWindowResize",
      value: function _handleWindowResize() {
        this._align();
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleWrapperScroll",
      value: function _handleWrapperScroll() {
        this._align();
      }
      /**
       * Aligns the FloatingToolbar to the anchorElement
       * @private
       * @review
       */

    }, {
      key: "_align",
      value: function _align() {
        var _this2 = this;

        var panelPosition = {
          fallback: _metalPosition.Align.TopRight,
          preferred: _metalPosition.Align.BottomRight
        };
        var languageDirection = Liferay.Language.direction[Liferay.ThemeDisplay.getLanguageId()];

        if (languageDirection === 'rtl') {
          panelPosition = {
            fallback: _metalPosition.Align.TopLeft,
            preferred: _metalPosition.Align.BottomLeft
          };
        }

        requestAnimationFrame(function () {
          FloatingToolbar._alignElement(_this2.refs.buttons, _this2.anchorElement, panelPosition.preferred, panelPosition.fallback);

          requestAnimationFrame(function () {
            _this2._alignPanel(panelPosition);
          });
        });
      }
      /**
       * Aligns the FloatingToolbar panel to the buttons
       * @param {{ fallback: string, preferred: string }} panelPosition
       * @private
       * @review
       */

    }, {
      key: "_alignPanel",
      value: function _alignPanel(panelPosition) {
        FloatingToolbar._alignElement(this.refs.panel, this.refs.buttons, panelPosition.preferred, panelPosition.fallback);
      }
    }], [{
      key: "_alignElement",

      /**
       * Aligns the given element to the anchor,
       * defaulting to BottomRight position and moving to
       * TopRight if it does not fit.
       * @param {HTMLElement|null} element
       * @param {HTMLElement|null} anchor
       * @param {number} preferredPosition
       * @param {number} fallbackPosition
       * @private
       * @return {number} Selected position
       * @review
       */
      value: function _alignElement(element, anchor, preferredPosition, fallbackPosition) {
        var position = -1;

        if (element && anchor) {
          var suggestedAlign = _metalPosition.Align.suggestAlignBestRegion(element, anchor, preferredPosition);

          position = suggestedAlign.position === preferredPosition ? preferredPosition : fallbackPosition;

          _metalPosition.Align.align(element, anchor, position, false);
        }

        return position;
      }
    }]);

    return FloatingToolbar;
  }(_metalComponent.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FloatingToolbar = FloatingToolbar;
  FloatingToolbar.STATE = {
    /**
     * Selected panel
     * @default null
     * @instance
     * @memberof FloatingToolbar
     * @review
     * @type {object|null}
     */
    _selectedPanel: _metalState.Config.object().internal().value(null),

    /**
     * Element where the floating toolbar is positioned with
     * @default undefined
     * @instance
     * @memberof FloatingToolbar
     * @review
     * @type {HTMLElement}
     */
    anchorElement: _metalState.Config.instanceOf(HTMLElement).required(),

    /**
     * List of available buttons.
     * @default undefined
     * @instance
     * @memberOf FloatingToolbar
     * @review
     * @type {object[]}
     */
    buttons: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      icon: _metalState.Config.string(),
      id: _metalState.Config.string(),
      panelId: _metalState.Config.string(),
      title: _metalState.Config.string(),
      type: _metalState.Config.string()
    })).required(),

    /**
     * If true, once a panel has been selected it cannot be changed
     * until selectedPanelId is set manually to null.
     * @default false
     * @instance
     * @memberof FloatingToolbar
     * @review
     * @type {boolean}
     */
    fixSelectedPanel: _metalState.Config.bool().value(false),

    /**
     * Selected panel ID.
     * @default null
     * @instance
     * @memberOf FloatingToolbar
     * @private
     * @review
     * @type {string|null}
     */
    selectedPanelId: _metalState.Config.string().internal().value(null)
  };
  var ConnectedFloatingToolbar = (0, _ConnectedComponent.default)(FloatingToolbar, ['spritemap']);
  exports.ConnectedFloatingToolbar = ConnectedFloatingToolbar;

  _metalSoy.default.register(ConnectedFloatingToolbar, _FloatingToolbar.default);

  var _default = ConnectedFloatingToolbar;
  exports.default = _default;
  //# sourceMappingURL=FloatingToolbar.es.js.map
});
//# sourceMappingURL=FloatingToolbar.es.js.map