"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/actions/updateRowColumns.es", ['module', 'exports', 'require', './saveChanges.es', '../utils/FragmentsEditorGetUtils.es', '../utils/FragmentsEditorUpdateUtils.es', './actions.es', '../utils/FragmentsEditorFetchUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.updateRowColumnsAction = updateRowColumnsAction;

  var _saveChanges = require("./saveChanges.es");

  var _FragmentsEditorGetUtils = require("../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  var _actions = require("./actions.es");

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  /**
   * @param {Array} columns
   * @param {string} rowId
   * @return {function}
   * @review
   */
  function updateRowColumnsAction(columns, rowId) {
    return function (dispatch, getState) {
      var state = getState();
      var rowIndex = (0, _FragmentsEditorGetUtils.getRowIndex)(state.layoutData.structure, rowId);
      var previousData = state.layoutData;
      var nextData = previousData;

      if (rowIndex !== -1) {
        nextData = (0, _FragmentsEditorUpdateUtils.setIn)(previousData, ['structure', rowIndex.toString(), 'columns'], columns);
      }

      dispatch(updateRowColumnsLoadingAction(nextData));
      dispatch((0, _saveChanges.enableSavingChangesStatusAction)());
      (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextData, state.segmentsExperienceId).then(function () {
        dispatch(updateRowColumnsSuccessAction());
        dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
        dispatch((0, _saveChanges.updateLastSaveDateAction)());
      }).catch(function () {
        dispatch(updateRowColumnsErrorAction(previousData));
        dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
      });
    };
  }
  /**
   * @param {Array} layoutData
   * @return {object}
   * @review
   */

  function updateRowColumnsErrorAction(layoutData) {
    return {
      layoutData: layoutData,
      type: _actions.UPDATE_ROW_COLUMNS_ERROR
    };
  }
  /**
   * @param {Array} layoutData
   * @return {object}
   * @review
   */

  function updateRowColumnsLoadingAction(layoutData) {
    return {
      layoutData: layoutData,
      type: _actions.UPDATE_ROW_COLUMNS_LOADING
    };
  }
  /**
   * @return {object}
   * @review
   */

  function updateRowColumnsSuccessAction() {
    return {
      type: _actions.UPDATE_ROW_COLUMNS_SUCCESS
    };
  }
  //# sourceMappingURL=updateRowColumns.es.js.map
});
//# sourceMappingURL=updateRowColumns.es.js.map