"use strict";

Liferay.Loader.define("layout-content-page-editor-web@1.0.20/js/FragmentsEditor.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './components/mapping_type/SelectMappingDialog.es', './components/mapping_type/SelectMappingTypeDialog.es', './components/fragment_entry_link/FragmentEntryLinkList.es', './components/sidebar/FragmentsEditorSidebar.es', './components/toolbar/FragmentsEditorToolbar.es', './actions/actions.es', './store/state.es', './utils/FragmentsEditorDialogUtils', './store/store.es', './FragmentsEditor.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.FragmentsEditor = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  require("./components/mapping_type/SelectMappingDialog.es");

  require("./components/mapping_type/SelectMappingTypeDialog.es");

  require("./components/fragment_entry_link/FragmentEntryLinkList.es");

  require("./components/sidebar/FragmentsEditorSidebar.es");

  require("./components/toolbar/FragmentsEditorToolbar.es");

  var _actions = require("./actions/actions.es");

  var _state = require("./store/state.es");

  var _FragmentsEditorDialogUtils = require("./utils/FragmentsEditorDialogUtils");

  var _store = require("./store/store.es");

  var _FragmentsEditor = _interopRequireDefault(require("./FragmentsEditor.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * FragmentsEditor
   * @review
   */
  var FragmentsEditor =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FragmentsEditor, _Component);

    function FragmentsEditor() {
      _classCallCheck(this, FragmentsEditor);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentsEditor).apply(this, arguments));
    }

    _createClass(FragmentsEditor, [{
      key: "created",

      /**
       * @inheritdoc
       * @review
       */
      value: function created() {
        this._handleDocumentClick = this._handleDocumentClick.bind(this);
        this._handleDocumentKeyUp = this._handleDocumentKeyUp.bind(this);
        this._handleDocumentMouseOver = this._handleDocumentMouseOver.bind(this);
        document.addEventListener('click', this._handleDocumentClick, true);
        document.addEventListener('keyup', this._handleDocumentKeyUp);
        document.addEventListener('mouseover', this._handleDocumentMouseOver);
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        document.removeEventListener('click', this._handleDocumentClick, true);
        document.removeEventListener('keyup', this._handleDocumentKeyUp);
        document.removeEventListener('mouseover', this._handleDocumentMouseOver);
        (0, _FragmentsEditorDialogUtils.stopListeningWidgetConfigurationChange)();
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "syncStore",
      value: function syncStore() {
        if (this.store) {
          (0, _FragmentsEditorDialogUtils.startListeningWidgetConfigurationChange)(this.store);
        }
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDocumentClick",
      value: function _handleDocumentClick(event) {
        this._updateActiveItem(event);
      }
      /**
       * @param {KeyboardEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDocumentKeyUp",
      value: function _handleDocumentKeyUp(event) {
        this._updateActiveItem(event);
      }
      /**
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDocumentMouseOver",
      value: function _handleDocumentMouseOver(event) {
        var _FragmentsEditor$_get = FragmentsEditor._getItemTarget(event),
            fragmentsEditorItemId = _FragmentsEditor$_get.fragmentsEditorItemId,
            fragmentsEditorItemType = _FragmentsEditor$_get.fragmentsEditorItemType;

        if (fragmentsEditorItemId && fragmentsEditorItemType && this.store) {
          this.store.dispatch({
            hoveredItemId: fragmentsEditorItemId,
            hoveredItemType: fragmentsEditorItemType,
            type: _actions.UPDATE_HOVERED_ITEM
          });
        } else if (this.store) {
          this.store.dispatch({
            type: _actions.CLEAR_HOVERED_ITEM
          });
        }
      }
      /**
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: "_updateActiveItem",
      value: function _updateActiveItem(event) {
        if (this._activeElement !== document.activeElement) {
          var _FragmentsEditor$_get2 = FragmentsEditor._getItemTarget(event),
              fragmentsEditorItemId = _FragmentsEditor$_get2.fragmentsEditorItemId,
              fragmentsEditorItemType = _FragmentsEditor$_get2.fragmentsEditorItemType;

          if (fragmentsEditorItemId && fragmentsEditorItemType) {
            this.store.dispatch({
              activeItemId: fragmentsEditorItemId,
              activeItemType: fragmentsEditorItemType,
              type: _actions.UPDATE_ACTIVE_ITEM
            });
          } else if (event.target instanceof HTMLElement && event.target.parentElement !== document.body && !_metalDom.default.closest(event.target, '.modal')) {
            this.store.dispatch({
              type: _actions.CLEAR_ACTIVE_ITEM
            });
          }
        }

        this._activeElement = document.activeElement;
      }
    }], [{
      key: "_getItemTarget",

      /**
       * @param {MouseEvent} event
       * @return {{fragmentsEditorItemId: string|null, fragmentsEditorItemType: string|null}}
       * @private
       * @review
       */
      value: function _getItemTarget(event) {
        var _ref = event.target.dataset || {},
            _ref$fragmentsEditorI = _ref.fragmentsEditorItemId,
            fragmentsEditorItemId = _ref$fragmentsEditorI === void 0 ? null : _ref$fragmentsEditorI,
            _ref$fragmentsEditorI2 = _ref.fragmentsEditorItemType,
            fragmentsEditorItemType = _ref$fragmentsEditorI2 === void 0 ? null : _ref$fragmentsEditorI2;

        if (!fragmentsEditorItemId || !fragmentsEditorItemType) {
          var parent = _metalDom.default.closest(event.target, '[data-fragments-editor-item-id]');

          if (parent) {
            fragmentsEditorItemId = parent.dataset.fragmentsEditorItemId;
            fragmentsEditorItemType = parent.dataset.fragmentsEditorItemType;
          }
        }

        return {
          fragmentsEditorItemId: fragmentsEditorItemId,
          fragmentsEditorItemType: fragmentsEditorItemType
        };
      }
    }]);

    return FragmentsEditor;
  }(_metalComponent.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {object}
   */

  exports.FragmentsEditor = FragmentsEditor;
  FragmentsEditor.STATE = Object.assign({
    /**
     * Previous document active element
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {object}
     */
    _activeElement: _metalState.Config.object(),

    /**
     * Store instance
     * @default undefined
     * @instance
     * @memberOf FragmentsEditor
     * @review
     * @type {Store}
     */
    store: _metalState.Config.instanceOf(_store.Store)
  }, _state.INITIAL_STATE);

  _metalSoy.default.register(FragmentsEditor, _FragmentsEditor.default);

  var _default = FragmentsEditor;
  exports.default = _default;
  //# sourceMappingURL=FragmentsEditor.es.js.map
});
//# sourceMappingURL=FragmentsEditor.es.js.map