/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.content.page.editor.web.internal.portlet.action;

import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.servlet.MultiSessionMessages;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet", "mvc.command.name=/content_layout/publish_layout_page_template_entry"}, service={MVCActionCommand.class})
public class PublishLayoutPageTemplateEntryMVCActionCommand
extends BaseMVCActionCommand {
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private Portal _portal;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        PublishLayoutPageTemplateEntryCallable publishLayoutCallable = new PublishLayoutPageTemplateEntryCallable(actionRequest);
        try {
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)publishLayoutCallable);
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
        this.sendRedirect(actionRequest, actionResponse);
    }

    private class PublishLayoutPageTemplateEntryCallable
    implements Callable<Void> {
        private final ActionRequest _actionRequest;

        @Override
        public Void call() throws Exception {
            long draftPlid = ParamUtil.getLong((PortletRequest)this._actionRequest, (String)"classPK");
            Layout draftLayout = PublishLayoutPageTemplateEntryMVCActionCommand.this._layoutLocalService.getLayout(draftPlid);
            Layout layout = PublishLayoutPageTemplateEntryMVCActionCommand.this._layoutLocalService.getLayout(draftLayout.getClassPK());
            ThemeDisplay themeDisplay = (ThemeDisplay)this._actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            LayoutPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE");
            LayoutPageTemplateEntry layoutPageTemplateEntry = PublishLayoutPageTemplateEntryMVCActionCommand.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(draftLayout.getClassPK());
            PublishLayoutPageTemplateEntryMVCActionCommand.this._layoutCopyHelper.copyLayout(draftLayout, layout);
            PublishLayoutPageTemplateEntryMVCActionCommand.this._layoutPageTemplateEntryService.updateStatus(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), 0);
            PublishLayoutPageTemplateEntryMVCActionCommand.this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), new Date());
            String portletId = PublishLayoutPageTemplateEntryMVCActionCommand.this._portal.getPortletId((PortletRequest)this._actionRequest);
            if (SessionMessages.contains((PortletRequest)this._actionRequest, (String)portletId.concat(".hideDefaultSuccessMessage"))) {
                SessionMessages.clear((PortletRequest)this._actionRequest);
            }
            String key = "layoutPageTemplatePublished";
            if (layoutPageTemplateEntry.getType() == 1) {
                key = "displayPagePublished";
            }
            MultiSessionMessages.add((PortletRequest)this._actionRequest, (String)key);
            return null;
        }

        private PublishLayoutPageTemplateEntryCallable(ActionRequest actionRequest) {
            this._actionRequest = actionRequest;
        }
    }
}

