/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.content.page.editor.web.internal.portlet.action;

import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.concurrent.Callable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet", "mvc.command.name=/content_layout/discard_draft_layout"}, service={MVCActionCommand.class})
public class DiscardDraftLayoutMVCActionCommand
extends BaseMVCActionCommand {
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private Portal _portal;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        DiscardDraftLayoutCallable discardDraftLayoutCallable = new DiscardDraftLayoutCallable(actionRequest);
        try {
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)discardDraftLayoutCallable);
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
        this.sendRedirect(actionRequest, actionResponse);
    }

    private class DiscardDraftLayoutCallable
    implements Callable<Void> {
        private final ActionRequest _actionRequest;

        @Override
        public Void call() throws Exception {
            LayoutPageTemplateEntry layoutPageTemplateEntry;
            ThemeDisplay themeDisplay = (ThemeDisplay)this._actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long plid = ParamUtil.getLong((PortletRequest)this._actionRequest, (String)"classPK");
            LayoutPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (long)plid, (String)"UPDATE");
            Layout draftLayout = DiscardDraftLayoutMVCActionCommand.this._layoutLocalService.getLayout(plid);
            if (draftLayout.getClassPK() == 0L || DiscardDraftLayoutMVCActionCommand.this._portal.getClassNameId(Layout.class) != draftLayout.getClassNameId()) {
                return null;
            }
            Layout layout = DiscardDraftLayoutMVCActionCommand.this._layoutLocalService.getLayout(draftLayout.getClassPK());
            int fragmentEntryLinksCount = DiscardDraftLayoutMVCActionCommand.this._fragmentEntryLinkLocalService.getClassedModelFragmentEntryLinksCount(layout.getGroupId(), DiscardDraftLayoutMVCActionCommand.this._portal.getClassNameId(Layout.class), layout.getPlid());
            if (fragmentEntryLinksCount == 0 && layout.getClassNameId() == DiscardDraftLayoutMVCActionCommand.this._portal.getClassNameId(LayoutPageTemplateEntry.class) && (layoutPageTemplateEntry = DiscardDraftLayoutMVCActionCommand.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layout.getClassPK())) != null) {
                layout = DiscardDraftLayoutMVCActionCommand.this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
            }
            if ((layoutPageTemplateEntry = DiscardDraftLayoutMVCActionCommand.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getPlid())) != null) {
                LayoutPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (long)layout.getPlid(), (String)"UPDATE");
                UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
                long classNameId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("assetClassNameId"));
                long classTypeId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("assetClassTypeId"));
                DiscardDraftLayoutMVCActionCommand.this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), classNameId, classTypeId);
            }
            LayoutPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (long)layout.getPlid(), (String)"VIEW");
            draftLayout = DiscardDraftLayoutMVCActionCommand.this._layoutCopyHelper.copyLayout(layout, draftLayout);
            draftLayout.setModifiedDate(layout.getPublishDate());
            DiscardDraftLayoutMVCActionCommand.this._layoutLocalService.updateLayout(draftLayout);
            return null;
        }

        private DiscardDraftLayoutCallable(ActionRequest actionRequest) {
            this._actionRequest = actionRequest;
        }
    }
}

